@extends('user.layout')
@section('page-style')
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
@endsection
@section('content')
    <div class="page-header">
        <h4 class="page-title">{{ __('WHM') }}</h4>

    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block">{{ __('WHM') }}</div>
                        </div>
                        <div class="col-md-8" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addWhmbtn">Add WHM</button>
                        </div>
                    </div>
                </div>
                <div class="card-body">

                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-stripped" id="dataTable">
                                    <thead>
                                        <th>Whm Host</th>
                                        <th>Type</th>
                                        <th>Action</th>
                                    </thead>
                                    <tbody>
                                        @if (!$whms->isEmpty())
                                            @foreach ($whms as $whm)
                                                <tr>
                                                    <td>
                                                        {{$whm->ip}}
                                                    </td>
                                                    <td>
                                                        {{ucfirst($whm->whm_type)}}
                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary edit" data-type="{{$whm->whm_type}}" data-id="{{$whm->id}}" data-key="{{$whm->api_key}}" data-ip="{{$whm->ip}}">
                                                            Edit
                                                        </button>
                                                        <button class="btn btn-sm btn-danger remove" data-id="{{$whm->id}}">
                                                            Delete
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>



                </div>
            </div>
        </div>
    </div>

     <div class="modal fade" id="whmmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add WHM</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Select Type</label>
                                <select name="project" id="type" class="form-control">
                                    <option value="ecommerce">Ecommerce</option>
                                    <option value="personal">Personal</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter IP</label>
                                <input type="text" name="ip" id="ip" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter API Key</label>
                                <input type="text" name="ip" id="api_key" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="" id="ftp_id">
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="addwhm_btn">Add Whm</button>
                </div>
            </div>
        </div>
     </div>


     <div class="modal fade" id="editwhmmodal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Add WHM</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Select Type</label>
                                <select name="project" id="edit_type" class="form-control">
                                    <option value="ecommerce">Ecommerce</option>
                                    <option value="personal">Personal</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter IP</label>
                                <input type="text" name="ip" id="edit_ip" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter API Key</label>
                                <input type="text" name="ip" id="edit_api_key" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                <input type="hidden" name="" id="whm_id">
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="updatewhm_btn">Add Whm</button>
                </div>
            </div>
        </div>
     </div>
  
@endsection

@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable();


        });
    </script>
    <script>
        $(document).on('click', '.edit', function(){
            var id = $(this).attr('data-id');
            var key = $(this).attr('data-key');
            var ip = $(this).attr('data-ip');
            var type = $(this).attr('data-type');

            

            $("#whm_id").val(id);
            $("#edit_ip").val(ip);
            $("#edit_api_key").val(key);
            $("#edit_type").val(type).change();

            $("#editwhmmodal").modal('show');

        })

        $("#updatewhm_btn").on('click', function(){
             var ip = $("#edit_ip").val();
            var api = $("#edit_api_key").val();
            var type = $("#edit_type").find(':selected').val();
            var id = $("#whm_id").val();
            if(!ip)
            {
                errorShow("Please enter ip")
                return;
            }else if(!api)
            {
                errorShow("Please enter api key");
                return;
            }else{
                var data = {ip:ip, api:api, type:type, _token:'<?=csrf_token(); ?>', id:id};
                var url = "{{route('whm.update')}}";
                $.post(url, data, function(data){
                    if(data.result)
                    {
                        location.reload();   
                    }
                });
            } 
        });
    </script>
    <script>
        @if (session('error'))

            Swal.fire({
                title: "Error",
                text: "{{ session('error') }}",
                icon: "error"
            })
        @endif
        @if (session('success'))

            Swal.fire({
                title: "Success",
                text: "{{ session('success') }}",
                icon: "success"
            })
        @endif
    </script>
    <script>
        $("#addWhmbtn").on('click', function(){
            $("#whmmodal").modal('show');
        });
    </script>
    <script>
        $("#addwhm_btn").on('click', function(){
            var ip = $("#ip").val();
            var api = $("#api_key").val();
            var type = $("#type").find(':selected').val();
            if(!ip)
            {
                errorShow("Please enter ip")
                return;
            }else if(!api)
            {
                errorShow("Please enter api key");
                return;
            }else{
                var data = {ip:ip, api:api, type:type, _token:'<?=csrf_token(); ?>'};
                var url = '<?=url('admin/whm/add'); ?>';
                $.post(url, data, function(data){
                    if(data.result)
                    {
                        location.reload();   
                    }
                });
            }   
        });

        $(document).on('click', '.remove', function() {
            var id = $(this).attr('data-id');
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to remove this whm',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, remove it!',
                cancelButtonText: 'No, keep it',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    var url = "{{route('whm.delete')}}";
                    var data = {id:id, _token:'<?=csrf_token(); ?>'};
                    $.post(url, data, function(data){
                        if(data.result)
                        {
                            Swal.fire({
                                title:"Deleted Successfully",
                                text:"Whm Deleted Successfully",
                                icon:"success"
                            }).then(function(){
                                location.reload();
                            })
                        }
                    })
                }
            })
        });

        function errorShow(msg)
        {
            Swal.fire({
                title:"Error",
                text:msg,
                icon:"error"
            })
        }
    </script>
   
@endsection
