@extends('user.layout2')

@section('content_header')
    <h1>Dashboard</h1>
@stop

@section('content')
  <section class="user-form-section pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="user-form">
                        <div class="title">
                            <h3>{{__('login')}}</h3>
                        </div>
                        <form action="{{route('user.login')}}" method="post" enctype="multipart/form-data">
                            @csrf
                          @if(isset($id))     
                     <input type="text" name="id" value="{{ $id }}" >       
                              @endif
                            <div class="form_group">
                                <span>{{__('Email Address or Phone')}}*</span>
                                <input type="text" name="email" class="form_control" value="{{Request::old('email')}}">
                                @if(Session::has('err'))
                                    <p class="text-danger mb-2 mt-2">{{Session::get('err')}}</p>
                                @endif
                                @error('email')
                                <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="form_group">
                                <span>{{__('Password')}} *</span>
                                <input type="password" name="password" class="form_control" value="{{Request::old('password')}}">
                                @error('password')
                                <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            
                             
                            <div class="form_group">
                                <button class="main-btn">{{__('LOG IN')}}</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section><!--====== End user-form-section ======-->
@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@section('js')
    <script> console.log("Hi, I'm using the Laravel-AdminLTE package!"); </script>
@stop