@extends('user.layout2')

@section('content_header')
    <h1>Dashboard</h1>
@stop

@section('content')
 <section class="user-form-section pt-120 pb-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="user-form">
                        <form action="{{ route('front.registrationsprocess.view') }}" method="post" enctype="multipart/form-data" onsubmit="putcode()">
                            @csrf
                            
                            	<input type="hidden" name="code" id="code" >	
                            	
                            <div class="form_group">
                                <span>{{ __('Username') }} *</span>
                                <input type="text" class="form_control" name="username" value="{{ old('username') }}"
                                placeholder="{{ __('Username') }}"  required>
                                
                              
                                <p class="text-danger mb-0" id="usernameAvailable"></p>
                                @error('username')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="form_group">
                                
                                
                                <span>{{ __('Phone') }} *</span>
                                <input type="text" class="form_control" name="phone"  id="phone" value="{{ old('phone') }}"
                                placeholder="{{ __('Phone') }}"  required>
                                
                              
                                <p class="text-danger mb-0" id="usernameAvailable"></p>
                                @error('phone')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            
                             
                            <div class="form_group">
                                <span>{{ __('First Name') }} *</span>
                                <input type="text" class="form_control" name="first_name" value="{{ old('first_name') }}"
                                placeholder="{{ __('First Name') }}" required>
                                @error('first_name')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div> 
                            <div class="form_group">
                                <span>{{ __('Last  Name') }} </span>
                                <input type="text" class="form_control" name="last_name" value="{{ old('last_name') }}"
                                placeholder="{{ __('Last Name') }}" >
                                @error('last_name')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            <div class="form_group">
                                <span>{{ __('Email address') }} </span>
                                <input type="email" class="form_control" name="email" value="{{ old('email') }}"
                                placeholder="{{ __('Email address') }}" >
                                @error('email')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            
                            
                            
                            
                            
                            
                            <div class="form_group">
                                <span>{{__('Password')}} *</span>
                                <input type="password" class="form_control" name="password" value="{{ old('password') }}"
                                    placeholder="{{ __('Password') }}" required>
                                @error('password')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="form_group">
                                <span>{{ __('Confirm Password') }} *</span>
                                <input id="password-confirm" type="password" class="form_control"
                                    placeholder="{{ __('Confirm Password') }}" name="password_confirmation" required
                                    autocomplete="new-password">
                                @error('password')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            
                            
                                 <div class="form_group">
                                <span>{{ __('Referral Id') }} </span>
                                <input type="refid" class="form_control" name="refid" value="{{ old('refid') }}"
                                placeholder="{{ __('Referral Id') }}" >
                                @error('refid')
                                    <p class="text-danger mb-2 mt-2">{{ $message }}</p>
                                @enderror
                            </div>
                            
                            
                            
                            
                            <div>
                                <input type="hidden" name="status" value="0">
                                <input type="hidden" name="id" value="0">
                            </div>
                            
                             <div class="form_group">
                                <a href="{{  url('/') }}/logintopurchase/{{ $id }}">Already Have an Account?</a>
                            </div>
                            
                            
                            <div class="form_group">
                                <button type="submit" class="main-btn">continue</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@section('js')
    <script> console.log("Hi, I'm using the Laravel-AdminLTE package!"); </script>
@stop