<!DOCTYPE html>
<html lang="en">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
	<title>User Dashboard</title>
	<link href="{{ url('/') }}/assets/css/all.min.css" rel="stylesheet">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/fontawesome-iconpicker.min.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/dropzone.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/bootstrap.min.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/bootstrap-tagsinput.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/bootstrap-datepicker.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/jquery-ui.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/jquery.timepicker.min.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/summernote-bs4.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/atlantis.css">
	<link rel="stylesheet" href="{{ url('/') }}/assets/css/custom.css">
	<link rel="stylesheet" href="https://cdn.datatables.net/1.13.7/css/jquery.dataTables.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link rel="icon" href="{{!empty($userBs->favicon) ? asset('assets/front/img/user/'.$userBs->favicon) : ''}}">
	@includeif('user.partials.styles')

    @php
        $selLang = App\Models\Language::where('code', request()->input('language'))->first();
    @endphp
    @if (!empty($selLang) && $selLang->rtl == 1)
    <style>
    #editModal form input,
    #editModal form textarea,
    #editModal form select {
        direction: rtl;
    }
    #editModal form .note-editor.note-frame .note-editing-area .note-editable {
        direction: rtl;
        text-align: right;
    }
    </style>
    @endif

    @yield('page-style')
</head>
<body @if(request()->cookie('user-theme') == 'dark') data-background-color="dark" @endif>
	<div class="wrapper">

		{{-- top navbar area start --}}
		@includeif('user.partials.top-navbar')
		{{-- top navbar area end --}}

		{{-- side navbar area start --}}
		@includeif('user.partials.side-navbar')
		{{-- side navbar area end --}}

		<div class="main-panel">
            <div class="content">
                <div class="page-inner">
                @yield('content')
                </div>
            </div>
            @includeif('user.partials.footer')
		</div>

	</div>

	@includeif('user.partials.scripts')

	@yield('page-script')
   

	{{-- Loader --}}
	<div class="request-loader">
		<img src="{{asset('assets/admin/img/loader.gif')}}" alt="">
	</div>
	{{-- Loader --}}

	<!-- Remove redundant jQuery -->
	    <!-- Scripts -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.1.3/js/bootstrap.min.js"></script>
	<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
     @yield('js')

</body>
</html>
