@extends('user.layout')

@section('content')
<style>
    .flex-between{
        display: flex;
        justify-content: space-between;
    }
    .searh-domain-form{
        display: flex;
    }
    #searh-domain{
        width: 100%;
        border: 1px solid #dee2e6;
        padding: 10px;    border: 1px solid #dee2e6;
        padding: 10px;
    }
    @media only screen and (min-width: 768px) {
        .searh-domain-form{
            padding-left: 15rem;
            padding-right: 15rem;
        }
    }
</style>
<div class="page-header">
    <h4 class="page-title">{{__('Domain List')}}</h4>
    <ul class="breadcrumbs">
        <li class="nav-home">
            <a href="{{route('user-dashboard')}}">
            <i class="flaticon-home"></i>
            </a>
        </li>
        <li class="separator">
            <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
            <a href="#">{{__('Domain List')}}</a>
        </li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="flex-between">
                    <div class="">
                        <div class="card-title d-inline-block">{{__('List of domains')}}</div>
                    </div>
                    <div class="">
                        <form action="https://goafli.in/admin/domain-list" class="d-inline-block float-right">
                            <input class="form-control" type="text" name="search" placeholder="Search your domain" value="">
                        </form>
                        
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form action="{{route('front.domain-search')}}" method="get" class="searh-domain-form" >
                            <input type="text" name="domain" id="searh-domain" class="form_control" value="" placeholder="Search for your next domain" required="">
                            <button type="submit" class="btn btn-success">Search</button>  
                        </form>
                        <hr>
                        @if (count($domains) == 0)
                        <h3 class="text-center">{{__('NO DOMAIN FOUND')}}</h3>
                        @else
                        <div class="table-responsive">
                            <table class="table table-striped mt-3">
                                <thead>
                                    <tr>
                                        <th scope="col">{{__('Name')}}</th>
                                        <th scope="col">{{__('Amount')}}</th>
                                        <th scope="col">{{__('Payment')}}</th>
                                        <th scope="col">{{__('Years')}}</th>
                                        <th scope="col">{{__('Purchased')}}</th>
                                        <th scope="col">{{__('Expired')}}</th>
                                        <th scope="col">{{__('Transaction')}}</th>
                                        <th scope="col">{{__('Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($domains as $key => $domain)
                                    <tr>
                                        <td><a href="//{{$domain->name}}" target=blank >{{$domain->name}}</a></td>
                                        <td>₹{{$domain->price}}</td>
                                        <td>
                                            @if($domain->is_paid == 1)
                                                <h3 class="d-inline-block badge badge-success">Success</h3>
                                            @else
                                                <h3 class="d-inline-block badge badge-warning">Pending</h3>
                                            @endif    
                                        </td>
                                        <td>{{$domain->years}}</td>
                                        <td>@if($domain->purchased){{\Carbon\Carbon::parse($domain->purchased)->format('d/m/Y')}}@endif</td>
                                        <td>@if($domain->expired){{\Carbon\Carbon::parse($domain->expired)->format('d/m/Y')}}@endif</td>
                                        <td>{{$domain->transactionID}}</td>
                                        <td>
                                            @if($domain->is_paid == 1)
                                                <a href="{{ route('user.domain.manage',[$domain->name]) }}" class="btn btn-info btn-sm mr-1">Manage</a>
                                            @else
                                                <a href="{{ route('user.domain.tobilling',[$domain->id]) }}" class="btn btn-warning btn-sm mr-1">Pay Now</a>
                                            @endif
                                            <!--<button type="button" class="btn btn-primary btn-sm">Renew</button>-->
                                        </td>
                                    </tr>    
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="d-inline-block mx-auto">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
