@extends('user.layout')

@section('content')
<style>
    .justify-content{
        display: flex;
        justify-content: space-between;
    }
</style>
<div class="page-header">
    <h4 class="page-title">{{__('Manage Domain')}}</h4>
    <ul class="breadcrumbs">
        <li class="nav-home">
            <a href="{{route('user-dashboard')}}">
            <i class="flaticon-home"></i>
            </a>
        </li>
        <li class="separator">
            <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
            <a href="#">{{__('Manage Domain')}}</a>
        </li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card-title d-inline-block"><i class="fa fa-globe"></i>&nbsp;<b style="font-size: larger;">{{$domain_name}}</b></div>
                    </div>
                    <div class="col-lg-3">
                    </div>
                    <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                        
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (count($host_records) == 0)
                        <h3 class="text-center">{{__('NO RECORD FOUND')}}</h3>
                        @else
                        
                        <div class="table-responsive" id="host_records">
                            <div class="justify-content">
                                <h4><b>@{{ title }}</b></h4>
                                <div>
                                    <input class="form-control" type="text" v-model="searchHost" placeholder="Search records by name">
                                </div>
                            </div>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th scope="col">{{__('Type')}}</th>
                                        <th scope="col">{{__('Host')}}</th>
                                        <th scope="col">{{__('Value')}}</th>
                                        <th scope="col">{{__('TTL')}}</th>
                                        <th scope="col">{{__('Actions')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="(record,index) in filteredRecords">
                                        <td>@{{record['Type']}}</td>
                                        <td>@{{record['Name']}}</td>
                                        <td>@{{record['Address']}}</td>
                                        <td>@{{record['TTL']/60}} min</td>
                                        <td><button type="button" class="btn btn-warning btn-sm" @click="deleteSavedRecord(index)">Delete</button></td>
                                    </tr> 
                                    
                                    <tr v-for="(record,index) in newHostRecords">
                                        <td>
                                            <select v-model="record['Type']" class="form-control">
                                              <option value="" disabled>Select Type</option>
                                              <option v-for="type in recordsType" :value="type.value">@{{type.name}}</option>
                                            </select>
                                        </td>
                                        <td><input class="form-control" type="text" v-model="record['Name']" placeholder="Enter name"></td>
                                        <td><input class="form-control" type="text" v-model="record['Address']" placeholder="Enter address"></td>
                                        <td><input class="form-control" type="number" v-model="record['TTL']" placeholder="Enter TTL in min"></td>
                                        <td>
                                            <button type="button" class="btn btn-success btn-sm mr-1" v-if="record['Type'] && record['Name'] && record['Address'] && record['TTL']" @click="addNewRecord(record,index)">Add</button>
                                            <button type="button" class="btn btn-warning btn-sm" @click="deleteNewRecord(index)">Delete</button>
                                        </td>
                                    </tr>    
                                    
                                </tbody>
                            </table>
                            <div class="justify-content">
                                <button type="button" class="btn btn-info btn-sm mr-1" @click="addRecord">Add Records</button> 
                                <form action="{{ config('app.url') }}user/add-host-records" method="POST">
                                    <input type="hidden" name="domain" value="{{$domain_name}}">
                                    <input type="hidden" name="records" :value="domain_records">
                                    <button type="submit" class="btn btn-success btn-sm" :disabled="saveHostRecords==false" @click="saveRecords">Save Records</button>
                                </form>
                            </div>    
                        </div>
                        @endif
                        
                        <hr>
                        <div class="justify-content">
                            <h4><b>MAIL SETTINGS</b></h4>
                        </div>
                        
                        <hr>
                        <div class="justify-content">
                            <h4><b>DNS SERVER</b></h4>
                            <button type="button" class="btn btn-success btn-sm">Add Nameserver</button>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th scope="col">{{__('Host')}}</th>
                                        <th scope="col">{{__('IP Address')}}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://unpkg.com/vue@3/dist/vue.global.js"></script>
<script>
    var host_records = [];
    @if (count($host_records))
        host_records = @json($host_records);
    @endif
</script>
<script>
  const { createApp } = Vue

  createApp({
    data() {
      return {
        title: 'HOST RECORDS',
        searchHost: '',
        hostRecords: host_records,
        recordsType: [
            {
                name: 'A Record',
                value: 'A'
            },
            {
                name: 'A + Dynamic DNS Record',
                value: 'A+'
            },
            {
                name: 'AAAA Record',
                value: 'AAAA'
            },
            {
                name: 'ALIAS Record',
                value: 'ALIAS'
            },
            {
                name: 'CAA Record',
                value: 'CAA'
            },
            {
                name: 'CNAME Record',
                value: 'CNAME'
            },
            {
                name: 'NS Record',
                value: 'NS'
            },
            {
                name: 'SRV Record',
                value: 'SRV'
            },
            {
                name: 'TXT Record',
                value: 'TXT'
            },
            {
                name: 'URL Redirect Record',
                value: 'URL'
            },
        ],
        newHostRecords: [],
        saveHostRecords: false,
        domain_records: ''
      }
    },
    computed: {
        filteredRecords() {
          return this.hostRecords.filter(record => {
            return record.Name.toLowerCase().includes(this.searchHost.toLowerCase())
          })
        }
    },
    methods: {
      deleteSavedRecord(index){
          this.hostRecords.splice(index, 1);
          this.saveHostRecords = true;
      },    
      addRecord(event) {
          this.newHostRecords.push({
              Name: '',
              Type: '',
              Address: '',
              TTL: '',
          });
      },
      deleteNewRecord(index){
          this.newHostRecords.splice(index, 1);
      },
      addNewRecord(record,index){
          record.TTL = record.TTL * 60;
          this.hostRecords.push(record);
          this.newHostRecords.splice(index, 1);
          this.saveHostRecords = true;
      },
      saveRecords(event){
            var params = '';
            this.hostRecords.forEach(function (record, index) {
                var nubmer = index + 1;
                params += '&HostName'+nubmer+'='+record.Name+'&RecordType'+nubmer+'='+record.Type+'&Address'+nubmer+'='+record.Address+'&TTL'+nubmer+'='+record.TTL;
            });
            this.domain_records = params;
      }
    }  
  }).mount('#host_records')
</script>
@endsection
