@extends('user.layout')

@section('content')
<div class="page-header">
    <h4 class="page-title">{{__('SSL Activate')}}</h4>
    <ul class="breadcrumbs">
        <li class="nav-home">
            <a href="{{route('user-dashboard')}}">
            <i class="flaticon-home"></i>
            </a>
        </li>
        <li class="separator">
            <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
            <a href="#">{{__('SSL Activate')}}</a>
        </li>
    </ul>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card-title d-inline-block">{{__('SSL Activate')}}</div>
                    </div>
                    <div class="col-lg-3">
                    </div>
                    <div class="col-lg-4 offset-lg-1 mt-2 mt-lg-0">
                        <a href="{{ route('user.ssls.index') }}" class="btn btn-info btn-sm" style="float: right;">Back to SSL list</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-12">
                        <form method="POST" action="{{ route('user.ssl.activate-request',[$info->certificateID]) }}">
                            <div class="row no-gutters">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">Common Name **</label>
                                      <input type="text" class="form-control" name="commonName" value="" placeholder="Common Name" required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">Organization **</label>
                                      <input type="text" class="form-control" name="organizationName" value="" placeholder="Organization" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row no-gutters">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">Unit Name **</label>
                                      <input type="text" class="form-control" name="organizationalUnitName" value="" placeholder="Unit Name" required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">Address **</label>
                                      <input type="text" class="form-control" name="localityName" value="" placeholder="Address" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row no-gutters">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">State Name **</label>
                                      <input type="text" class="form-control" name="stateOrProvinceName" value="" placeholder="State Name" required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">Country Name **</label>
                                      <input type="text" class="form-control" name="countryName" value="" placeholder="Country Name" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row no-gutters">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">Admin Email **</label>
                                      <input type="text" class="form-control" name="emailAddress" value="" placeholder="Admin Email" autocomplete="off" required>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                      <label for="">DNS Names **</label>
                                      <input type="text" class="form-control" name="dnsNames" value="" placeholder="DNS Names" required>
                                    </div>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-success ml-2">Activate</button>
                          </form>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="row">
                    <div class="d-inline-block mx-auto">
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
