@include('wallet.include.header')
<div class="layout has-sidebar fixed-sidebar fixed-header">
    @include('wallet.include.sidebar')
    <div id="overlay" class="overlay"></div>
    <div class="layout">
        <main class="content">
            <div>
                <a id="btn-toggle" href="#" class="sidebar-toggler break-point-sm">
                    <i class="ri-menu-line ri-xl"></i>
                </a>
            </div>

            <div class="position-relative">
                <a href="#" class="nestcart-logo">
                    <img src="{{ asset('assets/cgi_video/images/logo.png') }}" alt="Logo" />                
                </a>
                <div class="logout-right position-absolute top-0 end-0">
                    <button class="logoutButton logoutButton--dark m-0">
                        <svg class="doorway" viewBox="0 0 100 100">
                            <path
                                d="M93.4 86.3H58.6c-1.9 0-3.4-1.5-3.4-3.4V17.1c0-1.9 1.5-3.4 3.4-3.4h34.8c1.9 0 3.4 1.5 3.4 3.4v65.8c0 1.9-1.5 3.4-3.4 3.4z" />
                            <path class="bang"
                                d="M40.5 43.7L26.6 31.4l-2.5 6.7zM41.9 50.4l-19.5-4-1.4 6.3zM40 57.4l-17.7 3.9 3.9 5.7z" />
                        </svg>
                        <svg class="figure" viewBox="0 0 100 100">
                            <circle cx="52.1" cy="32.4" r="6.4" />
                            <path
                                d="M50.7 62.8c-1.2 2.5-3.6 5-7.2 4-3.2-.9-4.9-3.5-4-7.8.7-3.4 3.1-13.8 4.1-15.8 1.7-3.4 1.6-4.6 7-3.7 4.3.7 4.6 2.5 4.3 5.4-.4 3.7-2.8 15.1-4.2 17.9z" />
                            <g class="arm1">
                                <path
                                    d="M55.5 56.5l-6-9.5c-1-1.5-.6-3.5.9-4.4 1.5-1 3.7-1.1 4.6.4l6.1 10c1 1.5.3 3.5-1.1 4.4-1.5.9-3.5.5-4.5-.9z" />
                                <path class="wrist1"
                                    d="M69.4 59.9L58.1 58c-1.7-.3-2.9-1.9-2.6-3.7.3-1.7 1.9-2.9 3.7-2.6l11.4 1.9c1.7.3 2.9 1.9 2.6 3.7-.4 1.7-2 2.9-3.8 2.6z" />
                            </g>
                            <g class="arm2">
                                <path
                                    d="M34.2 43.6L45 40.3c1.7-.6 3.5.3 4 2 .6 1.7-.3 4-2 4.5l-10.8 2.8c-1.7.6-3.5-.3-4-2-.6-1.6.3-3.4 2-4z" />
                                <path class="wrist2"
                                    d="M27.1 56.2L32 45.7c.7-1.6 2.6-2.3 4.2-1.6 1.6.7 2.3 2.6 1.6 4.2L33 58.8c-.7 1.6-2.6 2.3-4.2 1.6-1.7-.7-2.4-2.6-1.7-4.2z" />
                            </g>
                            <g class="leg1">
                                <path
                                    d="M52.1 73.2s-7-5.7-7.9-6.5c-.9-.9-1.2-3.5-.1-4.9 1.1-1.4 3.8-1.9 5.2-.9l7.9 7c1.4 1.1 1.7 3.5.7 4.9-1.1 1.4-4.4 1.5-5.8.4z" />
                                <path class="calf1"
                                    d="M52.6 84.4l-1-12.8c-.1-1.9 1.5-3.6 3.5-3.7 2-.1 3.7 1.4 3.8 3.4l1 12.8c.1 1.9-1.5 3.6-3.5 3.7-2 0-3.7-1.5-3.8-3.4z" />
                            </g>
                            <g class="leg2">
                                <path
                                    d="M37.8 72.7s1.3-10.2 1.6-11.4 2.4-2.8 4.1-2.6c1.7.2 3.6 2.3 3.4 4l-1.8 11.1c-.2 1.7-1.7 3.3-3.4 3.1-1.8-.2-4.1-2.4-3.9-4.2z" />
                                <path class="calf2"
                                    d="M29.5 82.3l9.6-10.9c1.3-1.4 3.6-1.5 5.1-.1 1.5 1.4.4 4.9-.9 6.3l-8.5 9.6c-1.3 1.4-3.6 1.5-5.1.1-1.4-1.3-1.5-3.5-.2-5z" />
                            </g>
                        </svg>
                        <svg class="door" viewBox="0 0 100 100">
                            <path
                                d="M93.4 86.3H58.6c-1.9 0-3.4-1.5-3.4-3.4V17.1c0-1.9 1.5-3.4 3.4-3.4h34.8c1.9 0 3.4 1.5 3.4 3.4v65.8c0 1.9-1.5 3.4-3.4 3.4z" />
                            <circle cx="66" cy="50" r="3.7" />
                        </svg>
                        <span class="button-text">Log Out</span>
                    </button>
                </div>

            </div>

            <div class="nestcart-table 1table-responsive">

                <div class="card wallet-wrap text-center mb-5 text-white">
                    <div class="card-body">
                        <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" fill="currentColor"
                            class="bi bi-wallet2" viewBox="0 0 16 16">
                            <path
                                d="M12.136.326A1.5 1.5 0 0 1 14 1.78V3h.5A1.5 1.5 0 0 1 16 4.5v9a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 13.5v-9a1.5 1.5 0 0 1 1.432-1.499zM5.562 3H13V1.78a.5.5 0 0 0-.621-.484zM1.5 4a.5.5 0 0 0-.5.5v9a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5z" />
                        </svg>
                        <h6 class="my-2 fw-bold">Total Balance</h6>
                        <h5 class="mb-3 fw-bold">$ {{ Auth::user()->walletbalance }} </h5>
                        <div class="">
                            <a href="{{ route('user.wallet.add') }}"
                                class="btn btn-sm btn-outline-light rounded-pill me-2">Add Money</a>
                            <a href="#" class="btn btn-sm btn-outline-light rounded-pill">Widthdraw</a>
                        </div>
                    </div>
                </div>

                <table class="table">
                    <thead>
                        <tr>
                            <td class="rounded-top-left fw-semibold text-white">Transaction</td>
							<td align="center" class="tw-semibold text-white">Payment Method</td>
                            <td align="center" class="fw-semibold text-white">Status</td>
                            <td align="center" class="fw-semibold text-white">Description</td>
                            <td align="right" class="fw-semibold text-white">Transaction Date And Time</td>

                        </tr>
                    </thead>
                    <tbody>

                        @if (!$transactions->isEmpty())
                            @foreach ($transactions as $transaction)
                                <tr>
                                    <td>
                                        <div class="dropdown">
                                            <a class="1dropdown-toggle domain" data-bs-toggle="dropdown"
                                                aria-expanded="false">
                                                {{$transaction->transaction_id}}
                                            </a>
                                        </div>
                                        <span class="gray-text text-uppercase">
											${{$transaction->amount}}
										</span>
                                    </td>

									<td align="center">
										@if ($transaction->transaction_type == 'stripe')
											<span class="text-white">{{__('Credit Card')}}</span>
										@else
											{{ucfirst($transaction->transaction_type)}}
										@endif
									</td>
                                    <td align="center">

										@if ($transaction->status == 'completed')
											<span class="circle-block position-relative">
												<span class="circle bg-success" title="Success"></span>
												<div class="dropdown">
													<a class="1dropdown-toggle domain" data-bs-toggle="dropdown"
														aria-expanded="false">
														{{ucfirst($transaction->status)}}
													</a>
												</div>
											</span>
										@endif
                                    </td>
                                    <td align="center" class="text-white">
                                        {{$transaction->description}}
                                    </td>
                                    <td align="right" class="text-white">
                                    	${{$transaction->amount}}
										<br />
                                        <span class="gray-text">
											{{date('d F Y H:i', strtotime($transaction->created_at))}}
										</span>
                                    </td>

                                </tr>
                            @endforeach
                        @endif

                    </tbody>
                </table>
            </div>

			<nav aria-label="Page navigation example">
				<ul class="pagination justify-content-end">
					<!-- Previous Page Link -->
					@if ($transactions->onFirstPage())
						<li class="page-item disabled">
							<a class="page-link">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0" />
								</svg>
							</a>
						</li>
					@else
						<li class="page-item">
							<a class="page-link" href="{{ $transactions->previousPageUrl() }}">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-left" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M11.354 1.646a.5.5 0 0 1 0 .708L5.707 8l5.647 5.646a.5.5 0 0 1-.708.708l-6-6a.5.5 0 0 1 0-.708l6-6a.5.5 0 0 1 .708 0" />
								</svg>
							</a>
						</li>
					@endif
			
					<!-- Page Numbers -->
					@foreach ($transactions->getUrlRange(1, $transactions->lastPage()) as $page => $url)
						<li class="page-item {{ $transactions->currentPage() == $page ? 'active' : '' }}">
							<a class="page-link" href="{{ $url }}">{{ $page }}</a>
						</li>
					@endforeach
			
					<!-- Next Page Link -->
					@if ($transactions->hasMorePages())
						<li class="page-item">
							<a class="page-link" href="{{ $transactions->nextPageUrl() }}">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708" />
								</svg>
							</a>
						</li>
					@else
						<li class="page-item disabled">
							<a class="page-link">
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-chevron-right" viewBox="0 0 16 16">
									<path fill-rule="evenodd" d="M4.646 1.646a.5.5 0 0 1 .708 0l6 6a.5.5 0 0 1 0 .708l-6 6a.5.5 0 0 1-.708-.708L10.293 8 4.646 2.354a.5.5 0 0 1 0-.708" />
								</svg>
							</a>
						</li>
					@endif
				</ul>
			</nav>
		
			

           

        </main>
        <div class="overlay"></div>
    </div>
</div>
@include('wallet.include.footer')
