<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Categories;
use App\Http\Controllers\Api\SubcategoriesController;
use App\Http\Controllers\Api\ProductsController;
use App\Http\Controllers\Api\UiController;
use App\Http\Controllers\Api\CompanyInformation;
use App\Http\Controllers\VideoCgi\VideoUpload;
use App\Http\Controllers\AfliEmail\EmailApiController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('change_video_status', [VideoUpload::class, 'changeStatus'])->name('api.cgi.video.change_status');

Route::middleware(['check.cgiapi.key'])->group(function () {
    Route::prefix('cgi')->group(function () {
        Route::prefix('video')->group(function () {
            Route::post('upload', [VideoUpload::class, 'uploadVideo'])->name('api.cgi.video.upload');
        });
    });
});

Route::middleware(['check.api.key'])->group(function () {

    Route::get('getCompanyInformation', [CompanyInformation::class, 'get'])->name('project.get_company_information');
    Route::post('categories', [Categories::class, 'get']);
    Route::post('subcategories', [SubcategoriesController::class, 'get']);
    Route::post('products', [ProductsController::class, 'getProducts']);
    Route::post('products_by_category', [ProductsController::class, 'productsByCategories']);
    Route::post('featured-products', [ProductsController::class, 'featuredProducts']);
    Route::post('trending-products', [ProductsController::class, 'trendingProducts']);
    Route::post('best-seller-products', [ProductsController::class, 'bestSellerProducts']);
    Route::post('latest-products', [ProductsController::class, 'latestProducts']);
    Route::post('product_by_id', [ProductsController::class, 'getProductById']);
    Route::post('product_by_slug', [ProductsController::class, 'getProductBySlug']);
    
     Route::prefix('ui')->group(function () {
        Route::post('search', [UiController::class, 'searchPage'])->name('ui.theme.searchPage');
        Route::post('order_detail', [UiController::class, 'getOrderDetailPage'])->name('ui.theme_order_detail');
        Route::post('orders', [UiController::class, 'getOrdersPage'])->name('ui.theme.orders');
        Route::post('edit_profile', [UiController::class, 'getEditProfile'])->name('ui.theme.edit_profile');
        Route::post('profile', [UiController::class, 'getProfile'])->name('ui.theme.profile');
        Route::post('dashboard', [UiController::class, 'getDashboard'])->name('ui.theme.dashboard');
        Route::post('get_wishlist_page', [UiController::class, 'getWishlistPage'])->name('ui.theme.wishlist_page');
        Route::post('about_us', [UiController::class, 'aboutUs'])->name('ui.theme.about_us');
        Route::post('contact_us', [UiController::class, 'contactUs'])->name('ui.theme.contact_us');
        Route::post('faqs', [UiController::class, 'faqs'])->name('ui.theme.faqs');
        Route::post('login', [UiController::class, 'getLoginPage'])->name('ui.theme.login');
        Route::post('register', [UiController::class, 'getRegisterPage'])->name('ui.theme.register');
        Route::post('theme', [UiController::class, 'getTheme'])->name('ui.theme.homepage');
        Route::post('product_detail_page', [UiController::class, 'getProductPage'])->name('ui.theme.product_page');
        Route::post('cart_page', [UiController::class, 'getCartPage'])->name('ui.theme.cart_page');
        Route::post('checkout_page', [UiController::class, 'getCheckoutPage'])->name('ui.theme.checkout_page');
        Route::post('thank_you_page', [UiController::class, 'getThankYouPage'])->name('ui.theme.thankyou');
        Route::post('get_product_pages', [UiController::class, 'getProductsPage'])->name('ui.theme.products_page');
        Route::post('privacy_policy', [UiController::class, 'getPrivacyPolicy'])->name('ui.theme.privacy_policy');
        Route::post('terms_and_conditions', [UiController::class, 'termsAndConditions'])->name('ui.theme.terms_and_conditions');
    });


});



// Email Api

Route::prefix('email')->group(function () {
    Route::post('login', [EmailApiController::class, 'login'])->name('email.login');
    Route::post('register', [EmailApiController::class, 'register'])->name('email.register');
    Route::post('getAccounts', [EmailApiController::class, 'getEmailAccounts'])->name('email.getEmailAccounts');
    Route::post('addAccount', [EmailApiController::class, 'addEmailAccount'])->name('email.addEmailAccount');
    Route::post('deleteAccount', [EmailApiController::class, 'deleteEmailAccount'])->name('email.deleteAccount');
    Route::post('getEmails', [EmailApiController::class, 'getEmails'])->name('email.getEmails');
    Route::post('getSentEmails', [EmailApiController::class, 'getSentEmails'])->name('email.getSentEmails');
    Route::post('getStarredEmail', [EmailApiController::class, 'getStarredEmail'])->name('email.getStarredEmail');
    Route::post('getImportantEmail', [EmailApiController::class, 'getImportantEmail'])->name('email.getImportantEmail');
});

