<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Afli | Services</title>
    <link href="<?php echo e(asset('assets/cgi_video/images/favicon.png')); ?>" rel="icon" type="text/css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="<?php echo e(asset('assets/services/css/services.css')); ?>" rel="stylesheet" type="text/css" />

    <!-- Effect css -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" type="text/css" />
    <style>
		.whatsapp-float {
			position: fixed;
			bottom: 50px;
			right: 20px;
			z-index: 1000;
			display: flex;
			align-items: center;
			justify-content: center;
			width: 60px;
			height: 60px;
			background-color: transparent;
			border-radius: 50%;
			box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
			transition: transform 0.3s, box-shadow 0.3s;
		}

		.whatsapp-float:hover {
			transform: scale(1.1);
			box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
		}

		.whatsapp-icon {
			width: 65px;
			height: 65px;
		}

	</style>
</head>

<body>

    <main>

        <!--Start: My Services Section -->
        <section class="services-section text-white text-center spad-2 primary-bg">
            <div class="container">
                <div class="wrap position-relative">
                    <a href="wallet.html" class="voliet-btn card bg-gradient-info rounded-4 d-lg-none">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="">
                                    <h6 class="mb-0 text-white">Balance</h6>
                                    <p class="mb-0 text-white">
                                        <?php echo e(currency_symbol()); ?><?php echo e($wallet_balance); ?>

                                    </p>
                                </div>
                                <div class="text-white">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        fill="currentColor" class="bi bi-currency-dollar icon" viewBox="0 0 16 16">
                                        <path
                                            d="M4 10.781c.148 1.667 1.513 2.85 3.591 3.003V15h1.043v-1.216c2.27-.179 3.678-1.438 3.678-3.3 0-1.59-.947-2.51-2.956-3.028l-.722-.187V3.467c1.122.11 1.879.714 2.07 1.616h1.47c-.166-1.6-1.54-2.748-3.54-2.875V1H7.591v1.233c-1.939.23-3.27 1.472-3.27 3.156 0 1.454.966 2.483 2.661 2.917l.61.162v4.031c-1.149-.17-1.94-.8-2.131-1.718zm3.391-3.836c-1.043-.263-1.6-.825-1.6-1.616 0-.944.704-1.641 1.8-1.828v3.495l-.2-.05zm1.591 1.872c1.287.323 1.852.859 1.852 1.769 0 1.097-.826 1.828-2.2 1.939V8.73z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </a>
                    <div class="section-header" data-aos="fade-down">
                        <h2 class="mb-2">My <span>Services</span></h2>
                        <p>We offer a range of innovative and tailored services to help you stand out in the digital
                            world. From captivating CGI videos to cutting-edge AI website builders, we have solutions
                            that cater to every business need.</p>
                    </div>
                    <a href="<?php echo e(route('user.wallet')); ?>"
                        class="voliet-btn card bg-gradient-info rounded-4 position-absolute d-none d-lg-block">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="">
                                    <h6 class="mb-0 text-white">Balance</h6>
                                    <p class="mb-0 text-white">
                                        <?php echo e(currency_symbol()); ?><?php echo e($wallet_balance); ?>

                                    </p>
                                </div>
                                <div class="text-white">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                        fill="currentColor" class="bi bi-currency-dollar icon" viewBox="0 0 16 16">
                                        <path
                                            d="M4 10.781c.148 1.667 1.513 2.85 3.591 3.003V15h1.043v-1.216c2.27-.179 3.678-1.438 3.678-3.3 0-1.59-.947-2.51-2.956-3.028l-.722-.187V3.467c1.122.11 1.879.714 2.07 1.616h1.47c-.166-1.6-1.54-2.748-3.54-2.875V1H7.591v1.233c-1.939.23-3.27 1.472-3.27 3.156 0 1.454.966 2.483 2.661 2.917l.61.162v4.031c-1.149-.17-1.94-.8-2.131-1.718zm3.391-3.836c-1.043-.263-1.6-.825-1.6-1.616 0-.944.704-1.641 1.8-1.828v3.495l-.2-.05zm1.591 1.872c1.287.323 1.852.859 1.852 1.769 0 1.097-.826 1.828-2.2 1.939V8.73z" />
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>

                <div class="row g-4">


                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg" 
                                    width="24" height="24" fill="currentColor" class="bi bi-play-btn" 
                                    viewBox="0 0 16 16">
                                    <path d="M6.79 5.093A.5.5 0 0 1 7.5 5.5v5a.5.5 0 0 1-.71.457l-3-2a.5.5 0 0 1 0-.914l3-2Z"/>
                                    <path d="M0 4a4 4 0 0 1 4-4h8a4 4 0 0 1 4 4v8a4 4 0 0 1-4 4H4a4 4 0 0 1-4-4V4Zm4-3a3 3 0 0 0-3 3v8a3 3 0 0 0 3 3h8a3 3 0 0 0 3-3V4a3 3 0 0 0-3-3H4Z"/>
                                </svg>
                                </i></div>
                                <h5 class="card-title my-3">AI CGI Orders</h5>
                                <p class="card-text">
                                    Create high-quality, AI-powered CGI videos for visual storytelling. Ideal for
                                    businesses, designers, and creatives aiming to deliver immersive, professional-grade
                                    animations.
                                </p>
                            </div>

                            <?php if($cgiOrders > 0): ?>
                             <button class="button animation-btn viewCgiOrders">
                            <?php else: ?>
                             <button class="button animation-btn cgi-videos">
                            <?php endif; ?>

                           
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                
                                    <?php if($cgiOrders > 0): ?>
                                        <div class="content">
                                        <span class="char char-orders state-1">
                                            <span data-label="O" style="--i: 1">O</span>
                                            <span data-label="r" style="--i: 2">r</span>
                                            <span data-label="d" style="--i: 3">d</span>
                                            <span data-label="e" style="--i: 4" style="margin-left: 0px !important">e</span>
                                            <span data-label="r" style="--i: 5; margin-left: 0px !important;margin-right:0px;" style="">r</span>
                                            <span data-label="s" style="--i: 5">s</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char char-orders state-2">
                                             <span data-label="O" style="--i: 1">O</span>
                                            <span data-label="r" style="--i: 2">r</span>
                                            <span data-label="d" style="--i: 3">d</span>
                                            <span data-label="e" style="--i: 4" style="margin-left: 0px !important">e</span>
                                            <span data-label="r" style="--i: 5; margin-left: 0px !important;margin-right:0px;" style="">r</span>
                                            <span data-label="s" style="--i: 5">s</span>
                                        </span>
                                    </div>
                                    <?php else: ?>
                                    <div class="content">
                                        <span class="char state-1">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="T" style="--i: 5">T</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="d" style="--i: 7">d</span>
                                            <span data-label="a" style="--i: 8">a</span>
                                            <span data-label="y" style="--i: 9">y</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                    <?php endif; ?>

                                    
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor" class="bi bi-globe"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855A8 8 0 0 0 5.145 4H7.5zM4.09 4a9.3 9.3 0 0 1 .64-1.539 7 7 0 0 1 .597-.933A7.03 7.03 0 0 0 2.255 4zm-.582 3.5c.03-.877.138-1.718.312-2.5H1.674a7 7 0 0 0-.656 2.5zM4.847 5a12.5 12.5 0 0 0-.338 2.5H7.5V5zM8.5 5v2.5h2.99a12.5 12.5 0 0 0-.337-2.5zM4.51 8.5a12.5 12.5 0 0 0 .337 2.5H7.5V8.5zm3.99 0V11h2.653c.187-.765.306-1.608.338-2.5zM5.145 12q.208.58.468 1.068c.552 1.035 1.218 1.65 1.887 1.855V12zm.182 2.472a7 7 0 0 1-.597-.933A9.3 9.3 0 0 1 4.09 12H2.255a7 7 0 0 0 3.072 2.472M3.82 11a13.7 13.7 0 0 1-.312-2.5h-2.49c.062.89.291 1.733.656 2.5zm6.853 3.472A7 7 0 0 0 13.745 12H11.91a9.3 9.3 0 0 1-.64 1.539 7 7 0 0 1-.597.933M8.5 12v2.923c.67-.204 1.335-.82 1.887-1.855q.26-.487.468-1.068zm3.68-1h2.146c.365-.767.594-1.61.656-2.5h-2.49a13.7 13.7 0 0 1-.312 2.5m2.802-3.5a7 7 0 0 0-.656-2.5H12.18c.174.782.282 1.623.312 2.5zM11.27 2.461c.247.464.462.98.64 1.539h1.835a7 7 0 0 0-3.072-2.472c.218.284.418.598.597.933M10.855 4a8 8 0 0 0-.468-1.068C9.835 1.897 9.17 1.282 8.5 1.077V4z" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">AI Website Builder</h5>
                                <p class="card-text">Build stunning websites effortlessly with AI-powered tools.
                                    Includes customizable templates, professional emails, and seamless integrations for
                                    businesses of any size or industry.</p>
                            </div>

                            <?php
                                $aiSubsrciptionUrl = url('ai/websites/pricing');
                                if ($user_subscriptions_count > 0) {
                                    $aiSubsrciptionUrl = url('subscriptions');
                                }
                            ?>

                            <a href="<?php echo e(route('ai.websites', ['page'=>1])); ?>" data-url="<?php echo e(route('ai.websites', ['page'=>1])); ?>" style="width:200px;"
                                class="button animation-btn">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <?php if($user_subscriptions_count <= 0): ?>
                                           <span class="char char-3 state-1">

                                                <span data-label="C" style="--i: 1">C</span>
                                                <span data-label="O" style="--i: 2">O</span>
                                                <span data-label="M" style="--i: 3">M</span>
                                                <span data-label="I" style="--i: 4">I</span>
                                                <span data-label="N" style="--i: 5">N</span>
                                                <span data-label="G" style="--i: 6">G</span>
                                                <span data-label="S" style="--i: 7">S</span>
                                                <span data-label="O" style="--i: 8">O</span>
                                                <span data-label="O" style="--i: 9">O</span>
                                                <span data-label="N" style="--i: 10">N</span>
                                            </span>
                                        <?php else: ?>
                                            <span class="char char-3 state-1">
                                                <span data-label="C" style="--i: 1">C</span>
                                                <span data-label="O" style="--i: 2">O</span>
                                                <span data-label="M" style="--i: 3">M</span>
                                                <span data-label="I" style="--i: 4">I</span>
                                                <span data-label="N" style="--i: 5">N</span>
                                                <span data-label="G" style="--i: 6">G</span>
                                                <span data-label="S" style="--i: 7">S</span>
                                                <span data-label="O" style="--i: 8">O</span>
                                                <span data-label="O" style="--i: 9">O</span>
                                                <span data-label="N" style="--i: 10">N</span>
                                            </span>
                                        <?php endif; ?>



                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div><!--/*col -->

                    <?php
                        $ecommerceUrl = route('ecommerce.subscriptions', ['page'=>1]);
                    ?>


                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor" class="bi bi-cart4"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M0 2.5A.5.5 0 0 1 .5 2H2a.5.5 0 0 1 .485.379L2.89 4H14.5a.5.5 0 0 1 .485.621l-1.5 6A.5.5 0 0 1 13 11H4a.5.5 0 0 1-.485-.379L1.61 3H.5a.5.5 0 0 1-.5-.5M3.14 5l.5 2H5V5zM6 5v2h2V5zm3 0v2h2V5zm3 0v2h1.36l.5-2zm1.11 3H12v2h.61zM11 8H9v2h2zM8 8H6v2h2zM5 8H3.89l.5 2H5zm0 5a1 1 0 1 0 0 2 1 1 0 0 0 0-2m-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0m9-1a1 1 0 1 0 0 2 1 1 0 0 0 0-2m-2 1a2 2 0 1 1 4 0 2 2 0 0 1-4 0" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">AI E-commerce Solutions</h5>
                                <p class="card-text">Create and manage online stores with AI-driven tools. Simplify product management, boost sales, and deliver exceptional shopping experiences with minimal effort.</p>
                            </div>
                            <a href="javascript:void(0)" data-url="<?php echo e($ecommerceUrl); ?>" class="button animation-btn ecommerceDashboard"
                                style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <?php if($user_ecommerce_count <= 0): ?>
                                            <span class="char char-3 state-1">

                                                <span data-label="B" style="--i: 1">B</span>
                                                <span data-label="E" style="--i: 2">E</span>
                                                <span data-label="T" style="--i: 3">T</span>
                                                <span data-label="A" style="--i: 4">A</span>
                                            </span>
                                        <?php else: ?>
                                            <span class="char char-3 state-1">
                                                
                                                <span data-label="B" style="--i: 1">B</span>
                                                <span data-label="E" style="--i: 2">E</span>
                                                <span data-label="T" style="--i: 3">T</span>
                                                <span data-label="A" style="--i: 4">A</span>
                                            </span>
                                        <?php endif; ?>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>


                                    </div>
                                </div>
                            </a>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor"
                                            class="bi bi-envelope-at" viewBox="0 0 16 16">
                                            <path
                                                d="M2 2a2 2 0 0 0-2 2v8.01A2 2 0 0 0 2 14h5.5a.5.5 0 0 0 0-1H2a1 1 0 0 1-.966-.741l5.64-3.471L8 9.583l7-4.2V8.5a.5.5 0 0 0 1 0V4a2 2 0 0 0-2-2zm3.708 6.208L1 11.105V5.383zM1 4.217V4a1 1 0 0 1 1-1h12a1 1 0 0 1 1 1v.217l-7 4.2z" />
                                            <path
                                                d="M14.247 14.269c1.01 0 1.587-.857 1.587-2.025v-.21C15.834 10.43 14.64 9 12.52 9h-.035C10.42 9 9 10.36 9 12.432v.214C9 14.82 10.438 16 12.358 16h.044c.594 0 1.018-.074 1.237-.175v-.73c-.245.11-.673.18-1.18.18h-.044c-1.334 0-2.571-.788-2.571-2.655v-.157c0-1.657 1.058-2.724 2.64-2.724h.04c1.535 0 2.484 1.05 2.484 2.326v.118c0 .975-.324 1.39-.639 1.39-.232 0-.41-.148-.41-.42v-2.19h-.906v.569h-.03c-.084-.298-.368-.63-.954-.63-.778 0-1.259.555-1.259 1.4v.528c0 .892.49 1.434 1.26 1.434.471 0 .896-.227 1.014-.643h.043c.118.42.617.648 1.12.648m-2.453-1.588v-.227c0-.546.227-.791.573-.791.297 0 .572.192.572.708v.367c0 .573-.253.744-.564.744-.354 0-.581-.215-.581-.8Z" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">AI Email Services</h5>
                                <p class="card-text">Professional, automated email services tailored for businesses. Streamline communication, boost productivity, and enjoy seamless integration with other tools at a cost-effective price.</p>
                            </div>
                            <a href="<?php echo e(url('emails')); ?>" class="button animation-btn open_mail_box" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor" class="bi bi-tablet"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M12 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1zM4 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z" />
                                            <path d="M8 14a1 1 0 1 0 0-2 1 1 0 0 0 0 2" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">Social Media Posting Tools</h5>
                                <p class="card-text">Automate content scheduling, posting, and analytics with AI. Manage multiple platforms, optimize performance, and engage your audience effortlessly through smart social media tools.</p>
                            </div>
                            <button class="button animation-btn social_media_tools" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->


                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor" class="bi bi-globe2"
                                            viewBox="0 0 16 16">
                                            <path
                                                d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">Domain Selling</h5>
                                <p class="card-text">Search, register, and manage domains effortlessly with intuitive tools. Empower businesses and individuals with the perfect domain for their online identity.</p>
                            </div>
                            <a href="javascript:void(0)" style="width:200px;" class="button animation-btn">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor"
                                            class="bi bi-credit-card" viewBox="0 0 16 16">
                                            <path
                                                d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2zm2-1a1 1 0 0 0-1 1v1h14V4a1 1 0 0 0-1-1zm13 4H1v5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1z" />
                                            <path
                                                d="M2 10a1 1 0 0 1 1-1h1a1 1 0 0 1 1 1v1a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1z" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">Business Card</h5>
                                <p class="card-text">Design professional digital business cards for free. Enhance networking with sleek, AI-generated designs that showcase your brand identity and key contact information.</p>
                            </div>
                            <button class="button animation-btn" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><svg xmlns="http://www.w3.org/2000/svg"
                                            width="24" height="24" fill="currentColor"
                                            class="bi bi-brilliance" viewBox="0 0 16 16">
                                            <path
                                                d="M8 16A8 8 0 1 1 8 0a8 8 0 0 1 0 16M1 8a7 7 0 0 0 7 7 3.5 3.5 0 1 0 0-7 3.5 3.5 0 1 1 0-7 7 7 0 0 0-7 7" />
                                        </svg></i></div>
                                <h5 class="card-title my-3">Ai Logo Maker</h5>
                                <p class="card-text">Generate unique, professional logos in seconds with AI. Customize designs to fit your brand identity and create a lasting impression effortlessly.</p>
                            </div>
                            <button class="button animation-btn openLogoMaker" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char char-3 state-2">
                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><i><svg xmlns="http://www.w3.org/2000/svg"
                                                width="24" height="24" fill="currentColor"
                                                class="bi bi-globe2" viewBox="0 0 16 16">
                                                <path
                                                    d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                            </svg></i></i></div>
                                <h5 class="card-title my-3">Portfolio Website</h5>
                                <p class="card-text">Create stunning, AI-powered portfolio websites to showcase your work. Perfect for professionals, artists, and freelancers seeking an impactful online presence.</p>
                            </div>
                            <button class="button animation-btn" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><i><svg xmlns="http://www.w3.org/2000/svg"
                                                width="24" height="24" fill="currentColor"
                                                class="bi bi-globe2" viewBox="0 0 16 16">
                                                <path
                                                    d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                            </svg></i></i></div>
                                <h5 class="card-title my-3">CRM (Customer Relationship Management)</h5>
                                <p class="card-text">AI-powered tools to track customer interactions, automate follow-ups, manage leads, and enhance client relationships with ease.</p>
                            </div>
                            <button class="button animation-btn" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->

                    <div class="col-lg-4 col-md-6">
                        <div class="card" data-aos="flip-right">
                            <div class="card-body">
                                <div class="card-icon centerdiv"><i><i><svg xmlns="http://www.w3.org/2000/svg"
                                                width="24" height="24" fill="currentColor"
                                                class="bi bi-globe2" viewBox="0 0 16 16">
                                                <path
                                                    d="M0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8m7.5-6.923c-.67.204-1.335.82-1.887 1.855q-.215.403-.395.872c.705.157 1.472.257 2.282.287zM4.249 3.539q.214-.577.481-1.078a7 7 0 0 1 .597-.933A7 7 0 0 0 3.051 3.05q.544.277 1.198.49zM3.509 7.5c.036-1.07.188-2.087.436-3.008a9 9 0 0 1-1.565-.667A6.96 6.96 0 0 0 1.018 7.5zm1.4-2.741a12.3 12.3 0 0 0-.4 2.741H7.5V5.091c-.91-.03-1.783-.145-2.591-.332M8.5 5.09V7.5h2.99a12.3 12.3 0 0 0-.399-2.741c-.808.187-1.681.301-2.591.332zM4.51 8.5c.035.987.176 1.914.399 2.741A13.6 13.6 0 0 1 7.5 10.91V8.5zm3.99 0v2.409c.91.03 1.783.145 2.591.332.223-.827.364-1.754.4-2.741zm-3.282 3.696q.18.469.395.872c.552 1.035 1.218 1.65 1.887 1.855V11.91c-.81.03-1.577.13-2.282.287zm.11 2.276a7 7 0 0 1-.598-.933 9 9 0 0 1-.481-1.079 8.4 8.4 0 0 0-1.198.49 7 7 0 0 0 2.276 1.522zm-1.383-2.964A13.4 13.4 0 0 1 3.508 8.5h-2.49a6.96 6.96 0 0 0 1.362 3.675c.47-.258.995-.482 1.565-.667m6.728 2.964a7 7 0 0 0 2.275-1.521 8.4 8.4 0 0 0-1.197-.49 9 9 0 0 1-.481 1.078 7 7 0 0 1-.597.933M8.5 11.909v3.014c.67-.204 1.335-.82 1.887-1.855q.216-.403.395-.872A12.6 12.6 0 0 0 8.5 11.91zm3.555-.401c.57.185 1.095.409 1.565.667A6.96 6.96 0 0 0 14.982 8.5h-2.49a13.4 13.4 0 0 1-.437 3.008M14.982 7.5a6.96 6.96 0 0 0-1.362-3.675c-.47.258-.995.482-1.565.667.248.92.4 1.938.437 3.008zM11.27 2.461q.266.502.482 1.078a8.4 8.4 0 0 0 1.196-.49 7 7 0 0 0-2.275-1.52c.218.283.418.597.597.932m-.488 1.343a8 8 0 0 0-.395-.872C9.835 1.897 9.17 1.282 8.5 1.077V4.09c.81-.03 1.577-.13 2.282-.287z" />
                                            </svg></i></i></div>
                                <h5 class="card-title my-3">SEO Services</h5>
                                <p class="card-text">Leverage AI-powered tools for comprehensive SEO optimization. Create backlinks, generate front links, and improve search rankings to drive traffic and visibility.</p>
                            </div>
                            <button class="button animation-btn" style="width:200px;">
                                <div class="bg"></div>
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 342 208"
                                    height="208" width="342" class="splash">
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M54.1054 99.7837C54.1054 99.7837 40.0984 90.7874 26.6893 97.6362C13.2802 104.485 1.5 97.6362 1.5 97.6362">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M285.273 99.7841C285.273 99.7841 299.28 90.7879 312.689 97.6367C326.098 104.486 340.105 95.4893 340.105 95.4893">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 64.9917C281.133 64.9917 287.96 49.8089 302.934 48.2295C317.908 46.6501 319.712 36.5272 319.712 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M281.133 138.984C281.133 138.984 287.96 154.167 302.934 155.746C317.908 157.326 319.712 167.449 319.712 167.449">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 57.4476C230.578 57.4476 225.785 41.5051 236.061 30.4998C246.337 19.4945 244.686 12.9998 244.686 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M230.578 150.528C230.578 150.528 225.785 166.471 236.061 177.476C246.337 188.481 244.686 194.976 244.686 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 57.0278C170.392 57.0278 173.89 42.1322 169.571 29.54C165.252 16.9478 168.751 2.05227 168.751 2.05227">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M170.392 150.948C170.392 150.948 173.89 165.844 169.571 178.436C165.252 191.028 168.751 205.924 168.751 205.924">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 57.4476C112.609 57.4476 117.401 41.5051 107.125 30.4998C96.8492 19.4945 98.5 12.9998 98.5 12.9998">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3"
                                        d="M112.609 150.528C112.609 150.528 117.401 166.471 107.125 177.476C96.8492 188.481 98.5 194.976 98.5 194.976">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 64.9917C62.2941 64.9917 55.4671 49.8089 40.4932 48.2295C25.5194 46.6501 23.7159 36.5272 23.7159 36.5272">
                                    </path>
                                    <path stroke-linecap="round" stroke-width="3" stroke-opacity="0.3"
                                        d="M62.2941 145.984C62.2941 145.984 55.4671 161.167 40.4932 162.746C25.5194 164.326 23.7159 174.449 23.7159 174.449">
                                    </path>
                                </svg>

                                <div class="wrap">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 221 42"
                                        height="42" width="221" class="path">
                                        <path stroke-linecap="round" stroke-width="3"
                                            d="M182.674 2H203C211.837 2 219 9.16344 219 18V24C219 32.8366 211.837 40 203 40H18C9.16345 40 2 32.8366 2 24V18C2 9.16344 9.16344 2 18 2H47.8855">
                                        </path>
                                    </svg>

                                    <div class="outline"></div>
                                    <div class="content">
                                        <span class="char char-3 state-1">

                                            <span data-label="C" style="--i: 1">C</span>
                                            <span data-label="O" style="--i: 2">O</span>
                                            <span data-label="M" style="--i: 3">M</span>
                                            <span data-label="I" style="--i: 4">I</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="G" style="--i: 6">G</span>
                                            <span data-label="S" style="--i: 7">S</span>
                                            <span data-label="O" style="--i: 8">O</span>
                                            <span data-label="O" style="--i: 9">O</span>
                                            <span data-label="N" style="--i: 10">N</span>
                                        </span>

                                        <div class="icon">
                                            <div></div>
                                        </div>

                                        <span class="char state-2">
                                            <span data-label="J" style="--i: 1">J</span>
                                            <span data-label="o" style="--i: 2">o</span>
                                            <span data-label="i" style="--i: 3">i</span>
                                            <span data-label="n" style="--i: 4">n</span>
                                            <span data-label="N" style="--i: 5">N</span>
                                            <span data-label="o" style="--i: 6">o</span>
                                            <span data-label="w" style="--i: 7">w</span>
                                        </span>
                                    </div>
                                </div>
                            </button>
                        </div>
                    </div><!--/*col -->

                </div><!--/*row -->
            </div><!--/*container -->
        </section><!--/*section -->
        <!--End: My Services Section -->
    </main>

    <a href="https://wa.me/+971582422625" target="_blank" class="whatsapp-float">
		<img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp" class="whatsapp-icon">
	</a>


    <!-- Start: Scroll Top -->
    <a href="#" class="scroll-top"><i><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                fill="currentColor" class="bi bi-arrow-up-short" viewBox="0 0 16 16">
                <path fill-rule="evenodd"
                    d="M8 12a.5.5 0 0 0 .5-.5V5.707l2.146 2.147a.5.5 0 0 0 .708-.708l-3-3a.5.5 0 0 0-.708 0l-3 3a.5.5 0 1 0 .708.708L7.5 5.707V11.5a.5.5 0 0 0 .5.5" />
            </svg></i></a>
    <!-- End: Scroll Top -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" type="text/javascript"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous">
    </script>
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js" type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/services/js/services.js')); ?>" type="text/javascript"></script>
    <script>
        $('.social_media_tools').on('click', function() {
            var url = "<?php echo e(route('smm.home')); ?>";
            //location.href = url;
        });

        $(".openLogoMaker").on('click', function(){
            var url = "<?php echo e(route('logo.home')); ?>";
            location.href = url;
        });

    </script>
    <script>
        $(".open_mail_box").on('click', function() {
        });
    </script>
    <script>
        $(document).on('click', '.cgi-videos', function() {
            location.href = "<?php echo e(route('cgi.templates')); ?>";
        });

        $(document).on('click', '.viewCgiOrders', function(){
            var cgiOrders = "<?php echo e(route('cgi.orders')); ?>";
            location.href = cgiOrders;
        });

        $(document).on('click', '.ecommerceDashboard', function(){
            var url = $(this).attr('data-url');
            location.href = url;
        });

    </script>

</body>

</html>
<?php /**PATH D:\aflisocial\resources\views/services/services.blade.php ENDPATH**/ ?>