<!DOCTYPE html>
<html lang="en">

<head>
    <title>Afli Website Builder</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!--Bootstrap 5 css -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Style css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/editor/css/common.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/editor/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/editor/css/responsive.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-minicolors/2.3.6/jquery.minicolors.css">


    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Exo:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <style>
        body {
            font-family: "Exo", sans-serif !important;
            font-optical-sizing: auto;
            font-weight: 500;
            font-style: normal;
        }

        .exo {
            font-family: "Exo", sans-serif !important;
            font-optical-sizing: auto;
            font-weight: 500;
            font-style: normal;
        }

        .sidebar-menu .nav-link {
            font-family: "Exo", sans-serif !important;
            font-weight: 700;
            color: #198754 !important;
        }
    </style>

    <style>
        .minicolors-theme-default.minicolors {
            width: 100%;
        }

        .minicolors-theme-default.minicolors input {
            padding-left: 30px !important;
            padding-top: 15px !important;
            padding-bottom: 20px !important;
        }

        .lato-thin {
            font-family: "Lato", serif;
            font-weight: 400;
            font-style: normal;
        }

        .minicolors-theme-default .minicolors-swatch {
            margin-top: 10px !important;
        }

        .lato-bold {
            font-family: "Lato", serif;
            font-weight: 700;
            font-style: normal;
        }

        .loadingoverlay_element .loadingoverlay_text {
            text-align: center !important;
        }

        .theme-list {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            list-style: none;
            padding: 0;
            margin: 0;
        }

        .theme-heading-wrap {
            display: block;
            width: 80% !important;
        }

        .details-wrapper-left .details-theme-heading {
            padding-top: 4px !important;
        }

        #showWebsiteSetting label {
            float: left;
            margin-bottom: 5px;
        }

        #showWebsiteSetting {
            padding-left: 20px;
            padding-right: 20px;
        }

        .setting_input {
            width: 100%;
            font-size: 18px !important;
            padding-top: 10px !important;
            padding-bottom: 10px !important;
            padding-left: 10px !important;
        }

        .form-control {
            padding: .375rem .75rem !important;
        }

        .form-control_color {
            width: 100%;
            padding-top: 7px !important;
            padding-bottom: 7px !important;
            padding-left: 10px !important;
        }

        .custom-css-list {
            display: block;
            list-style: none;
            /* Remove default list styling */
            padding: 0;
            margin: 0;
        }

        .form-list {
            display: grid;
            gap: 10px;
            list-style: none;
            padding: 0;
            margin: 0;
            grid-template-columns: repeat(2, 1fr);
        }

        .form-list li {
            padding: 20px !important;
        }

        .widget-list {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            /* 2 columns of equal width */
            gap: 10px;
            /* Spacing between items */
            list-style: none;
            /* Remove default list styling */
            padding: 0;
            margin: 0;
        }

        .page-list {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            list-style: none;
            padding: 0;
            margin: 0;

        }

        .updateBtn {
            background-color: #6610f2 !important;
            border: none !important;
            padding-left: 30px;
            padding-right: 30px;
            padding-top: 10px;
            padding-bottom: 10px;
            border-radius: 30px;
            float: right;
        }

        .widget-btn {
            background-color: #6610f2 !important;
            border-radius: 0px;
            border: none !important;
            padding-left: 30px;
            padding-right: 30px;
            padding-top: 10px;
            padding-bottom: 10px;
            border-radius: 30px;
        }

        .hide {
            display: none;
        }

        .slider-wrapper {
            position: relative;
            width: 100%;
        }

        input[type="range"] {
            width: 100%;
            -webkit-appearance: none;
            appearance: none;
            height: 5px;
            background: #ddd;
            outline: none;
            border-radius: 5px;
            cursor: pointer;
        }

        /* Customize the slider thumb */
        input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 15px;
            height: 15px;
            background: green;
            border-radius: 50%;
            cursor: pointer;
            border: 2px solid #fff;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        input[type="range"]::-moz-range-thumb {
            width: 15px;
            height: 15px;
            background: green;
            border-radius: 50%;
            cursor: pointer;
            border: 2px solid #fff;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        /* Dot indicating value */
        .slider-dot {
            position: absolute;
            top: -12px;
            width: 10px;
            height: 10px;
            background: green;
            border-radius: 50%;
            transform: translateX(-50%);
        }

        #generateSlogan {
            background-color: #6610f2 !important;
            border-radius: 0px;
            border: none !important;
            padding-left: 30px;
            padding-right: 30px;
            padding-top: 10px;
            padding-bottom: 10px;
            border-radius: 30px;
        }

        .card-div {
            --card-width: 100%;
            --card-height: 350px;
            --card-image-height: 350px;
            --transition-duration: 2s;
            width: var(--card-width);
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px,
                rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
            padding: 10px;
            border-radius: 10px;
        }

        .widget-card-div {

            --card-height: 220px !important;
        }

        .card-div .hover-card {
            width: 100%;
            height: var(--card-height);
            border-radius: 12px;
            overflow: hidden;
            position: relative;
            cursor: pointer;
        }

        .card-div .image-container {
            width: 100%;
            height: 100%;
            position: relative;
            overflow: hidden;
            filter: blur(1px);
            transition: all var(--transition-duration) ease;
        }

        .card-div .image-container-widgets {
            width: 100%;
            height: 300px;
            position: relative;
            overflow: hidden;
            filter: blur(0px);
            transition: all var(--transition-duration) ease;
        }

        .card-div .hover-card:hover .image-container-widgets {
            filter: blur(0px);
        }

        .card-div .scrolling-image {
            width: 100%;
            object-fit: cover;
            transform: translateY(0);
            transition: transform var(--transition-duration) ease-out;
        }

        .card-div .hover-card:hover .scrolling-image {
            transform: translateY(calc(-100% + var(--card-height)));
        }


        .card-div .card-text {
            color: black;
            text-align: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .card-div .card-text h1 {
            font-size: 0.8vw;
            text-transform: uppercase;
            background: black;
            padding: 0px 20px;
            color: white;
            border-radius: 15px;
            transition: all var(--transition-duration) ease;
            z-index: 10;
        }

        .card-div .hover-card:hover .card-text h1 {
            opacity: 0.6;
        }

        #uiSetting {
            background-color: #fff;
            position: absolute;
            top: 30%;
            right: 0px;
            min-width: 350px;
            max-width: 350px;
        }

        #uiSetting .card {
            border-radius: 0px !important;
        }

        .color-circle-red {
            background: red;
            /* Gradient split into two colors */
        }

        .color-circle-blue {

            background: blue;
            /* Gradient split into two colors */
        }

        .color-circle-purple {
            background: purple;
            /* Gradient split into two colors */
        }

        .color-circle-green {
            background: #28A745;
        }

        .color-circle-black {
            background: #212529;
        }

        .color-circle-orange {
            background: #FD7E14;
        }

        .colorCircle {

            width: 50px;
            /* Set the width of the circle */
            height: 50px;
            /* Set the height of the circle */
            border: 2px solid lightgray;
            /* Border for the circle */
            border-radius: 50%;
            /* Makes it a perfect circle */
        }

        .colorGradient {
            width: 50px;
            /* Set the width of the circle */
            height: 50px;
            /* Set the height of the circle */
            border: 2px solid lightgray;
            /* Border for the circle */
            border-radius: 50%;
            /* Makes it a perfect circle */
            margin-top: 20px;

        }

        .colorGradient:hover {
            border: 2px solid #a8a8a8;
        }

        .gradient1 {
            background: linear-gradient(to right, #ff9a8b, #ff6a88);
        }

        .gradient2 {
            background: linear-gradient(to right, #6a11cb, #2575fc);
        }

        .gradient3 {
            background: linear-gradient(to right, #ff9a8b, #ffdde1);
        }

        .gradient4 {
            background: linear-gradient(to right, #6a11cb, #8e44ad);
        }

        .gradient5 {
            background: linear-gradient(to right, #ff6a88, #ff9a8b);
        }

        .gradient6 {
            background: linear-gradient(to right, #2575fc, #6a11cb);
        }

        .colorCircle:hover {
            border: 2px solid #a8a8a8;
        }

        #updateUiWebSetting {
            width: 100%;
            border-radius: 0px;
        }

        .colorActive {
            border: 2px solid green !important;
        }

        .theme-heading-wrap {}

        .theme-heading-wrap div {
            width: 100% !important;
        }

        .theme-heading-wrap h5 {
            width: 100% !important;
        }

        .details-wrapper-left ul li:hover {
            border-color: rgb(242, 75, 167);
        }

        .details-wrapper-left ul li:hover .details-theme-heading {
            background-color: rgb(242, 75, 167);
            color: #fff;
        }

        .details-wrapper-left ul li:hover .details-theme-heading:before {
            border-top: 30px solid rgb(242, 75, 167) !important;
        }

        .fixed-bottom1 {
            position: fixed;
            bottom: 0px;
            background-color: #fff;
            width: 260px;
        }
        .right-sidebar
        {
            height: 100vh !important;
            width:300px;
            max-width:400px;
            background-color: #fff;
            position: absolute;
            top: 0px;
            right: -400px;
            border-right: 1px solid #a8a8a8;
            overflow-x: hidden;
        }
        .right-sidebar-open
        {
            right: 0px;
        }
    </style>
    <?php echo $__env->yieldContent('css'); ?>
</head>

<body>

    <?php echo $__env->yieldContent('content'); ?>

    <button type="button" id="scrollTop"><i class="fa fa-angle-up"></i></button>
    <script>
        let aiUrl = '<?= url('/') ?>' + '\/ai\/';
        let baseUrl = '<?= url('/') ?>' + '\/';
        let _token = '<?= csrf_token() ?>';
        let selectedTheme = '<?= $selected_theme ?>';
        let subscriptionId = '<?= $subscription_id ?>';
        var projectId = '<?= $project_id ?>';
    </script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"
        integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-minicolors/2.3.6/jquery.minicolors.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
    <script src="<?php echo e(asset('assets/editor/js/custom.js')); ?>"></script>
    <script>
        let csrfToken = "<?php echo e(csrf_token()); ?>";
    </script>
    <script src="<?php echo e(asset('assets/editor/js/editor.js?v=' . time())); ?>"></script>
    <script>
        $(document).ready(function() {
            var themeSelected = "<?php echo e($selected_theme); ?>";
            if (!themeSelected) {
                $("#show-theme").click();
            }
        });
    </script>

    <script>
        $("#generateSlogan").on('click', function() {
            var brandName = $("#update_brand_name").val();
            if (!brandName) {
                $("#update_brand_name").addClass('red_border');
                $("#update_brand_name").focus();
                generalError("Please fill in all required fields to generate slogan");
                return;
            }

            var category = $("#businessCategory").val();
            if (!category || category == "") {
                $("#businessCategory").focus();
                $("#businessCategory").addClass('red_border');
                generalError("Please fill in all required fields to generate slogan");
                return;
            }

            var url = "<?php echo e(url('ai/content-generate')); ?>";
            var content = 'Generate a slogan, my brand name is ' + brandName + ' and category is ' + category +
                " and return in json";
            var data = {
                content: content,
                _token: "<?php echo e(csrf_token()); ?>"
            }
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            $.post(url, data, function(data) {
                btn.html(btn_html);
                if (!data.result) {
                    if (data.msg) {
                        generalError(data.msg)
                        return;
                    }

                    generalError("Some error occured");
                    return;
                }

                var slogan = data.slogan;
                $("#update_slogan").val(slogan);

            });


        });

        function generalError(msg) {
            $.confirm({
                title: "Error",
                content: msg,
                icon: "fa fa-times-circle",
                type: "red",
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }
                }
            });
        }
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
    <script>
        $("#clearLinkButton").on("click", function() {
            // Clear the input field value
            $("#new_link").val("");
        });

        $("#openWebUiSetting").on('click', function() {
            $("#uiSetting").removeClass('hide');
        });
        $("#closeRightBar").on('click', function() {
            $("#uiSetting").addClass('hide');
        });

        $("#generateContent").on('click', function() {
            var text = $("#editorText").val();
            var subscriptionId = subscriptionId;
            var url = "<?php echo e(route('aiBuilder.generateContent')); ?>";
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            $.post(url, {
                _token: "<?php echo e(csrf_token()); ?>",
                subscriptionId: projectId,
                text: text
            }, function(data) {
                btn.html(btn_html);
                if (!data.result) {
                    var msg = "Some error occured";
                    if (data.msg) {
                        msg = data.msg;
                    }
                    generalError(msg);
                    return;
                }

                const jsonData = data.msg || "";
                const cleanedContent = jsonData.replace(/^```json\n|```$/g, "").trim();

                try {
                    const jsData = JSON.parse(cleanedContent); // Parse JSON content
                    const firstString = Object.values(jsData).find(value => typeof value === "string");
                    if (firstString) {
                        $("#editorText").val(firstString);
                    }

                } catch (e) {
                    console.error("Error parsing JSON content:", e);
                }

            }).fail(function() {
                btn.html(btn_html);
            })
        });
    </script>
    <script>
        document.getElementById("newImageEditor").addEventListener("change", function(event) {
            const file = event.target.files[0]; // Get the selected file
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const imgElement = document.getElementById("image__view");
                    imgElement.src = e.target.result; // Set the image source
                    imgElement.style.display = "block"; // Show the image
                };
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        });

        document.getElementById("backgroundImageInput").addEventListener("change", function(event) {
            const file = event.target.files[0]; // Get the selected file
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const imgElement = document.getElementById("background_img_view");
                    $("#backgroundImageView").show();
                    imgElement.src = e.target.result; // Set the image source
                    imgElement.style.display = "block"; // Show the image
                };
                reader.readAsDataURL(file); // Read the file as a data URL
            }
        });
    </script>
    <?php echo $__env->yieldContent('js'); ?>
</body>

</html>
<?php /**PATH D:\aflisocial\resources\views/aibuilder/editor_layouts/app.blade.php ENDPATH**/ ?>