
<?php $__env->startSection('page-style'); ?>
    <style>
        .hide {
            display: none
        }

        td {
            white-space: nowrap;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="page-header">
        <h4 class="page-title"><?php echo e(__('User List')); ?></h4>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="<?php echo e(route('domain.index')); ?>">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="<?php echo e(route('domain.index')); ?>"><?php echo e(__('User List')); ?></a>
            </li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-4">
                            <div class="card-title d-inline-block"><?php echo e(__('User Lists')); ?></div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                 
                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-hover table-stripped" id="dataTable">
                                        <thead>
                                            <th>Email</th>
                                            <th>Wallet</th>
                                            <th>Add Balance</th>
                                            <th>Whatsapp</th>
                                            <th>Last Login Ip</th>
                                            <th>Last Login Time</th>
                                            <th>Account Creation Date</th>
                                            <th>Last Login Agent</th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <?php echo e($user->email); ?>

                                                    </td>
                                                    <td>
                                                        AED <?php echo e($user->walletbalance); ?>

                                                    </td>
                                                    <td>
                                                        <button class="btn btn-sm btn-primary add_balance" data-id="<?php echo e($user->id); ?>">Add Balance</button>
                                                    </td>
                                                    <td>
                                                        <?php if($user->whatsapp): ?>
                                                            <?php echo e($user->whatsapp); ?>

                                                        <?php else: ?>
                                                            No Whatsapp Added
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php if($user->lastLogin && $user->lastLogin->ip_address): ?>
                                                            <?php echo e($user->lastLogin->ip_address); ?>

                                                        <?php else: ?>
                                                            Not Found
                                                        <?php endif; ?>
                                                    </td>
                                                    <td data-order="<?php echo e($user->lastLogin && $user->lastLogin->login_at ? strtotime($user->lastLogin->login_at) : strtotime($user->created_at)); ?>">
                                                        <?php if($user->lastLogin && $user->lastLogin->login_at): ?>
                                                            <?php echo e(date('d F Y H:i', strtotime($user->lastLogin->login_at))); ?>

                                                        <?php else: ?>
                                                            Not Found
                                                        <?php endif; ?>
                                                    </td>

                                                    <td data-order="<?php echo e(strtotime($user->created_at)); ?>">
                                                        <?php echo e(date('d F Y H:i', strtotime($user->created_at))); ?>

                                                    </td>
                                                    <td style="width:50px;">
                                                        
                                                        <?php if($user->lastLogin && $user->lastLogin->user_agent): ?>
                                                            <?php echo e($user->lastLogin->user_agent); ?>

                                                        <?php else: ?>
                                                            Not Found
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
      


                </div>
            </div>
        </div>
    </div>

    <div id="errorbox"
        style="text-shadow: 1px 1px #999;border-radius:10px;position:fixed;top:80px;right:10px;width:300px;background-color:red;padding:20px; opacity: 0.8;color:#FFF;display:none;">
    </div>


    <div class="modal fade" id="nameServerModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update Name Servers</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">NS1</label>
                                <input type="text" name="ns1" id="ns1" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">NS2</label>
                                <input type="text" name="ns1" id="ns2" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updateNameServers">Update</button>
                </div>
            </div>
        </div>
    </div>

     <div class="modal fade" id="userBalanceModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Update User Balance</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Amount</label>
                                <input type="text" name="amount" id="balanceAmount" class="form-control">
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="updateUserBalance">Update</button>
                </div>
            </div>
        </div>
    </div>

    <input type="hidden" name="domain" id="nsdomain">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {
            // Initialize the DataTable
            var table = $("#dataTable").DataTable({
                order: [[3, "asc"]], 
            });
        });
    </script>
    <script>
        <?php if(session('error')): ?>

            Swal.fire({
                title: "Error",
                text: "<?php echo e(session('error')); ?>",
                icon: "error"
            })
        <?php endif; ?>
        <?php if(session('success')): ?>

            Swal.fire({
                title: "Success",
                text: "<?php echo e(session('success')); ?>",
                icon: "success"
            })
        <?php endif; ?>
    </script>
    <script>
        $(document).on('click', '.add_balance', function(){
            var userId = $(this).attr('data-id');
            $("#updateUserBalance").attr('data-id', userId);
            $("#userBalanceModal").modal('show');
        });

        $("#updateUserBalance").on('click', function(){
            var userId = $(this).attr('data-id');
            var amount = $("#balanceAmount").val();
            if(!userId)
            {
                Swal.fire({
                    title:"Error",
                    text:"Please select user",
                    icon:"error"
                })
                return;
            }

            if(!amount)
            {
                Swal.fire({
                    title:"Error",
                    text:"Please select amount",
                    icon:"error"
                })
                return;
            }
            var data = {userId:userId, amount:amount, _token:"<?php echo e(csrf_token()); ?>"};
            var url = "<?php echo e(route('admin.addBalance')); ?>";
            $.post(url, data, function(data){
                console.log(data);
                if(!data.result)
                {
                    Swal.fire({
                        title:"Error",
                        text:"Some error occured",
                        icon:"error"
                    })
                    return;
                } 
                Swal.fire({
                    title:"Success",
                    text:"Balance added",
                    icon:"success"
                }).then(function(){
                    location.reload();
                })
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/admin/users.blade.php ENDPATH**/ ?>