<!DOCTYPE html>
<html lang="en">

<head>
    <title>Afli | Ecommerce</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">

    <!-- Style css -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/editor/css/common.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/editor/css/style.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/editor/css/responsive.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('assets/editor/css/modal.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-minicolors/2.3.6/jquery.minicolors.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&display=swap"
        rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Exo:ital,wght@0,100..900;1,100..900&display=swap"
        rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <style>

        input[type="range"]
        {
            padding:0px !important;
        }

        #sectionContent
        {
            position: absolute;
            right: 0px;
            width: 300px;
            top: 0px;
            background-color: #fff;
            border-left: 1px solid #000;
            height: 100vh !important;
        }
        .close-section
        {
            right: -300px !important;
        }
        body{
            font-family: "Exo", sans-serif !important;
        }

        .exo {
            font-family: "Exo", sans-serif;
            font-optical-sizing: auto;
            font-style: normal;
        }

        .page-wrapper {
            height: 97vh !important;
            overflow: hidden !important;

        }

        .mini-width {
            width: 450px !important;
        }

        #themeIframe {
            margin-top: 0px !important;
            width: 100% !important;
            height: 100vh !important;
        }

        .lato {
            font-family: "Lato", serif;
            font-weight: 400;
            font-style: normal;
        }

        .activeTheme {
            border: 1px solid #d63384 !important;
        }

        .seperator {
            padding: 20px !important;
        }

        .seperator:hover {
            border: 1px solid #d63384 !important;
        }
        .form-control[type=file]:not(:disabled):not([readonly])
        {
            padding:10px !important;
        }

        #bottomButtons {
            background-color: white;
            width: 270px;
            position: fixed;
            bottom: 0px;
            left: 0px;
            border-right: 5px solid #a8a8a8;
        }

        .sidebar-content {
            height: calc(100% - 50px) !important;
        }
    </style>

    <?php if($websiteColors): ?>
        <?php
            $decodedColors = json_decode($websiteColors, true);
        ?>

        <?php if(!empty($decodedColors['primary']) && !empty($decodedColors['secondary'])): ?>
            <style>
                :root {
                    --user-primary-color: <?php echo e(e($decodedColors['primary'])); ?>;
                    --user-secondary-color: <?php echo e(e($decodedColors['secondary'])); ?>;
                    --user-background-color: <?php echo e(e($decodedColors['type'] ?? '') === 'gradient' ? $decodedColors['gradient'] : $decodedColors['primary']); ?>;
                }

                .userBackgroundColor {
                    background-color: var(--user-primary-color) !important;
                }
            </style>
        <?php endif; ?>
    <?php endif; ?>



    <style>
        .loadingoverlay_element .loadingoverlay_text {
            text-align: center !important;
        }


        .theme-list {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            /* 2 columns of equal width */
            gap: 10px;
            /* Spacing between items */
            list-style: none;
            /* Remove default list styling */
            padding: 0;
            margin: 0;
        }

        .custom-css-list {
            display: block;
            list-style: none;
            /* Remove default list styling */
            padding: 0;
            margin: 0;
        }

        .widget-list {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            /* 2 columns of equal width */
            gap: 10px;
            /* Spacing between items */
            list-style: none;
            /* Remove default list styling */
            padding: 0;
            margin: 0;
        }

        .widget-btn {
            background-color: #6610f2 !important;
            border-radius: 0px;
            border: none !important;
            padding-left: 30px;
            padding-right: 30px;
            padding-top: 10px;
            padding-bottom: 10px;
            border-radius: 30px;
        }

        .replace_section {
            height: 100px !important;
        }

        .hide {
            display: none;
        }

        .slider-wrapper {
            position: relative;
            width: 100%;
        }

        input[type="range"] {
            width: 100%;
            -webkit-appearance: none;
            appearance: none;
            height: 5px;
            background: #ddd;
            outline: none;
            border-radius: 5px;
            cursor: pointer;
        }

        /* Customize the slider thumb */
        input[type="range"]::-webkit-slider-thumb {
            -webkit-appearance: none;
            appearance: none;
            width: 15px;
            height: 15px;
            background: green;
            border-radius: 50%;
            cursor: pointer;
            border: 2px solid #fff;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        input[type="range"]::-moz-range-thumb {
            width: 15px;
            height: 15px;
            background: green;
            border-radius: 50%;
            cursor: pointer;
            border: 2px solid #fff;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.2);
        }

        .minicolors-theme-default .minicolors-input {
            display: flex !important;
            height: 50px !important;
            width: 50px !important;
            padding-left: 0px !important;
        }

        .minicolors-theme-default .minicolors-swatch {
            display: none !important;
        }

        .selectedSection {
            border-color: #d63384 !important;
        }

        /* Dot indicating value */
        .slider-dot {
            position: absolute;
            top: -12px;
            width: 10px;
            height: 10px;
            background: green;
            border-radius: 50%;
            transform: translateX(-50%);
        }

        #optionContent {
            border-right: 1px solid #ddd;
        }

        .hide {
            display: none !important;
        }

        .slider_card:hover {
            border: 1px solid rgb(242, 75, 167)
        }

        .slider_card .slider_image {
            height: 150px;
            width: 100%;
            object-fit: cover;
        }

        .change_featured_product {
            height: 350px;
        }

        .featured_card:hover {
            border: 1px solid rgb(242, 75, 167)
        }

        .inputSetting {
            border: 1px solid rgb(242, 75, 167) !important;
            padding: 5px 10px !important;
            font-size: 18px !important;
            color: rgb(242, 75, 167) !important;
        }

        .btn-setting {
            background: rgb(242, 75, 167) !important;
            float: right;
            color: #fff;
            border-radius: 50px;
            font-size: 18px;
            padding: 10px 30px;
        }

        .inputGroup label {
            text-align: left !important;
            float: left !important;
            color: rgb(242, 75, 167) !important;
        }

        .change_trending_section {
            height: 200px;
        }

        .card-div {
            --card-width: 100%;
            --card-height: 350px;
            --card-image-height: 350px;
            --transition-duration: 2s;
            width: var(--card-width);
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px,
                rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
            padding: 10px;
            border-radius: 10px;
        }

        .widget-card-div {

            --card-height: 220px !important;
        }

        .card-div .hover-card {
            width: 100%;
            height: var(--card-height);
            border-radius: 12px;
            overflow: hidden;
            position: relative;
            cursor: pointer;
        }

        .card-div .image-container {
            width: 100%;
            height: 100%;
            position: relative;
            overflow: hidden;
            filter: blur(1px);
            transition: all var(--transition-duration) ease;
        }

        .card-div .image-container-widgets {
            width: 100%;
            height: 300px;
            position: relative;
            overflow: hidden;
            filter: blur(0px);
            transition: all var(--transition-duration) ease;
        }

        .card-div .hover-card:hover .image-container-widgets {
            filter: blur(0px);
        }

        .card-div .scrolling-image {
            width: 100%;
            object-fit: cover;
            transform: translateY(0);
            transition: transform var(--transition-duration) ease-out;
        }

        .card-div .hover-card:hover .scrolling-image {
            transform: translateY(calc(-100% + var(--card-height)));
        }


        .card-div .card-text {
            color: black;
            text-align: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .card-div .card-text h1 {
            font-size: 0.8vw;
            text-transform: uppercase;
            background: black;
            padding: 0px 20px;
            color: white;
            border-radius: 15px;
            transition: all var(--transition-duration) ease;
            z-index: 10;
        }

        .card-div .hover-card:hover .card-text h1 {
            opacity: 0.6;
        }


        #shapesOption {
            height: 90%;
            overflow: scroll;
            width: 100%;
        }

        .sidebar-right {
            min-height: 100vh !important;
            position: fixed;
            right: -300px;
            top: 0px;
            min-width: 300px;
            background-color: #fff;
            z-index: 999;
            border-left: 2px solid #ccc;
            /* Left border */
            box-shadow: -5px 0 10px rgba(0, 0, 0, 0.1);
            /* Left shadow */
            padding-left: 20px;
            padding-right: 20px;
        }

        #closeRightSideBar {
            margin-top: 10px;
        }

        .minicolors-theme-bootstrap .minicolors-swatch {
            top: 23px;
            height: 35px;
        }

        .textColorsRow .minicolors-theme-bootstrap .minicolors-swatch {
            top: 3px !important;
        }

        #sectionBackgroundRow .minicolors-theme-bootstrap .minicolors-swatch {
            top: 3px !important;
        }

        .page-wrapper.toggled-right .form-control-popup {
            height: 45px;
            padding-left: 35px;
            font-family: "Lato", serif;
            font-weight: 400;
            font-style: normal;
        }

        #generateThemeColor {
            width: 100%;
            height: 50px;
            margin-top: 15px;
        }

        .themeCard {
            padding: 2px !important;
        }

        .themeCard p {
            float: left !important;
            margin-bottom: 2px !important;
            width: 60% !important;
            background-color: lightgray !important;
            text-align: left !important;
            height: 30px !important;
            line-height: 30px !important;
            padding-left: 20px !important;
            padding-bottom: 5px !important;
            color: #000 !important;
            font-weight: 700 !important;
            clip-path: polygon(0% 0%, 100% 0%, 100% 0%, 80% 100%, 0% 100%);

        }

        .selectedSection .themeCard p {
            background-color: #d63384 !important;
            color: #fff !important;
        }

        #bestSectionRow .select2 {
            width: 100% !important;
            float: left;
            text-align: left;
            font-family: "Exo", sans-serif;
        }

        #bestSectionRow .select2-container .select2-selection--single {
            height: 40px !important;
            padding-top: 5px !important;
        }

        #bestSectionRow .select2-container--default .select2-selection--single .select2-selection__arrow {
            top: 5px !important;
        }

        .themeCard p span {}

        .select2-container{
            width:100% !important;
        }
        .select2-container--default .select2-selection--single{
            height: 40px !important;
            padding-top:6px !important;
        }
        .select2-container--default .select2-selection--single .select2-selection__arrow
        {
            height:35px !important;
        }
    </style>


</head>

<body>

    <div class="page-wrapper toggled-left toggled-right">

        <a id="show-sidebar-left" class="show-sidebar btn btn-sm btn-dark" href="javascript:void(0)">
            <i class="fa fa-bars"></i>
        </a>



        <nav class="sidebar sidebar-wrapper-left">
            <div class="sidebar-content hide" id="seperatorOptions">
                <div class="sidebar-brand">
                    <a href="#" class="theme-heading">Seperators</a>
                    <div class="close-sidebar" id="close-sidebar-seperator">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu">
                    <ul>
                        <li style="justify-content:center !important;" id="sectionBackgroundRow">
                            <div class="form-group" style="width:100%;">
                                <label for="" class="lato">Solid Background</label>
                                <input type="text" name="section_background" id="svgBackgroundColor"
                                    class="form-control" style="height:42px !important;padding-left:40px !important;">
                            </div>
                        </li>

                        <li style="justify-content:center !important;">
                            <div class="form-group" style="width:100%;">
                                <label for="" class="lato">Size</label>
                                <input type="range" value="100" name="left" id="border_width" min="0"
                                    max="100" class="form-control">
                            </div>
                        </li>
                        <li style="justify-content:center !important;">
                            <button class="btn btn-md btn-danger" id="removeSeperator"
                                style="font-size:18px;border-radius:50px;width:100%;">Remove</button>
                        </li>

                    </ul>
                </div>
            </div>
            <div class="sidebar-content hide" id="linkOptions">
                <div class="sidebar-brand">
                    <a href="#" class="theme-heading">Options</a>
                    <div class="close-sidebar" id="close-sidebar-link-options">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu">
                    <ul>

                    </ul>
                </div>

            </div>
            <div class="sidebar-content hide" id="sectionOptions">
                <div class="sidebar-brand">
                    <a href="#" class="theme-heading">Section<i class="fa fa-refresh ps-1"></i></a>
                    <div class="close-sidebar" id="close-sidebar-left-section-options">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu">
                    <ul>
                        <li style="justify-content:center !important;" id="sectionBackgroundRow">
                            <div class="form-group" style="width:100%;">
                                <label for="" class="lato">Solid Background</label>
                                <input type="text" name="section_background" id="section_background"
                                    class="form-control" style="height:42px !important;padding-left:40px !important;">
                            </div>
                        </li>
                        <li id="sectionBackgroundGradientRow">
                            <div class="row">
                                <div class="col-md-12">
                                    <p class="lato">Gradient Background</p>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group textColorsRow">
                                        <input type="text" name="section_background" id="gradient_color1"
                                            class="form-control"
                                            style="height:42px !important;padding-left:40px !important;">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group textColorsRow">
                                        <input type="text" name="section_background" id="gradient_color2"
                                            class="form-control"
                                            style="height:42px !important;padding-left:40px !important;">
                                    </div>
                                </div>
                                <div class="col-md-12" style="text-align:right !important;">
                                    <a href="javascript:void()" id="generateGradient" class="btn btn-sm btn-primary"
                                        style="font-size:18px;font-weight:700;">Generate</a>
                                </div>
                                <div class="col-md-12" id="gradientsSectionColors">

                                </div>
                            </div>

                        </li>
                        <li class="px-3">
                            <div class="row" id="sectionImages">
                                
                            </div>
                        </li>
                        <li class="px-3">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="">Background Image</label>
                                        <input type="file" name="sectionBackgroundImage"
                                            id="sectionBackgroundImage" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <div>
                                        <button class="btn btn-sm btn-dark" style="width:100%;font-size:14px;"
                                            id="updateSectionBackgroundBtn">Update</button>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li>
                            <div class="row">
                                <div class="col-md-12">
                                    <h6 style="font-weight: 700;" class="lato">Separator</h6>
                                </div>
                                <div class="col-md-12 d-flex justify-content-between mt-3">
                                    <button class="btn btn-md btn-primary lato showSeperators" data-position="top"
                                        style="width:48%;">Top</button>
                                    <button class="btn btn-md btn-primary lato showSeperators" data-position="bottom"
                                        style="width:48%;">Bottom</button>
                                </div>
                            </div>
                        </li>

                        <li>
                            <div class="row">
                              <div class="col-md-12 mb-3">
                                <h6 style="font-weight: 700;">Paddings</h6>
                              </div>
                          
                              <!-- LEFT -->
                              <div class="col-md-12">
                                <div class="form-group">
                                  <label>Left</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="left_padding_range" min="0" max="60" class="form-control">
                                    <input type="number" value="10" id="left_padding_input" class="form-control" style="width: 70px;">
                                  </div>
                                </div>
                              </div>
                          
                              <!-- RIGHT -->
                              <div class="col-md-12 mt-3">
                                <div class="form-group">
                                  <label>Right</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="right_padding_range" min="0" max="60" class="form-control">
                                    <input type="number" value="10" id="right_padding_input" class="form-control" style="width: 70px;">
                                  </div>
                                </div>
                              </div>
                          
                              <!-- TOP -->
                              <div class="col-md-12 mt-3">
                                <div class="form-group">
                                  <label>Top</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="top_padding_range" min="0" max="60" class="form-control">
                                    <input type="number" value="10" id="top_padding_input" class="form-control" style="width: 70px;">
                                  </div>
                                </div>
                              </div>
                          
                              <!-- BOTTOM -->
                              <div class="col-md-12 mt-3">
                                <div class="form-group">
                                  <label>Bottom</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="bottom_padding_range" min="0" max="60" class="form-control">
                                    <input type="number" value="10" id="bottom_padding_input" class="form-control" style="width: 70px;">
                                  </div>
                                </div>
                              </div>
                            </div>
                          </li>
                          
                       
                        <li>
                            <div class="row">
                              <div class="col-md-12 mb-3">
                                <h6 style="font-weight: 700;">Margin</h6>
                              </div>
                          
                              <!-- LEFT -->
                              <div class="col-md-12">
                                <div class="form-group">
                                  <label>Left (<span id="sectionLeftMargin">0px</span>)</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="left_margin_range" min="-100" max="100" class="form-control">
                                    <input type="number" value="10" id="left_margin_input" class="form-control" style="width: 80px;">
                                  </div>
                                </div>
                              </div>
                          
                              <!-- RIGHT -->
                              <div class="col-md-12 mt-3">
                                <div class="form-group">
                                  <label>Right (<span id="sectionRightMargin">0px</span>)</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="right_margin_range" min="-100" max="100" class="form-control">
                                    <input type="number" value="10" id="right_margin_input" class="form-control" style="width: 80px;">
                                  </div>
                                </div>
                              </div>
                          
                              <!-- TOP -->
                              <div class="col-md-12 mt-3">
                                <div class="form-group">
                                  <label>Top (<span id="sectionTopMargin">0px</span>)</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="top_margin_range" min="-100" max="100" class="form-control">
                                    <input type="number" value="10" id="top_margin_input" class="form-control" style="width: 80px;">
                                  </div>
                                </div>
                              </div>
                          
                              <!-- BOTTOM -->
                              <div class="col-md-12 mt-3">
                                <div class="form-group">
                                  <label>Bottom (<span id="sectionBottomMargin">0px</span>)</label>
                                  <div class="d-flex align-items-center gap-2">
                                    <input type="range" value="10" id="bottom_margin_range" min="-100" max="100" class="form-control">
                                    <input type="number" value="10" id="bottom_margin_input" class="form-control" style="width: 80px;">
                                  </div>
                                </div>
                              </div>
                            </div>
                          </li>
                          


                    </ul>
                </div>
            </div>
            <div class="sidebar-content hide" id="optionContent">
                <div class="sidebar-brand">
                    <a href="#" class="theme-heading exo" id="showThemesMenu">Theme <i
                            class="fa fa-refresh ps-1"></i></a>
                    <div class="close-sidebar" id="close-sidebar-left-options">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu">
                    <ul>
                        <li class="w-100 image_options">
                            <div class="container">
                                <div class="row">
                                    <div class="col">
                                        <div class="form-group lato">
                                            <label for="imageUpload" class="lato">Upload Image</label>
                                            <input type="file" name="imageUpload" id="imageUpload"
                                                class="form-control" style="padding:.375rem .75rem !important">
                                        </div>
                                    </div>
                                </div>

                                <div class="row my-3">
                                    <div class="col">
                                        <img src="" alt="Uploaded image preview" id="imageUploaded"
                                            class="img-fluid px-3"
                                            style="height:200px;object-fit:cover;display:none;">
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-6 text-center">
                                        <button class="btn btn-sm btn-primary" id="updateImageBtn"
                                            style="width:100%; background-color:#6727F2; font-size:18px; border-radius:50px;">
                                            Update
                                        </button>
                                    </div>
                                    <div class="col-6 text-center">
                                        <button class="btn btn-sm btn-primary" id="editImagePopup"
                                            style="width:100%; background-color:#6727F2; font-size:18px; border-radius:50px;">
                                            Edit
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </li>

                        <li class="button_options">
                            <div class="form-group" style="width:100%;">
                                <label for="" class="exo">Link Types</label>
                                <select name="link_type" id="link_type" class="form-control exo"
                                    style="font-size: 14px;padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                    <option value="0">Select Options</option>
                                    <option value="categories">Categories</option>
                                    <option value="brands">Brands</option>
                                    <option value="products">Product</option>
                                    <option value="featured">Featured Products</option>
                                    <option value="latest_products">Latest Products</option>
                                    <option value="new_arrival">New Arrivals</option>
                                    <option value="best_seller">Best Seller</option>
                                    <option value="trending">Trending Products</option>
                                    <option value="pages">Pages</option>
                                    <option value="custom">Others</option>
                                </select>
                            </div>
                        </li>
                        <li class="link__types hide" id="innerPagesRow">
                            <div class="form-group" style="width:100%;">
                                <label for="" class="exo">Pages</label>
                                <select name="linkedPages" id="linkedPages" class="form-control exo"
                                    style="font-size: 14px;padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                    <option value="">Select Page</option>
                                    <option value="<?php echo e($baseDomain); ?>">Homepage</option>
                                    <option value="<?php echo e($baseDomain); ?>/login">Login</option>
                                    <option value="<?php echo e($baseDomain); ?>/register">Register</option>
                                    <option value="<?php echo e($baseDomain); ?>/about-us">About us</option>
                                    <option value="<?php echo e($baseDomain); ?>/faqs">Faqs</option>
                                    <option value="<?php echo e($baseDomain); ?>/contact-us">Contact us</option>
                                    <option value="<?php echo e($baseDomain); ?>/cart">Cart Page</option>
                                    <option value="<?php echo e($baseDomain); ?>/products">Products Page</option>
                                    <option value="<?php echo e($baseDomain); ?>/wishlist">Wishlist Page</option>
                                    <option value="<?php echo e($baseDomain); ?>/privacy_policy"> Privacy Policy</option>
                                    <option value="<?php echo e($baseDomain); ?>/terms-and-conditions">Terms And Conditions
                                    </option>
                                </select>
                            </div>
                        </li>
                        <li class="link__types hide" id="categoriesRow">
                            <div class="form-group" style="width:100%;">
                                <label for="" class="exo">Categories</label>
                                <select name="linkedProducts" id="linkedCategory" class="form-control exo"
                                    style="font-size: 14px;padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                    <option value="">Select Category</option>
                                    <?php $__currentLoopData = $exploredCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category['url']); ?>"><?php echo e($category['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </li>
                        <li class="link__types hide" id="linkedProductsRow">
                            <div class="form-group" style="width:100%;">
                                <label for="">Products</label>
                                <select name="linkedProducts" id="linkedProducts" class="form-control"
                                    style="font-size: 14px;padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                    <option value="">Select Product</option>
                                    <?php $__currentLoopData = $exploredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-trending="<?php echo e($product['is_trending']); ?>"
                                            data-best_selling="<?php echo e($product['is_best_selling']); ?>"
                                            data-new_arrivals="<?php echo e($product['is_new_arrival']); ?>"
                                            data-featured="<?php echo e($product['is_featured']); ?>"
                                            data-latest="<?php echo e($product['is_latest']); ?>" value="<?php echo e($product['url']); ?>">
                                            <?php echo e($product['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </li>
                        <li class="link__types hide" id="brandsRow">
                            <div class="form-group" style="width:100%;">
                                <label for="">Brands</label>
                                <select name="linkedProducts" id="linkedBrand" class="form-control"
                                    style="font-size: 14px;padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                    <option value="">Select Brand</option>
                                    <?php $__currentLoopData = $exploredBrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($brand['url']); ?>"><?php echo e($brand['name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </li>
                        <li class="link__types hide" id="customLinkRow">
                            <div class="form-group" style="width:100%;">
                                <label for="">Custom Link</label>
                                <input type="text" name="custom_link" id="custom_link" class="form-control"
                                    style="font-size: 14px;padding-top:10px;padding-bottom:10px;padding-left:10px;">
                            </div>
                        </li>
                        <li class="button_options px-5" style="width:100%;">
                            <div class="fixed-bottom1 px-3" style="width:100%;">
                                <button class="btn btn-md btn-primary exo" id="updateLinkBtn"
                                    style="width:100%;border-radius:100px;margin-left:5px;padding-right:5px;background-color:#6727F2;color:#fff !important;">Update</button>
                            </div>
                        </li>

                        <li style="width:100%;" id="textupdateRow" style="display:none;">
                            <div class="row" style="width:100%;">
                                <div class="col-md-12">
                                    <div class="form-group" style="width:100%;">
                                        <div
                                            style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
                                            <label for="" class="exo">Text</label>
                                            <a class="btn btn-sm btn-primary exo" href="javascript:void(0)"
                                                style="border-radius:10px;" id="generateAiContent">Generate</a>
                                        </div>

                                        <textarea name="textEditor" id="textEditor" class="form-control exo" style="width:100%;height:100px;overflow:auto;"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <button class="btn btn-sm btn-primary exo" id="updateSimpleText"
                                        style="width:100% !important;border-radius:10px;">Update Text</button>
                                </div>
                            </div>
                        </li>

                        <li>
                            <div class="form-group textColorsRow" style="width:100%;">
                                <label for="">Color</label>
                                <input type="text" name="color" id="changeTextColor" class="form-control"
                                    style="width:100%;height:42px !important;padding-left:40px !important;">
                            </div>
                        </li>
                        <li>
                            <div class="form-group textColorsRow" style="width:100%;">
                                <label for="">Background Color</label>
                                <input type="text" name="color" id="changeBackgroundColor" class="form-control"
                                    style="width:100%;height:42px !important;padding-left:40px !important;">
                            </div>
                        </li>

                        <li class="input__options" style="display: none;">
                            <div class="form-group" style="width:100%;">
                                <label for="">Placeholder Text</label>
                                <input type="text" name="color" id="placeholder_text" class="form-control"
                                    style="width:100%;height:40px;padding-left:10px;">
                            </div>
                            <div class="">
                                <button class="btn btn-md btn-primary" id="updatePlaceholderText" style="border-radius: 0px !important;margin-top:22px;">Update</button>
                            </div>
                        </li>

                        <li id="svgB">
                            <div class="form-group textColorsRow" style="width:100%;">
                                <label for="">Svg Background Color</label>
                                <input type="text" name="color" id="changesvgBackground" class="form-control"
                                    style="width:100%;height:42px !important;padding-left:40px !important;">
                            </div>
                        </li>
                        <li id="imgPreviewDiv" style="display: block;">
                            <div class="form-group textColorsRow" style="width:100%;">
                                <div class="row" style="width:100%;">
                                    <div class="col-md-12" style="width:100%;">
                                        <label for="" class="exo">Background Image</label>
                                        <div style="width:100%;">
                                            <img src="" style="width:100%;height:150px;" id="bckImgPreview">
                                        </div>
                                        <div class="form-group">
                                            <input type="file" id="changeBackgroundImage" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div style="text-align:right;width:100%;">
                                <button class="btn btn-md btn-primary exo mt-3" id="upBackImage">Upload</button>
                            </div>
                        </li>
                        <li id="timerCountdown">
                            <div class="form-group" style="width:100%;padding-right:5px !important;">
                                <label for="">Hours (<span id="hourTimeShow">00</span>) </label>
                                <div class="slider-wrapper">
                                    <input type="range" name="font_size" id="timer_hours" class="form-control"
                                        min="1" max="24" value="11">

                                </div>
                            </div>
                            <div class="form-group" style="width:100%;">
                                <label for="">Minutes  (<span id="minutesTimeShow">00</span>) </label>
                                <div class="slider-wrapper">
                                    <input type="range" name="font_size" id="timer_minutes" class="form-control"
                                        min="1" max="60" value="11">

                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row" style="width:100%;">
                                <div class="col-md-8">
                                    <div class="form-group" style="width:100%;">
                                        <label for="" class="exo">Font Size</label>
                                        <div class="slider-wrapper">
                                            <input type="range" name="font_size" id="font_size"
                                                class="form-control" min="10" max="120" value="20">

                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group" style="width:100%;">
                                        <input type="number" id="fontSizeInput" class="form-control exo"
                                            style="padding:5px;font-size:14px;">
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="form-group" style="width:100%;">
                                <label for="">Opacity <span id="currentOpacity">0.1</span></label>
                                <div class="slider-wrapper">
                                    <input type="range" name="opacityElement" id="opacityElement"
                                        class="form-control" min="0.1" max="1.0" step="0.1"
                                        value="0.1">
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row" style="width:100%;">
                                <div class="col-md-12 mb-3">
                                    <h6 style="font-weight: 700;" class="exo">Border</h6>
                                </div>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="border_type">Border Type</label>
                                        <select name="border_type" id="border_type" class="form-control exo"
                                            style="padding-top:10px;padding-bottom:10px;padding-left:5px;">
                                            <option value="none">None</option>
                                            <option value="solid">Solid</option>
                                            <option value="dotted">Dotted</option>
                                            <option value="dashed">Dashed</option>
                                            <option value="double">Double</option>
                                            <option value="groove">Groove</option>
                                            <option value="ridge">Ridge</option>
                                            <option value="inset">Inset</option>
                                            <option value="outset">Outset</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <div class="form-group">
                                        <label for="">Border Width (<span
                                                id="borderWidthShow">0px</span>)</label>
                                        <input type="range" value="0" name="left" id="borderr"
                                            min="0" max="50" class="form-control">
                                    </div>
                                </div>

                                <div class="col-md-12 mt-3" style="text-align:right;">
                                    <button class="btn btn-sm btn-primary" id="addBorder"
                                        style="border-radius:50px;">Add Border</button>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row" style="width:100%;">
                                <div class="col-md-12 mt-3">
                                    <div class="form-group textColorsRow">
                                        <label for="">Border Color</label>
                                        <input type="text" name="color" id="changeBorderColor"
                                            class="form-control"
                                            style="width:100%;height:42px !important;padding-left:40px !important;">
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <h6 style="font-weight: 700;">Border Radius</h6>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Left Top</label>
                                        <input type="range" value="10" name="left" id="top_left_border"
                                            min="0" max="200" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Left Bottom</label>
                                        <input type="range" value="10" name="left" id="bottom_left_border"
                                            min="0" max="200" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label for="">Right Top</label>
                                        <input type="range" value="10" name="left" id="top_right_border"
                                            min="0" max="200" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label for="">Right Bottom</label>
                                        <input type="range" value="10" name="left" id="bottom_right_border"
                                            min="0" max="200" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="form-group" style="width:100%;">
                                <label for="">Font Family</label>
                                <div class="slider-wrapper">
                                    <select name="font_family" id="font_family" class="form-control"
                                        style="padding-top:10px;padding-bottom:10px;padding-left:5px;">
                                        <option value="arial">Arial (sans-serif)</option>
                                        <option value="times">Times New Roman (serif)</option>
                                        <option value="courier">Courier New (monospace)</option>
                                        <option value="georgia">Georgia (serif)</option>
                                    </select>
                                </div>
                            </div>
                        </li>

                        <li>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <h6 style="font-weight: 700;" class="exo">Paddings</h6>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="" class="exo">Left (<span
                                                id="padding_left_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="left_padding"
                                            min="0" max="60" class="form-control" data-side="left">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="" class="exo">Right (<span
                                                id="padding_right_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="right_padding"
                                            min="0" max="60" class="form-control" data-side="right">
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label for="" class="exo">Top (<span
                                                id="padding_top_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="top_padding"
                                            min="0" max="60" class="form-control" data-side="top">
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label for="" class="exo">Bottom (<span
                                                id="padding_bottom_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="bottom_padding"
                                            min="0" max="60" class="form-control" data-side="bottom">
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <h6 style="font-weight: 700;">Margin</h6>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Left (<span id="margin_left_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="left_margin"
                                            min="0" max="60" class="form-control" data-side="left">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="">Right (<span id="margin_right_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="right_margin"
                                            min="0" max="60" class="form-control" data-side="right">
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label for="">Top (<span id="margin_top_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="top_margin"
                                            min="0" max="60" class="form-control" data-side="top">
                                    </div>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <div class="form-group">
                                        <label for="">Bottom (<span
                                                id="margin_bottom_show">0px</span>)</label>
                                        <input type="range" value="10" name="left" id="bottom_margin"
                                            min="0" max="60" class="form-control" data-side="bottom">
                                    </div>
                                </div>
                            </div>
                        </li>
                        <li class="text_options">
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    <h6 style="font-weight: 700;">Highlight</h6>
                                </div>
                                <div class="col-md-12">
                                    <button class="btn btn-md btn-primary" id="highlightText"
                                        style="width:100% !important;">Highlight Text</button>
                                </div>
                            </div>
                        </li>
                        <li style="width:100%" class="text_options">
                            <div class="row" style="width:100%;">
                                <div class="col text-center">
                                    <button class="btn btn-md btn-primary" id="boldText">
                                        <i class="fa fa-bold"></i>
                                    </button>
                                </div>
                                <div class="col text-center">
                                    <button class="btn btn-md btn-primary" id="italicText">
                                        <i class="fa fa-italic"></i>
                                    </button>
                                </div>
                                <div class="col text-center">
                                    <button class="btn btn-md btn-primary" id="underlineText">
                                        <i class="fa fa-underline"></i>
                                    </button>
                                </div>
                            </div>
                        </li>
                        <li style="width:100%" class="text_options">
                            <div class="row" style="width:100%;">
                                <div class="col text-center">
                                    <button class="btn btn-md btn-primary" id="leftAlign">
                                        <i class="fa fa-align-left"></i>
                                    </button>
                                </div>
                                <div class="col text-center">
                                    <button class="btn btn-md btn-primary" id="centerAlign">
                                        <i class="fa fa-align-center"></i>
                                    </button>
                                </div>
                                <div class="col text-center">
                                    <button class="btn btn-md btn-primary" id="rightAlign">
                                        <i class="fa fa-align-right"></i>
                                    </button>
                                </div>
                            </div>
                        </li>

                        <li style="width:100%;">
                            <div class="row" style="width:100%;">

                                <div class="col">
                                    <button class="btn btn-md btn-primary exo" id="htmlCode"
                                        style="width:100%;font-size:12px;">
                                        <i class="fa fa-code"></i>
                                        Code
                                    </button>
                                </div>

                                <div class="col">
                                    <button class="btn btn-md btn-primary exo" id="cloneActiveElement"
                                        style="width:100%;font-size:12px;">
                                        <i class="fa fa-clone"></i>
                                        Clone
                                    </button>
                                </div>
                            </div>
                          
                        </li>
                        <li style="width:100%;">
                            <div class="row" style="width:100%;">
                                <div class="col mt-3">
                                    <button class="btn btn-md btn-primary exo" id="openSectionSetting"
                                        style="width:100%;font-size:14px;">
                                        <i class="fa fa-cog"></i>
                                        Section Setting
                                    </button>
                                </div>
                            </div>
                        </li>
                        <li style="width:100%;">
                            <div class="row" style="width:100%;">
                                <div class="col mt-3">
                                    <button class="btn btn-md btn-danger exo" id="removeActiveElement"
                                        style="width:100%;font-size:14px;">
                                        <i class="fa fa-trash"></i>
                                        Remove
                                    </button>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="sidebar-content" id="themesContent">
                <div class="sidebar-brand">
                    <a href="#" class="theme-heading">Sections <i
                            class="fa fa-refresh ps-1"></i></a>
                    <div class="close-sidebar" id="close-sidebar-left">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu">
                    <ul>
                        <li class="page_section" data-type="global" id="showHeaders">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-heading"></i></span> Headers
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li class="page_section" data-type="home" id="showSliders">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-window-maximize"></i></span> Banners
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li class="page_section" data-type="home" id="showCategories">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link  exo">
                                    <span><i class="fa fa-list"></i></span> Categories
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>


                        <!-- 

                        <li class="page_section" data-type="home" id="showTodayDeals">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-bolt"></i></span> Today Deals
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>

                    -->
                        <li class="page_section" data-type="home" id="showTrendingSections">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-fire"></i></span> Trending Section
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <!--
                        <li class="page_section" data-type="home" id="showLatestProducts">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="bi bi-card-heading"></i></span> Latest Products
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                    -->
                        <li class="page_section" data-type="home" id="showProductShowCase">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-tv"></i></span> Product Showcase
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li class="page_section" data-type="home" id="showBrands">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-briefcase"></i></span> Brands
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li class="page_section" data-type="home" id="showWhyUs">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-question-circle"></i></span> Why us
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>

                        <li class="page_section hide" data-type="login">
                            <div class="sidebar-menu-text show-left-panel" id="showLogin">
                                <a href="#" class="nav-link exo">
                                    <span><i class="bi bi-card-heading"></i></span> Login Section
                                </a>
                            </div>
                            <div class="sidebar-menu-show">
                                <div class="badge text-bg-success">
                                    <a href="#" class="nav-arrow"><i class="fa fa-arrow-up"></i></a>
                                    <a href="#" class="nav-arrow"><i class="fa fa-arrow-down"></i></a>
                                </div>
                            </div>
                        </li>
                        <li class="page_section hide" data-type="register">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="bi bi-card-heading"></i></span> Register Section
                                </a>
                            </div>
                            <div class="sidebar-menu-show">
                                <div class="badge text-bg-success">
                                    <a href="#" class="nav-arrow"><i class="fa fa-arrow-up"></i></a>
                                    <a href="#" class="nav-arrow"><i class="fa fa-arrow-down"></i></a>
                                </div>
                            </div>
                        </li>

                        <li class="page_section" data-type="global" id="showFooter">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-columns"></i></span> Footers
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li id="showExtraSections">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-puzzle-piece"></i></span>Extra Sections
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li id="showPages">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-file-alt"></i></span>Static Pages
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-right"></i></a>
                            </div>
                        </li>
                        <li id="showInnerPages">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-file"></i></span>Inner Pages
                                </a>
                            </div>
                            <div class="badge text-bg-success">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-arrow-down"></i></a>
                            </div>
                        </li>
                        <li class="pagesSubMenu hide changeIframePage" data-page="homepage">
                            <div class="sidebar-menu-text show-left-panel px-3">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-home"></i></span>Homepage
                                </a>
                            </div>
                            <div class="badge text-bg-success" id="viewHomePageDesigns">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-eye"></i></a>
                            </div>
                        </li>
                        <li class="pagesSubMenu hide">

                            <div class="sidebar-menu-text show-left-panel px-3 changeIframePage"
                                data-page="product_detail_page">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-info-circle"></i></span>Product Detail Page
                                </a>
                            </div>
                            <div class="badge text-bg-success" id="showProductPages">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-eye"></i></a>
                            </div>
                        </li>
                        <li class="pagesSubMenu hide">

                            <div class="sidebar-menu-text show-left-panel px-3 changeIframePage"
                                data-page="product_listing_page">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-th"></i></span>Product Listing
                                </a>
                            </div>
                            <div class="badge text-bg-success" id="showProductListingPage">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-eye"></i></a>
                            </div>
                        </li>
                        <li class="pagesSubMenu hide">
                            <div class="sidebar-menu-text show-left-panel px-3 changeIframePage"
                                data-page="checkout">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-credit-card"></i></span>Checkout Page
                                </a>
                            </div>
                            <div class="badge text-bg-success" id="showCheckOutPages">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-eye"></i></a>
                            </div>
                        </li>

                        <li class="pagesSubMenu hide">
                            <div class="sidebar-menu-text show-left-panel px-3 changeIframePage"
                                data-page="register">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-user-plus"></i></span>Signup
                                </a>
                            </div>
                            <div class="badge text-bg-success" id="showRegister">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-eye"></i></a>
                            </div>
                        </li>
                        <li class="pagesSubMenu hide">
                            <div class="sidebar-menu-text show-left-panel px-3 changeIframePage" data-page="login">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-sign-in-alt"></i></span>Login
                                </a>
                            </div>
                            <div class="badge text-bg-success" id="showLogin">
                                <a href="#" class="nav-arrow" style="width:50px;"><i
                                        class="fa fa-eye"></i></a>
                            </div>
                        </li>
                        <li id="showUserDashbaords">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-tachometer-alt"></i></span> User Dashboards
                                </a>
                            </div>
                            <div class="sidebar-menu-show">
                                <div class="badge text-bg-success">
                                    <a href="#" class="nav-arrow" style="width:50px;"><i
                                            class="fa fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </li>
                        <li id="showWidgets">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-tools"></i></span> Widgets
                                </a>
                            </div>
                            <div class="sidebar-menu-show">
                                <div class="badge text-bg-success">
                                    <a href="#" class="nav-arrow" style="width:50px;"><i
                                            class="fa fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </li>
                        <li id="showSocialMedia">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-share-alt"></i></span> Social Media
                                </a>
                            </div>
                            <div class="sidebar-menu-show">
                                <div class="badge text-bg-success">
                                    <a href="#" class="nav-arrow" style="width:50px;"><i
                                            class="fa fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </li>
                        <li id="showCustomCss">
                            <div class="sidebar-menu-text show-left-panel">
                                <a href="#" class="nav-link exo">
                                    <span><i class="fa fa-paint-brush"></i></span> Custom Css And Js
                                </a>
                            </div>
                            <div class="sidebar-menu-show">
                                <div class="badge text-bg-success">
                                    <a href="#" class="nav-arrow" style="width:50px;"><i
                                            class="fa fa-arrow-right"></i></a>
                                </div>
                            </div>
                        </li>
                    </ul>



                </div>
                <!-- /*sidebar-menu -->

            </div>
            <div class="fixed-bottom1" id="bottomButtons">
                <ul class="sidebar-bottom-menu centerflex">
                    <li class="list-inline-item">
                        <a href="javascript:void(0)" class="desktop-view">
                            <i class="bi bi-pc-display-horizontal"></i>
                        </a>
                    </li>
                    <li class="list-inline-item">
                        <a href="javascript:void(0)" class="tab-view">
                            <i class="bi bi-tablet-landscape"></i>
                        </a>
                    </li>
                    <li class="list-inline-item">
                        <a href="javascript:void(0)" class="mb-view">
                            <i class="bi bi-phone"></i>
                        </a>
                    </li>
                    <li class="list-inline-item">
                        <a href="javascript:void(0)" id="saveAndViewPublic">
                            <i class="bi bi-floppy"></i>
                        </a>
                    </li>
                    <li class="list-inline-item">
                        <a href="javascript:void(0)" class="openSetting">
                            <i class="bi bi-gear"></i>
                        </a>
                    </li>
                    <li class="list-inline-item">
                        <a href="javascript:void(0)" id="saveAndViewPublically">
                            <i class="bi bi-globe-americas"></i>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <nav class="sidebar details-wrapper-left header-details">
            <div class="sidebar-content">
                <div class="sidebar-brand">
                    <div class="close-sidebar" id="close-header">
                        <i class="fa fa-times"></i>
                    </div>
                    <div class="inner-heading">
                        <h4 id="BarSectionName">Header Design</h4>
                        <span></span>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <ul id="customcssandjs" class="custom-css-list" style="border:none !important;">
                        <li style="border:none !important;">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="">Css</label>
                                        <textarea name="css" id="custom_Css" class="form-control" style="width:100%;height:250px"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-12 mt-3">
                                    <div class="form-group">
                                        <label for="">JS</label>
                                        <textarea name="css" id="custom_Css" class="form-control" style="width:100%;height:250px"></textarea>
                                    </div>
                                </div>
                                <div class="mt-3 col-md-12" style="text-align: right">
                                    <button class="btn btn-md btn-primary" id="addCustomCssAndJsBtn">Update</button>
                                </div>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- /*Left sidebar-details  -->

        <nav class="sidebar details-wrapper-left theme-details">
            <div class="sidebar-content hide appendSideMenus" data-type="home" id="todayDealsSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-bolt mr-3"
                                style="margin-right:10px;"></i>Today Deals</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="category">
                        <?php if(!empty($categoriesSlider)): ?>
                            <?php $__currentLoopData = $categoriesSlider; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card slider_card">
                                        <div class="card-body themeCard">
                                            <p class="exo">
                                                <span class="exo">
                                                    <?php echo e($category['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($category['image']); ?>" alt=""
                                                data-version="<?php echo e($category['name']); ?>"
                                                class="slider_image change_category" style="width:100%;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" data-type="home" id="categorySection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-list mr-3"
                                style="margin-right:10px;"></i>Categories</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="category">
                        <?php if(!empty($categoriesSlider)): ?>
                            <?php $__currentLoopData = $categoriesSlider; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card slider_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="exo">
                                                    <?php echo e($category['name']); ?>

                                                </span>
                                            </p>

                                            <img src="<?php echo e($category['image']); ?>" alt=""
                                                data-version="<?php echo e($category['name']); ?>"
                                                class="slider_image change_category" style="width:100%;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" data-type="home" id="sliderSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa fa-window-maximize mr-3"
                                style="margin-right:10px;"></i>Banners</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="sliders">
                        <?php if(!empty($sliders)): ?>
                            <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card slider_card" style="padding:0px !important;">
                                        <div class="card-body themeCard">
                                            <p class="exo">
                                                <span class="exo">
                                                    <?php echo e($slider['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($slider['image']); ?>" alt=""
                                                data-version="<?php echo e($slider['name']); ?>"
                                                class="slider_image change_slider" style="width:100%;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" id="themesSectionPart">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;">Themes</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4">
                        <?php if(!empty($themes)): ?>
                            <?php $__currentLoopData = $themes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 p-3">
                                    <?php

                                        $activeThemeClass = '';
                                        $activeTheme = strtolower($activeTheme);
                                        $tmm = strtolower($tm->theme);
                                        if ($tmm == $activeTheme) {
                                            $activeThemeClass = 'activeTheme';
                                        }
                                    ?>

                                    <div class="card-div changeEcommerceUserTheme <?php echo e($activeThemeClass); ?>"
                                        data-theme="<?php echo e($tm->theme); ?>">
                                        <div class="hover-card">
                                            <div class="image-container">
                                                <img src="<?php echo e($tm->screenshot); ?>" alt="Image"
                                                    class="scrolling-image" />
                                            </div>
                                            <div class="card-text">
                                                <h1>
                                                    <?php echo e($tm->theme); ?>

                                                </h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


                    </div>


                    <div class="row hide " id="themesColorSection">
                        <div class="col-md-12">
                            <div class="row px-3 mt-3">
                                <div class="col-md-4 offset-md-4">
                                    <div class="inner-heading">
                                        <h4>Theme Colors</h4>
                                        <span></span>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-5 px-3 justify-content-center text-center" id="suggestionRow">

                            </div>

                            <div class="row justify-content-center text-center mt-5" id="orText">
                                <p class="lato"
                                    style="text-align:center;font-weight:700;font-size:32px !important;">
                                    OR
                                </p>
                            </div>

                            <div class="row mt-5">
                                <div class="col-md-2 offset-md-3">
                                    <div class="form-group">
                                        <label for="" class="lato" style="float: left;">Primary
                                            Color</label>
                                        <input type="text" name="primaryColor"
                                            class="form-control form-control-popup" id="primaryColor">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="" class="lato" style="float: left;">Secondary
                                            Color</label>
                                        <input type="text" name="primaryColor"
                                            class="form-control form-control-popup" id="secondaryColor">
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <button class="btn btn-md btn-primary" id="generateThemeColor">Generate</button>
                                </div>
                            </div>
                            <div class="row mt-5 px-3 justify-content-center" id="generatedThemeColors"></div>

                        </div>
                    </div>

                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="headerSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-heading mr-3"
                                style="margin-right:10px;"></i>Headers</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="headers">
                        <?php if(!empty($headers)): ?>
                            <?php $__currentLoopData = $headers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-6">
                                    <div class="card slider_card">
                                        <div class="card-body themeCard">
                                            <p class="exo">
                                                <span class="exo">
                                                    <?php echo e($header['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($header['image']); ?>" alt=""
                                                data-version="<?php echo e($header['name']); ?>"
                                                class="slider_image change_header"
                                                style="width:100%;object-fit:contain !important;height:70px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="featuredSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-star-half-alt mr-3"
                                style="margin-right:10px;"></i>Featured Sections</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="featureds">
                        <?php if(!empty($featuredProducts)): ?>
                            <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featuredProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($featuredProduct['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($featuredProduct['image']); ?>" alt=""
                                                data-version="<?php echo e($featuredProduct['name']); ?>"
                                                class="slider_image change_featured_product"
                                                style="width:100%;object-fit:cover !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="trendingSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-fire mr-3"
                                style="margin-right:10px;"></i>Trending Sections</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="trendings">
                        <?php if(!empty($trendingSections)): ?>
                            <?php $__currentLoopData = $trendingSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trendingSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($trendingSection['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($trendingSection['image']); ?>" alt=""
                                                data-version="<?php echo e($trendingSection['name']); ?>"
                                                class="slider_image change_trending_section"
                                                style="width:100%;object-fit:cover !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="sidebar-content hide appendSideMenus" id="productShowCaseSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-desktop mr-3"
                                style="margin-right:10px;"></i>Product Showcase</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($latestProducts)): ?>
                            <?php $__currentLoopData = $latestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latestProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($latestProduct['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($latestProduct['image']); ?>" alt=""
                                                data-version="<?php echo e($latestProduct['name']); ?>"
                                                class="slider_image add_product_showcase  p-3"
                                                style="width:350px;object-fit:contain !important;height:350px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="latestProductsSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;">Latest Products</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($latestProducts)): ?>
                            <?php $__currentLoopData = $latestProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latestProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($latestProduct['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($latestProduct['image']); ?>" alt=""
                                                data-version="<?php echo e($latestProduct['name']); ?>"
                                                class="slider_image change_latest_product"
                                                style="width:100%;object-fit:cover !important;height:350px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="brandsSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-briefcase mr-3"
                                style="margin-right:10px;"></i>Brands</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($brandsSection)): ?>
                            <?php $__currentLoopData = $brandsSection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($brand['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($brand['image']); ?>" alt=""
                                                data-version="<?php echo e($brand['name']); ?>"
                                                class="slider_image change_brand"
                                                style="width:100%;object-fit:cover !important;height:150px !important">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" id="whyUsSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-question-circle mr-3"
                                style="margin-right:10px;"></i>Why us?</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($offerSection)): ?>
                            <?php $__currentLoopData = $offerSection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($offer['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($offer['image']); ?>" alt=""
                                                data-version="<?php echo e($offer['name']); ?>"
                                                class="slider_image change_offer"
                                                style="width:100%;object-fit:contain !important;height:200px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" id="footersSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-columns mr-3"
                                style="margin-right:10px;"></i>Footers</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4" id="lts">
                        <?php if(!empty($footersSection)): ?>
                            <?php $__currentLoopData = $footersSection; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($footer['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($footer['image']); ?>" alt=""
                                                data-version="<?php echo e($footer['name']); ?>"
                                                class="slider_image change_footer"
                                                style="width:100%;object-fit:cover !important;height:200px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content appendSideMenus hide" id="homePagesDesigns">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-home mr-3"
                                style="margin-right:10px;"></i>Homepages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4" id="lts">
                        <?php if(!empty($productDetailPages)): ?>
                            <?php $__currentLoopData = $productDetailPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e($page['name']); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($page['image']); ?>" alt=""
                                                data-version="<?php echo e($page['name']); ?>"
                                                class="slider_image change_product_detail_page"
                                                style="width:100%;object-fit:contain !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="homePageDesigns">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-home-alt mr-3"
                                style="margin-right:10px;"></i>Homepages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($homePageData)): ?>
                            <?php $__currentLoopData = $homePageData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span class="lato">
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $page['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($page['image_url']); ?>" alt=""
                                                data-version="<?php echo e($page['name']); ?>"
                                                class="slider_image changeHomepage"
                                                style="width:100%;object-fit:contain !important;">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="sidebar-content hide appendSideMenus" id="productListingPages">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-th mr-3"
                                style="margin-right:10px;"></i>Product Listing Pages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($productListingPages)): ?>
                            <?php $__currentLoopData = $productListingPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p class="exo">
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $page['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($page['image']); ?>" alt=""
                                                data-version="<?php echo e($page['name']); ?>"
                                                class="slider_image changeProductListingPage"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="sidebar-content hide appendSideMenus" id="productDetailPages">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-info-circle mr-3"
                                style="margin-right:10px;"></i>Product Detail Pages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($productDetailPages)): ?>
                            <?php $__currentLoopData = $productDetailPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $page['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($page['image']); ?>" alt=""
                                                data-version="<?php echo e($page['name']); ?>"
                                                class="slider_image change_product_detail_page"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="sidebar-content hide appendSideMenus" id="loginSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-sign-in-alt mr-3"
                                style="margin-right:10px;"></i>Login Section</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($loginSections)): ?>
                            <?php $__currentLoopData = $loginSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loginSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $loginSection['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($loginSection['image']); ?>" alt=""
                                                data-version="<?php echo e($loginSection['name']); ?>"
                                                class="slider_image change_login"
                                                style="width:100%;object-fit:cover !important;height:150px !important">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content appendSideMenus hide" id="checkoutSections">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-credit-card mr-3"
                                style="margin-right:10px;"></i>Checkout Pages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($checkouts)): ?>
                            <?php $__currentLoopData = $checkouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $checkout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $checkout['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($checkout['image']); ?>" alt=""
                                                data-version="<?php echo e($checkout['name']); ?>"
                                                class="slider_image change_checkout"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="userProfilePageSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;">Profile Pages Designs</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($profilePages)): ?>
                            <?php $__currentLoopData = $profilePages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $profilePage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $profilePage['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($profilePage['image']); ?>" alt=""
                                                data-version="<?php echo e($profilePage['name']); ?>"
                                                class="slider_image changeProfilePage"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="sidebar-content hide appendSideMenus" id="userOrderSections">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;">Order Page Designs</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($orderSections)): ?>
                            <?php $__currentLoopData = $orderSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $orderSection['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($orderSection['image']); ?>" alt=""
                                                data-version="<?php echo e($orderSection['name']); ?>"
                                                class="slider_image changeUserOrderPage"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" id="userDashboardSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-tachometer-alt mr-3"
                                style="margin-right:10px;"></i>Dashboard Designs</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php
                            $dashboards = [
                                [
                                    'name' => 'Dashboard 1',
                                    'slug' => 'dashboard1',
                                    'img' => url('public/ecommerce_themes/dashboard_images/dashboard_1.png'),
                                ],
                                [
                                    'name' => 'Dashboard 2',
                                    'slug' => 'dashboard2',
                                    'img' => url('public/ecommerce_themes/dashboard_images/dashboard_2.png'),
                                ],
                                [
                                    'name' => 'Dashboard 3',
                                    'slug' => 'dashboard3',
                                    'img' => url('public/ecommerce_themes/dashboard_images/dashboard_3.png'),
                                ],
                                [
                                    'name' => 'Dashboard 4',
                                    'slug' => 'dashboard4',
                                    'img' => url('public/ecommerce_themes/dashboard_images/dashboard_4.png'),
                                ],
                                [
                                    'name' => 'Dashboard 5',
                                    'slug' => 'dashboard5',
                                    'img' => url('public/ecommerce_themes/dashboard_images/dashboard_5.png'),
                                ],
                            ];
                        ?>

                        <?php $__currentLoopData = $dashboards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dashboard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $img = $dashboard['img'];
                                if (!$img) {
                                    $img =
                                        'https://media.istockphoto.com/id/1147544807/vector/thumbnail-image-vector-graphic.jpg?s=612x612&w=0&k=20&c=rnCKVbdxqkjlcs3xH87-9gocETqpspHFXu5dIGB4wuM=';
                                }
                            ?>
                            <div class="col-md-3">
                                <div class="card featured_card">
                                    <div class="card-body themeCard">
                                        <p>
                                            <span class="exo">
                                                <?php echo e($dashboard['name']); ?>

                                            </span>
                                        </p>
                                        <img src="<?php echo e($img); ?>" alt=""
                                            data-version="<?php echo e($dashboard['slug']); ?>"
                                            class="slider_image changeDashboard"
                                            style="width:100%;object-fit:cover !important;height:150px !important;">
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>

            </div>
            <div class="sidebar-content appendSideMenus hide" id="cartSections">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;">Cart Pages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($carts)): ?>
                            <?php $__currentLoopData = $carts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $cart['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($cart['image']); ?>" alt=""
                                                data-version="<?php echo e($cart['name']); ?>" class="slider_image change_cart"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="registerSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-user-plus mr-3"
                                style="margin-right:10px;"></i>Register Section</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <?php if(!empty($registerSections)): ?>
                            <?php $__currentLoopData = $registerSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registerSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card featured_card">
                                        <div class="card-body themeCard">
                                            <p>
                                                <span>
                                                    <?php echo e(ucfirst(str_replace('_', ' ', $registerSection['name']))); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($registerSection['image']); ?>" alt=""
                                                data-version="<?php echo e($registerSection['name']); ?>"
                                                class="slider_image change_register"
                                                style="width:100%;object-fit:cover !important;height:150px !important;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="pagesSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-file-alt mr-3"
                                style="margin-right:10px;"></i>Pages</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row">
                        <div class="col-md-4 p-3">
                            <div class="card-div changeIframePage" data-page="privacy">
                                <div class="hover-card">
                                    <div class="image-container">
                                        <img src="<?php echo e(asset('images/privacy.png')); ?>" alt="Image"
                                            class="scrolling-image" />
                                    </div>
                                    <div class="card-text">
                                        <h1>Privacy Policy</h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 p-3">
                            <div class="card-div changeIframePage" data-page="terms">
                                <div class="hover-card">
                                    <div class="image-container">
                                        <img src="<?php echo e(asset('images/terms.png')); ?>" alt="Image"
                                            class="scrolling-image" />
                                    </div>
                                    <div class="card-text">
                                        <h1>Terms & Conditions</h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>




                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="extraSections">

                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="extra_sections">
                        <div class="col-md-4">
                            <div class="form-group pt-3" id="bestSectionRow">
                                <label for="" class="exo"
                                    style="text-align:left;font-weight:700;float:left !important;">
                                    Best Sections
                                </label>
                                <select name="best_section" id="best_section" class="form-control exo"
                                    style="padding:10px 20px;">

                                    <option value="show_all">Show All</option>
                                    <option value="featured_products">Featured Products</option>
                                    <option value="latest_products">Latest Products</option>
                                    <option value="trending_products">Trending Products</option>
                                    <option value="product_details_page">Product Details Page</option>
                                    <option value="widgets">Widgets</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <div class="sidebar-brand" style="justify-content: unset !important;">
                                <div class="inner-heading">
                                    <h4 class="exo" style="font-weight:700;"><i class="fa fa-puzzle-piece mr-3"
                                            style="margin-right:10px;"></i>Extra Sections</h4>
                                    <span></span>
                                </div>
                                <div class="close-sidebar" id="close-theme">
                                    <i class="fa fa-times"></i>
                                </div>
                            </div>
                        </div>
                        <br>
                        <?php if(!empty($extraSections)): ?>
                            <?php $__currentLoopData = $extraSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 extra_sections" data-section="<?php echo e($extra['name']); ?>">
                                    <div class="card slider_card" style="padding:0px !important;">
                                        <div class="card-body themeCard">
                                            <p class="exo">
                                                <span class="exo">
                                                    <?php echo e(str_replace('_', ' ', $extra['name'])); ?>

                                                </span>
                                            </p>
                                            <img src="<?php echo e($extra['image']); ?>" alt=""
                                                data-version="<?php echo e($extra['name']); ?>"
                                                class="slider_image addExtraSection" style="width:100%;">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" id="widgetSection">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-tools mr-3"
                                style="margin-right:10px;"></i>Widgets</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-3" id="lts">
                        <div class="col-md-4 p-3">
                            <div class="card-div widget-card-div" data-type="home" data-page="homepage">
                                <div class="hover-card">
                                    <div class="image-container-widgets">
                                        <img
                                            src="data:image/jpeg;base64,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" />
                                    </div>
                                    <?php
                                        $whatsappStatus = 'enable';
                                        $whatsappButtonWidgetText = 'Disable whatsapp';
                                        if (!$whatsappWidget) {
                                            $whatsappStatus = 'disable';
                                            $whatsappButtonWidgetText = 'Enable Whatsapp';
                                        }
                                    ?>
                                    <div class="card-text whatsappWidget" data-status="<?php echo e($whatsappStatus); ?>">
                                        <h1>
                                            <?php echo e($whatsappButtonWidgetText); ?>

                                        </h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 p-3">
                            <div class="card-div widget-card-div" data-type="home" data-page="homepage">
                                <div class="hover-card">
                                    <div class="image-container-widgets">
                                        <img
                                            src="https://i.pinimg.com/originals/66/0b/cb/660bcb3e9408cfa1747d2d6e4c8c4526.png" />
                                    </div>
                                    <?php
                                        $facebookWidgetStatus = 'enable';
                                        $facebookWidgetButtonText = 'Disable Facebook';
                                        if (!$facebookWidget) {
                                            $facebookWidgetStatus = 'disable';
                                            $facebookWidgetButtonText = 'Enable Facebook';
                                        }
                                    ?>
                                    <div class="card-text facebookWidget"
                                        data-status="<?php echo e($facebookWidgetStatus); ?>">
                                        <h1>
                                            <?php echo e($facebookWidgetButtonText); ?>

                                        </h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4 p-3">
                            <div class="card-div widget-card-div" data-type="home" data-page="homepage">
                                <div class="hover-card">
                                    <div class="image-container-widgets">
                                        <img
                                            src="https://logos-world.net/wp-content/uploads/2021/02/Google-Analytics-Logo.png" />
                                    </div>
                                    <?php
                                        $analyticsWidgetStatus = 'enable';
                                        $analyticsWidgetButtonText = 'Disable Analytics';
                                        if (!$googleWidget) {
                                            $analyticsWidgetStatus = 'disable';
                                            $analyticsWidgetButtonText = 'Enable Facebook';
                                        }
                                    ?>
                                    <div class="card-text googleAnalytics"
                                        data-status="<?php echo e($analyticsWidgetStatus); ?>">
                                        <h1>
                                            <?php echo e($analyticsWidgetButtonText); ?>

                                        </h1>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="sidebar-content hide appendSideMenus" id="settingSection" style="overflow-x: hidden;">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo" style="font-weight:700;"><i class="fa fa-cog mr-3"
                                style="margin-right:10px;"></i>Settings</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4" id="lts">
                        <div class="col-md-10 offset-md-1">
                            <div class="alert alert-danger hide" id="updateError" style="text-align: left">
                                Error
                            </div>
                            <div class="alert alert-success hide" id="updateSuccess" style="text-align: left">
                                Success
                            </div>
                        </div>
                        <div class="col-md-5 offset-md-1">
                            <div class="form-group inputGroup">
                                <label for="" class="exo">Brand</label>
                                <input type="text" name="brandName" id="brandName"
                                    value="<?php echo e($projectDetails->brand_name); ?>"
                                    class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group inputGroup">
                                <label for="" class="exo">Slogan</label>
                                <input type="text" name="brandName" value="<?php echo e($projectDetails->slogan); ?>"
                                    id="brandSlogan" class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-10 offset-md-1">
                            <div class="form-group inputGroup">
                                <label for="" class="exo">Company Name</label>
                                <input type="text" value="<?php echo e($projectDetails->company_name); ?>"
                                    name="brandName" id="brandCompanyName" class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-5 offset-md-1">
                            <div class="form-group inputGroup">
                                <label for="" class="exo">Phone Number</label>
                                <input type="text" value="<?php echo e($projectDetails->company_phone); ?>"
                                    name="brandName" id="brandPhoneNumber" class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="form-group inputGroup">
                                <label for="" class="exo">Email</label>
                                <input type="text" name="brandName"
                                    value="<?php echo e($projectDetails->company_email); ?>" id="brandEmail"
                                    class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-10 offset-md-1">
                            <div class="form-group inputGroup">
                                <label for="" class="exo">Company Address</label>
                                <input type="text" name="brandName" value="<?php echo e($projectDetails->address); ?>"
                                    id="brandAddress" class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-3 offset-md-1">
                            <div class="form-group inputGroup mt-3">
                                <label for="" class="exo">Logo</label>
                                <input type="file" name="brandName" id="brandLogo"
                                    class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <img src="<?php echo e(Storage::url('app/public/' . $projectDetails->logo)); ?>"
                                alt="Project Logo" id="projectLogo"
                                style="width:100px;height:100px;object-fit:contain;">
                        </div>
                        <div class="col-md-3">
                            <div class="form-group inputGroup mt-3">
                                <label for="" class="exo">Favicon</label>
                                <input type="file" name="brandName" id="brandFavicon"
                                    class="form-control inputSetting exo">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <img src="<?php echo e(Storage::url('app/public/' . $projectDetails->favicon)); ?>"
                                alt="Project Logo" style="width:100px;height:100px;object-fit:contain;">
                        </div>
                        <div class="col-md-11">
                            <button class="btn btn-setting exo" id="updateProjectSetting">Update Setting</button>
                        </div>
                    </div>
                </div>

            </div>
            <div class="sidebar-content hide appendSideMenus" id="allSections">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4>All Sections</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4" id="sectionTab">

                    </div>
                </div>

            </div>

            <div class="sidebar-content hide appendSideMenus" id="socialMediaDrawer">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4 class="exo fw-bold"><i class="fa fa-share-alt mr-3"
                                style="margin-right:10px;"></i>Social Media</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4">
                        <div class="col-md-5 offset-md-1">
                            <div class="form-group" style="text-align: left">
                                <label class="exo text-dark fw-bold">
                                    <i class="fab fa-facebook"></i> Facebook Link
                                </label>
                                <input type="text" value="<?php echo e($projectDetails->facebook); ?>"
                                    name="facebook_link" id="facebook_link" class="form-control inputSetting">
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="form-group" style="text-align: left">
                                <label><i class="fab fa-twitter"></i> Twitter Link</label>
                                <input type="text" value="<?php echo e($projectDetails->twitter); ?>" name="twitter_link"
                                    id="twitter_link" class="form-control inputSetting">
                            </div>
                        </div>

                        <div class="col-md-5 offset-md-1">
                            <div class="form-group" style="text-align: left">
                                <label><i class="fab fa-linkedin"></i> LinkedIn Link</label>
                                <input type="text" value="<?php echo e($projectDetails->linkedin); ?>"
                                    name="linkedin_link" id="linkedin_link" class="form-control inputSetting">
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="form-group" style="text-align: left">
                                <label><i class="fab fa-instagram"></i> Instagram Link</label>
                                <input type="text" value="<?php echo e($projectDetails->instagram); ?>"
                                    name="instagram_link" id="instagram_link" class="form-control inputSetting">
                            </div>
                        </div>

                        <div class="col-md-5 offset-md-1">
                            <div class="form-group" style="text-align: left">
                                <label><i class="fab fa-youtube"></i> YouTube Link</label>
                                <input type="text" value="<?php echo e($projectDetails->youtube); ?>" name="youtube_link"
                                    id="youtube_link" class="form-control inputSetting">
                            </div>
                        </div>

                        <div class="col-md-5">
                            <div class="form-group" style="text-align: left">
                                <label><i class="fab fa-threads"></i> Thread Link</label> 
                                <input type="text" value="<?php echo e($projectDetails->thread); ?>" name="thread_link"
                                    id="thread_link" class="form-control inputSetting">
                            </div>
                        </div>

                        <div class="col-md-10 offset-md-1" style="text-align:right;">
                            <button class="btn btn-md btn-primary" id="updateSocialMediaLinks">Update Links</button>
                        </div>

                    </div>
                </div>
            </div>

            <div class="sidebar-content appendSideMenus hide" id="seperatorsSections">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4>Seperators</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4 px-5">
                        <?php if(!empty($seperators)): ?>
                            <?php $__currentLoopData = $seperators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seperator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-12 px-3">
                                    <img src="<?php echo e($seperator['url']); ?>" class="seperator" alt="">
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="sidebar-content hide appendSideMenus" id="customCss">
                <div class="sidebar-brand">
                    <div class="inner-heading">
                        <h4><i class="fa fa-paint-brush mr-3" style="margin-right:10px;"></i>Css And Js</h4>
                        <span></span>
                    </div>
                    <div class="close-sidebar" id="close-theme">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
                <div class="sidebar-menu text-center">
                    <div class="row g-4">
                        <div class="col-md-10 offset-md-1">
                            <div class="form-group" style="text-align: left">
                                <label for="">Css</label>
                                <textarea name="css" id="custom_css" class="form-control" style="width:100%;height:150px"> <?php echo e($customCss); ?> </textarea>
                            </div>
                        </div>
                        <div class="col-md-10 offset-md-1">
                            <div class="form-group" style="text-align: left">
                                <label for="">JS</label>
                                <textarea name="css" id="custom_js" class="form-control" style="width:100%;height:150px"> <?php echo e($customJs); ?> </textarea>
                            </div>
                        </div>
                        <div class="mt-3 col-md-10 offset-md-1" style="text-align: right">
                            <button class="btn btn-md btn-primary" id="addCustomCssAndJsBtn">Update</button>
                        </div>
                    </div>
                </div>

            </div>


        </nav>
        <!-- /*Left sidebar-details  -->

        <main class="page-content">
            <div class="container-fluid" style="text-align: center;">
                <iframe class="embed-responsive-item" id="themeIframe"
                    src="<?php echo e(url('ecommerce/iframe/' . $subscription_id . '/' . $file_name)); ?>"
                    style="max-width:100%; height: 100%;padding-top:30px !important;" allowfullscreen></iframe>
            </div>
        </main>

        <div class="sidebar-content close-section" id="sectionContent">
            <div class="sidebar-brand">
                <div class="close-sidebar" id="close-sidebar-right" style="right:270px !important;">
                    <i class="fa fa-times"></i>
                </div>
                <a href="#" class="theme-heading">Section Option <i
                        class="fa fa-refresh ps-1"></i></a>
               
            </div>
            <div class="sidebar-menu">
                <ul>
                    <li class="page_section">
                        <div class="row">
                            <div class="col">
                                <button class="btn btn-md btn-primary" id="cloneSection" style="width:100%;">Clone Section</button>
                            </div>
                        </div>
                    </li>
                    <li class="page_section">
                        <div class="row">
                            <div class="col">
                                <button class="btn btn-md btn-primary" id="moveSectionUp" style="width:100%;"><i class="fa fa-arrow-up"></i> Move up</button>
                            </div>
                            <div class="col">
                                <button class="btn btn-md btn-primary" id="moveSectionDown" style="width:100%;"> <i class="fa fa-arrow-down"></i> Move Down</button>
                            </div>
                        </div>
                    </li>
                    <li class="page_section">
                        <div class="row">
                            <div class="col">
                                <button class="btn btn-md btn-primary" id="exchangeSection" style="width:100%;">
                                    <i class="fa fa-cog"></i> Exchange
                                </button>
                            </div>
                        </div>
                    </li>
                    <li class="page_section">
                        <div class="row">
                            <div class="col">
                                <button class="btn btn-md btn-primary" id="showSectionOptions" style="width:100%;">
                                    <i class="fa fa-sync"></i> Options
                                </button>
                            </div>
                        </div>
                    </li>
                    <li class="page_section">
                        <div class="row">
                            <div class="col">
                                <button class="btn btn-md btn-danger" id="deleteSection" style="width:100%;">
                                    <i class="fa fa-trash"></i> Delete
                                </button>
                            </div>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        <!-- page-content" -->
    </div>
    <!-- page-wrapper -->


    <!-- Google Analytics Modal -->

    <div class="modal fade" id="productShowCaseModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <input type="hidden" name="designId" id="designId">
        <div class="modal-dialog modal-md" style="z-index: 9999999999999 !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Select Product Variant</h1>
                    <button style="padding:2px;margin-right:10px;" type="button" class="btn-close"
                        data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Product Type</label>
                                <select name="product_showcase_type" id="product_showcase_type"
                                    class="form-control">
                                    <option value="0">Select Options</option>
                                    <option value="categories">Categories</option>
                                    <option value="brands">Brands</option>
                                    <option value="featured">Featured Products</option>
                                    <option value="latest_products">Latest Products</option>
                                    <option value="new_arrival">New Arrivals</option>
                                    <option value="best_seller">Best Seller</option>
                                    <option value="trending">Trending Products</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group mt-3 hide" style="width:100%;" id="showcaseBrandsRow">
                            <label for="">Brands</label>
                            <select name="linkedProducts" id="showCaseBrand" class="form-control"
                                style="padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                <?php $__currentLoopData = $exploredBrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($brand['url']); ?>"><?php echo e($brand['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group mt-3 hide" style="width:100%;" id="showcaseCategoriesRow">
                            <label for="">Categories</label>
                            <select name="linkedProducts" id="showCaseCategories" class="form-control"
                                style="padding-top:10px;padding-bottom:10px;padding-left:10px;">
                                <?php $__currentLoopData = $exploredCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category['url']); ?>"><?php echo e($category['name']); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-12 mt-3">
                            <div class="form-group">
                                <label for="">No. Of Products</label>
                                <input type="number" name="showcase_products" id="showcase_products"
                                    class="form-control" value="10">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="addShowCaseProducts">Add Product</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="html_code_modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-md" style="z-index: 9999999999999 !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5 exo">Html Code</h1>
                    <button style="padding:2px;margin-right:10px;" type="button" class="btn-close"
                        data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="" class="exo">Html Code</label>
                                <textarea class="form-control exo-font" id="activeElementCode" rows="10"
                                    style="font-family: monospace; background-color: #000; color: #5dca03; padding: 10px;">
                                </textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary exo" id="updateHtmlCode">Update Code</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="analyticsWidgetModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-md" style="z-index: 9999999999999 !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Analytics Widget</h1>
                    <button style="padding:2px;margin-right:10px;" type="button" class="btn-close"
                        data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter Tracking ID</label>
                                <input type="text" name="ph_number" id="analytics_tracking_id"
                                    class="form-control" value="<?php echo e($googleWidgetId); ?>">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="enableAnalyticsWidget">Add Widget</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade theme-color" id="WhatsappInfoModal" tabindex="-1" aria-labelledby="themeModal"
        aria-hidden="true">
        <div class="modal-dialog modal-md">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="themeModalLabel">Whatsapp</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="" style="float: left;margin-bottom:5px;">Whatsapp Mobile
                                    Number</label>
                                <input type="text" name="whatsapp_mobile_number"
                                    value="<?php echo e($whatsappWidgetPhoneNumber); ?>" id="whatsappPhoneNumber"
                                    class="form-control" placeholder="+1234567890">
                            </div>
                            <div class="form-group mt-3">
                                <label for="" style="float: left;margin-bottom:5px;">Whatsapp Welcome
                                    Message</label>
                                <textarea name="wc_msg" id="whatsappWelcomeMessage" class="form-control" style="height:100px;"><?php echo e($whatsappWidgetMsg); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary widget-btn" id="enableWhatsappWidget"
                        style="background-color: #6610f2 !important;border-radius:0px;padding-left:20px;">Enable
                        Whatsapp</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="facebookPageModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-md" style="z-index: 9999999999999 !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Facebook Widget</h1>
                    <button style="padding:2px;margin-right:10px;" type="button" class="btn-close"
                        data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="">Enter Faceboook / Page Url</label>
                                <input type="text" name="ph_number" value="<?php echo e($facebookUrl); ?>"
                                    id="fb_id" class="form-control">
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-md btn-primary" id="enableFbWidget">Add Widget</button>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('modals.editor', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;



    <div class="modal fade theme-color" id="ShowtimeTheme" tabindex="-1" aria-labelledby="themeModal"
        aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="themeModalLabel">Showtime</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body text-center">
                    <img src="<?php echo e(asset('editor/images/athensbanner.jpg')); ?>" alt="" />
                    <a href="#" class="btn btn-success my-3">Update Theme</a>
                    <div class="container-fluid">
                        <div class="row g-4">
                            <div class="col-lg-4">
                                <div class="theme-color-wrap active">
                                    <a class="" href="#">
                                        <img src="<?php echo e(asset('editor/images/athensbanner.jpg')); ?>"
                                            alt="" class="theme-color-img" />
                                    </a>
                                    <h5 class="btn btn-primary my-2">Blue</h5>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="theme-color-wrap">
                                    <a class="" href="#">
                                        <img src="<?php echo e(asset('editor/images/athensbanner.jpg')); ?>"
                                            alt="" class="theme-color-img" />
                                    </a>
                                    <h5 class="btn btn-danger my-2">Red</h5>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="theme-color-wrap">
                                    <a class="" href="#">
                                        <img src="<?php echo e(asset('assets/editor/images/athensbanner.jpg')); ?>"
                                            alt="" class="theme-color-img" />
                                    </a>
                                    <h5 class="btn btn-success my-2">Green</h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End: Theme Modal -->

    <input type="file" name="uploadImage" id="uploadImage" class="hide">
    <!--Start: Scroll button to top -->
    <button type="button" id="scrollTop"><i class="fa fa-angle-up"></i></button>
    <script>
        let aiUrl = '<?= url('/') ?>' + '\/ai\/';
        let baseUrl = '<?= url('/') ?>' + '\/';
        let _token = '<?= csrf_token() ?>';
        let selectedTheme = 'test';
        let subscriptionId = "<?php echo e($subscription_id); ?>";
        var projectId = '1'
    </script>
    <script src="https://code.jquery.com/jquery-3.6.4.min.js"
        integrity="sha256-oP6HI9z1XaZNBrJURtCoUT5SUnxFr8s3BzRl+cbzUq8=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/gasparesganga-jquery-loading-overlay@2.1.7/dist/loadingoverlay.min.js">
    </script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/5.2.4/fabric.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-minicolors/2.3.6/jquery.minicolors.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="<?php echo e(asset('assets/editor/js/custom.js')); ?>"></script>
    <script>
        var uploadImageUrl = "<?php echo e(route('ecommerce.upload_image')); ?>";
        var BackgroundImageRemoveUrl = "<?php echo e(route('cgi.template.remove_background_image')); ?>";
        var getShapesUrl = "<?php echo e(route('getShapes')); ?>";
        var getBackgroundUrl = "<?php echo e(route('svgBackgrounds')); ?>";
        var exportUrl = "<?php echo e(route('cgi.template.replace_edited_image')); ?>";
        var csrf_token = "<?php echo e(csrf_token()); ?>";
        var getThemeColors = "<?php echo e(route('ecommerce.themes.getUserThemeColors')); ?>";
        var ecommerceDomain = "<?php echo e($baseDomain); ?>";
    </script>
    <script src="<?php echo e(asset('assets/editor/js/ecommerce_editor.js?v=' . time())); ?>"></script>
    <script src="<?php echo e(asset('assets/image_editor/modal.js?v=' . time())); ?>"></script>

    <script type="text/javascript">
        $("#generateSvgGradient").click(function() {


            var color1 = $("#svgColor1").val();
            var color2 = $("#svgColor2").val();

            if (!color1 || !color2) {
                return;
            }

            var gradients = [
                "linear-gradient(to right, " + color1 + ", " + color2 + ")",
                "linear-gradient(to left, " + color1 + ", " + color2 + ")",
                "linear-gradient(to top, " + color1 + ", " + color2 + ")",
                "linear-gradient(to bottom, " + color1 + ", " + color2 + ")",
                "radial-gradient(circle, " + color1 + ", " + color2 + ")",
                "radial-gradient(ellipse at center, " + color1 + ", " + color2 + ")",
                "conic-gradient(from 0deg, " + color1 + ", " + color2 + ")",
                "linear-gradient(45deg, " + color1 + ", " + color2 + ")",
                "linear-gradient(135deg, " + color1 + ", " + color2 + ")",
                "linear-gradient(225deg, " + color1 + ", " + color2 + ")",
                "linear-gradient(315deg, " + color1 + ", " + color2 + ")"
            ];

            var container = $("#svgGradientsColor");
            container.empty();


            gradients.forEach(function(gradient) {
                var div = $('<div class="gradient-circle changeSvgColorGradient" data-gradient="' +
                    gradient + '"></div>');
                div.css({
                    'width': '50px',
                    'height': '50px',
                    'border-radius': '50%',
                    'display': 'inline-block',
                    'margin': '5px',
                    'background': gradient
                });
                container.append(div);
            });
        });
    </script>
    <script>
        $(document).on('click', '.select_theme', function() {
            $(".activeTheme").removeClass('activeTheme')
            $(this).addClass('activeTheme');
            var subscriptionId = $(this).attr('data-id');
            var theme = $(this).attr('data-theme');
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            $.confirm({
                title: "Are you sure?",
                content: "Are you sure you want to change theme. Your old data will be lost",
                icon: "fa fa-exclamation-circle",
                type: "red",
                buttons: {
                    confirm: {
                        text: 'Change Theme',
                        btnClass: 'btn-red',
                        action: function() {
                            var data = {
                                theme: theme,
                                subscriptionId: subscriptionId,
                                _token: "<?php echo e(csrf_token()); ?>"
                            };
                            var url = "<?php echo e(route('ecommerce.theme.change')); ?>";
                            $.post(url, data, function(data) {
                                if (data.result) {
                                    location.reload();
                                    return;
                                }
                                btn.html(btn_html);
                                alert("Some error occured");

                            });
                        }
                    },
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-green',
                        action: function() {
                            btn.html(btn_html);
                        }
                    }
                }
            });
        });
    </script>
    <script>
        $(document).on('click', '#show-theme', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#themesSectionPart").removeClass('hide');
        });


        $(document).on('click', '#showHeaders', function() {
            var selectedId = getHtmlContent("#ecommerceHeader")
            if (selectedId) {
                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_header")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_header[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#headerSection").removeClass('hide');
        });

        function getHtmlContent(divSelector) {
            var iframe = document.getElementById("themeIframe");

            if (!iframe) {
                console.log("Iframe not found.");
                return null;
            }

            var iframeDoc = iframe.contentDocument || iframe.contentWindow.document;

            if (!iframeDoc) {
                console.log("Iframe content not accessible.");
                return null;
            }

            var targetDiv = iframeDoc.querySelector(divSelector);

            if (targetDiv) {
                var dataId = targetDiv.getAttribute("data-theme");
                if (!dataId) {
                    dataId = targetDiv.getAttribute('data-version');
                }
                return dataId || null;
            }

            console.log("Element not found inside the iframe.");
            return null;
        }

        $(document).on('click', '#showProductListingPage', function(e) {
            e.stopImmediatePropagation();
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#productListingPages").removeClass('hide');
        });

        $(document).on('click', '#showProductPages', function(e) {
            e.stopImmediatePropagation(); // Prevents conflicts with parent event
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#productDetailPages").removeClass('hide');
        });

        $(document).on('click', '#showFooter', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#footersSection").removeClass('hide');
        });

        $(document).on('click', '#showTodayDeals', function() {

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#todayDealsSection").removeClass('hide');

        });

        $(document).on('click', '#showSliders', function() {

            var selectedId = getHtmlContent("#ecommerceSlider")


            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_slider")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_slider[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#sliderSection").removeClass('hide');
        });

        $("#showCategories").on('click', function() {

            var selectedId = getHtmlContent(".categoriesSlider")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_category")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_category[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#categorySection").removeClass('hide');

        });




        $(document).on('click', '#showWhyUs', function() {

            var selectedId = getHtmlContent("#offerSection")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_offer")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_offer[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#whyUsSection").removeClass('hide');
        });

        $(document).on('click', '#showTrendingSections', function() {

            var selectedId = getHtmlContent("#trendingSection")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_trending_section")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_trending_section[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#trendingSection").removeClass('hide');

        });

        $(document).on('click', '#showBrands', function() {

            var selectedId = getHtmlContent("#brandSectionReplace")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_brand")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_brand[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#brandsSection").removeClass('hide');
        });

        $(document).on('click', "#showProductShowCase", function() {
            var selectedId = getHtmlContent("#productShowCaseSection")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_latest_product")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_latest_product[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#productShowCaseSection").removeClass('hide');
        });

        $(document).on('click', '#showLatestProducts', function() {

            var selectedId = getHtmlContent("#latestProductSection")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_latest_product")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_latest_product[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#latestProductsSection").removeClass('hide');

        });


        $(document).on('click', '#showFeaturedProducts', function() {

            var selectedId = getHtmlContent("#featuredProducts")
            if (selectedId) {

                if (selectedId == 'default') {
                    selectedId = 'v1';
                }

                $(".change_featured_product")
                    .closest('.card')
                    .removeClass('selectedSection');

                selectedId = selectedId.toUpperCase();
                $(".change_featured_product[data-version='" + selectedId + "']")
                    .closest('.card')
                    .addClass('selectedSection');
            }

            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#featuredSection").removeClass('hide');

        });

        $(document).on('click', '#showProfilePages', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#userProfilePageSection").removeClass('hide');
        })

        $(document).on('click', '#showUserDashboardPages', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#userDashboardSection").removeClass('hide');
        });

        $(document).on('click', '#showOrdersPages', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#userOrderSections").removeClass('hide');
        });

        $(document).on('click', '#showCartPages', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#cartSections").removeClass('hide');
        });

        $(document).on('click', '#showCheckOutPages', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#checkoutSections").removeClass('hide');
        });


        $(document).on('click', '#showRegister', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#registerSection").removeClass('hide');
        });

        $(document).on('click', '#showLogin', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#loginSection").removeClass('hide');
        });

        $(document).on('click', '#showExtraSections', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#extraSections").removeClass('hide');
        });

        $(document).on('click', '#showPages', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#pagesSection").removeClass('hide');

        });

        $(document).on('click', '#showUserDashbaords', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#userDashboardSection").removeClass('hide');
        });

        $(document).on('click', '#showWidgets', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#widgetSection").removeClass('hide');
        });

        function hideSections() {
            $(".appendSideMenus").parent().removeClass('mini-width');
            $(".appendSideMenus").addClass('hide');
        }

        $(document).on('click', '.openSetting', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#settingSection").removeClass('hide');
        });

        $(document).on('click', '#updateProjectSetting', function() {
            var btn = $(this);
            var btn_html = btn.html();

            $("#updateError").addClass('hide');

            var brandName = $("#brandName").val();
            var brandSlogan = $("#brandSlogan").val();
            var brandCompany = $("#brandCompanyName").val();
            var brandPhone = $("#brandPhoneNumber").val();
            var brandEmail = $("#brandEmail").val();
            var brandAddress = $("#brandAddress").val();
            var logoFile = $("#brandLogo")[0].files[0];
            var faviconFile = $("#brandFavicon")[0].files[0];

            if (!brandName) {
                showSettingError("Please enter brand name");
                return;
            }
            if (!brandSlogan) {
                showSettingError("Please enter brand slogan");
                return;
            }
            if (!brandCompany) {
                showSettingError("Please enter brand company");
                return;
            }
            if (!brandPhone) {
                showSettingError("Please enter brand phone number");
                return;
            }
            if (!brandEmail) {
                showSettingError("Please enter brand email");
                return;
            }
            if (!brandAddress) {
                showSettingError("Please enter brand address");
                return;
            }


            btn.html("<i class='fa fa-spinner fa-spin'></i>");

            var formData = new FormData();
            formData.append('brand_name', brandName);
            formData.append('slogan', brandSlogan);
            formData.append('company_name', brandCompany);
            formData.append('phone', brandPhone);
            formData.append('email', brandEmail);
            formData.append('company_address', brandAddress);
            formData.append('_token', csrf_token);
            let subscriptionId = "<?php echo e($subscription_id); ?>";
            formData.append('subscription_id', subscriptionId);
            if (logoFile) {
                formData.append('logo', logoFile); // Append logo file
            }
            if (faviconFile) {
                formData.append('favicon', faviconFile); // Append favicon file
            }

            var url = "<?php echo e(route('ai.ecommerce.update_project_details')); ?>";
            $.ajax({
                url: url, // Replace with your URL
                method: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    btn.html(btn_html); // Reset button content
                    if (response.result) {
                        hideSections();
                        $(".page-wrapper").removeClass("toggled-theme");
                        $(".page-wrapper").removeClass("toggled-header");
                        $(".page-wrapper").removeClass("toggled-banner");

                        var iframe = $("#themeIframe").get(0);
                        if (iframe) {
                            iframe.contentWindow.postMessage({
                                action: "update_project_information"
                            }, "*");
                        }
                    } else {
                        showSettingError(response.message);
                    }
                },
                error: function() {
                    btn.html(btn_html); // Reset button content
                    showSettingError("An error occurred while updating settings.");
                }
            });
        });


        function showSettingError(msg) {
            $("#updateError").removeClass('hide');
            $("#updateError").html(msg);
            setTimeout(() => {
                $("#updateError").addClass('hide');
            }, 3000);
        }

        $(document).on('click', '.facebookWidget', function() {
            var status = $(this).attr('data-status');
            if (status == "disable") {
                $("#facebookPageModal").modal('show');

            } else {
                disableFacebook();
            }
        });

        $(document).on('click', '.whatsappWidget', function() {
            var status = $(this).attr('data-status');
            if (status == "disable") {
                $("#WhatsappInfoModal").modal('show');

            } else {
                disableWhatsapp();
            }
        });

        function disableFacebook() {
            var data = {
                _token: csrf_token,
                widget: 'facebook',
                subscriptionId: subscriptionId
            };
            var url = "<?php echo e(route('ecommerce.widgets.disable')); ?>";
            $.post(url, data, function(data) {
                if (data.result) {
                    showPopupSuccess("Facebook Widget Disabled Successfully");
                    $(".facebookWidget > h1").html("Enable Whatsapp");
                    $(".facebookWidget").attr('data-status', 'disable');
                    return;
                }

                var msg = "Some error occured";
                if (data.msg) {
                    msg = data.msg;
                }
                showPopupError(msg);
            });
        }

        function disableWhatsapp() {
            var data = {
                _token: csrf_token,
                widget: 'whatsapp',
                subscriptionId: subscriptionId
            };
            var url = "<?php echo e(route('ecommerce.widgets.disable')); ?>";
            $.post(url, data, function(data) {
                if (data.result) {
                    showPopupSuccess("Whatsapp Widget Disabled Successfully");
                    $(".whatsappWidget > h1").html("Enable Whatsapp");
                    $(".whatsappWidget").attr('data-status', 'disable');
                    return;
                }

                var msg = "Some error occured";
                if (data.msg) {
                    msg = data.msg;
                }
                showPopupError(msg);
            });

        }


        $("#enableAnalyticsWidget").on('click', function() {
            var trackingId = $("#analytics_tracking_id").val();
            if (!trackingId) {
                showPopupError("Please enter analytics tracking id");
                return;
            }

            var widgetData = {
                trackingId: trackingId
            };
            var data = {
                widgetData: widgetData,
                _token: csrf_token,
                subscriptionId: subscriptionId,
                widget: 'google_analytics'
            };
            var url = "<?php echo e(route('ecommerce.widgets.add')); ?>";
            $.post(url, data, function(data) {
                if (data.result) {
                    showPopupSuccess("Widget updated successfully");
                    enableGoogleAnalytics();
                    $("#analyticsWidgetModal").modal('hide');
                    return;
                }
                var msg = "Some error occured";
                if (data.msg) {
                    msg = data.msg;
                }

                showPopupError(msg);

            }).fail(function() {
                showPopupError("Some error occured");
            });


        });

        $("#enableWhatsappWidget").on('click', function() {
            var phoneNumber = $("#whatsappPhoneNumber").val();
            var welcomeMsg = $("#whatsappWelcomeMessage").val();
            if (!phoneNumber) {
                showPopupError("Please enter whatsapp phone number");
                return;
            }
            if (!welcomeMsg) {
                showPopupError("Please enter whatsapp welcome message");
                return;
            }
            var widgetData = {
                phone_number: phoneNumber,
                welcome_msg: welcomeMsg
            };
            var data = {
                widgetData: widgetData,
                _token: csrf_token,
                subscriptionId: subscriptionId,
                widget: 'whatsapp'
            };
            var url = "<?php echo e(route('ecommerce.widgets.add')); ?>";
            $.post(url, data, function(data) {
                if (data.result) {
                    showPopupSuccess("Widget updated successfully");
                    enableWhatsapp();
                    $("#WhatsappInfoModal").modal('hide');
                    return;
                }
                var msg = "Some error occured";
                if (data.msg) {
                    msg = data.msg;
                }

                showPopupError(msg);

            }).fail(function() {
                showPopupError("Some error occured");
            });


        });


        $("#enableFbWidget").on("click", function() {
            var fbId = $("#fb_id").val();
            if (!fbId) {
                showPopupError("Please enter facebook ID");
                return;
            }
            var messengerLink;
            if (fbId.includes('facebook.com/')) {
                const username = fbId.split("facebook.com/")[1];
                messengerLink = `https://m.me/${username}`;
            } else {
                messengerLink = fbId;
            }

            var widgetData = {
                messengerLink: messengerLink
            };
            var url = "<?php echo e(route('ecommerce.widgets.add')); ?>";
            var data = {
                _token: csrf_token,
                subscriptionId: subscriptionId,
                widget: 'facebook',
                widgetData: widgetData
            };
            $.post(url, data, function(data) {
                $(".facebookWidget > h1").html('Disable Whatsapp');
                $("#facebookPageModal").modal("hide");
                $(".facebookWidget").attr('data-status', 'enable');
            });
        });


        $(document).on('click', '#showSocialMedia', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#socialMediaDrawer").removeClass('hide');
        });

        $(document).on('click', '.openColorSetting', function() {
            hideSections();
        });



        $(document).on('click', '.showSeperators', function() {
            var position = $(this).attr('data-position');
            $(".seperator").attr('data-position', position);
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#seperatorsSections").removeClass('hide');
            $("#seperatorsSections").parent().addClass('mini-width');
        });

        $(document).on('click', '#showCustomCss', function() {
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#customCss").removeClass('hide');
        });

        $(document).on('click', '.googleAnalytics', function() {
            var status = $(this).attr('data-status');
            if (status == 'disable') {
                $("#analyticsWidgetModal").modal('show');
            } else {

                disableAnalytics();
            }
        });

        function disableAnalytics() {
            var data = {
                _token: csrf_token,
                widget: 'google_analytics',
                subscriptionId: subscriptionId
            };
            var url = "<?php echo e(route('ecommerce.widgets.disable')); ?>";
            $.post(url, data, function(data) {
                if (data.result) {
                    showPopupSuccess("Google Widget Disabled Successfully");
                    $(".googleAnalytics > h1").html("Enable Analytics");
                    $(".googleAnalytics").attr('data-status', 'disable');
                    return;
                }

                var msg = "Some error occured";
                if (data.msg) {
                    msg = data.msg;
                }
                showPopupError(msg);
            });
        }

        function showPopupSuccess(msg) {
            $.confirm({
                title: "Widget updated",
                content: msg,
                theme: 'modern',
                icon: "fa fa-check",
                type: "green",
                buttons: {}
            });
        }

        function showPopupError(msg) {
            $.confirm({
                title: "Error",
                content: msg,
                theme: 'modern',
                icon: "fa fa-exclamation-circle",
                type: "red",
                buttons: {}
            });
        }

        function enableGoogleAnalytics() {
            $(".googleAnalytics > h1").html("Disable Analytics");
            $(".googleAnalytics").attr('data-status', 'enable');
        }

        function enableWhatsapp() {
            $(".whatsappWidget > h1").html("Disable Whatsapp");
            $(".whatsappWidget").attr('data-status', 'enable');

        }
        $(document).on('click', '#addCustomCssAndJsBtn', function() {
            var css = $("#custom_css").val();
            var js = $("#custom_js").val();
            var url = "<?php echo e(route('ecommerce.addCustomCss')); ?>";
            $.post(url, {
                _token: csrf_token,
                css: css,
                js: js,
                subscriptionId: subscriptionId
            }, function(data) {
                showPopupSuccess("Css and js updated successfully");
            })
        });

        $(document).on('click', '#updateSocialMediaLinks', function() {
            var fbLink = $("#facebook_link").val();
            var twitterLink = $("#twitter_link").val();
            var linkedinLink = $("#linkedin_link").val();
            var instagramLink = $("#instagram_link").val();
            var youtubeLink = $("#youtube_link").val();
            var threadLink = $("#thread_link").val();

            var url = "<?php echo e(route('ecommerce.addSocialMediaLinks')); ?>";
            var data = {
                subscriptionId: "<?php echo e($subscription_id); ?>",
                facebook: fbLink,
                twitter: twitterLink,
                linkedin: linkedinLink,
                instagram: instagramLink,
                youtube: youtubeLink,
                thread: threadLink,
                _token: csrf_token
            };
            console.log(data)
            $.post(url, data, function(data) {
                if (data.result) {
                    hideSections();
                    $(".page-wrapper").removeClass("toggled-theme");
                    $(".page-wrapper").removeClass("toggled-header");
                    $(".page-wrapper").removeClass("toggled-banner");
                    return;
                }

                showPopupError("Some error occured")
            }).fail(function() {
                showPopupError("Some error occured");
            });

        });
    </script>

    <?php
        $primaryColor = '';
        $secondaryColor = '';
        if ($websiteColors) {
            $websiteColors = json_decode($websiteColors, true);
            if (!empty($websiteColors)) {
                $primaryColor = $websiteColors['primary'];
                $secondaryColor = $websiteColors['secondary'];
            }
        }
    ?>
    <script>
        $("#closeRightSideBar").on('click', function() {
            $(".sidebar-right").animate({
                right: "-300px" // Moves sidebar out of view
            }, 300);
        });

        $(".openColorSetting").on('click', function() {
            $(".sidebar-right").animate({
                right: "0px" // Moves sidebar back into view
            }, 300);
        });


        $(document).ready(function() {
            $("#primaryColor").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff'], // Predefined colors
                defaultValue: "<?php echo e($primaryColor); ?>",
                change: function(value, opacity) {
                    if (value) {
                        console.log("Selected color:", value);
                    }
                }
            });

            $("#changeBorderColor").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff',
                'transparent'], // Predefined colors
                defaultValue: "",
                change: function(value, opacity) {
                    if (value) {
                        var iframe = document.getElementById("themeIframe");

                        if (!iframe) {
                            console.log("Iframe not found.");
                            return;
                        }

                        iframe.contentWindow.postMessage({
                            action: "change_border_color",
                            color: value
                        }, "*");
                    }
                }
            });


            $("#changesvgBackground").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff',
                'transparent'], // Predefined colors
                defaultValue: "",
                change: function(value, opacity) {
                    if (value) {

                        var iframe = $("#themeIframe").get(0);

                        if(iframe)
                        {
                            iframe.contentWindow.postMessage({
                                action: "changeSvgBackgroundColor",
                                color: value
                            }, "*");    
                        }
                        
                    }
                }
            });


            $("#changeBackgroundColor").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff',
                'transparent'], // Predefined colors
                defaultValue: "",
                change: function(value, opacity) {
                    if (value) {
                        console.log("Selected color:", value);
                    }
                }
            });

            $("#changeTextColor").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff'], // Predefined colors
                defaultValue: "",
                change: function(value, opacity) {
                    if (value) {
                        console.log("Selected color:", value);
                    }
                }
            });


            $("#secondaryColor").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff'], // Predefined colors
                defaultValue: "<?php echo e($secondaryColor); ?>",
                change: function(value, opacity) {
                    if (value) {
                        console.log("Selected color:", value);
                    }
                }
            });

            $("#svgColor1").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff',
                'transparent'], // Predefined colors
                defaultValue: "<?php echo e($secondaryColor); ?>",
                change: function(value, opacity) {
                    if (value) {
                        console.log("Selected color:", value);
                    }
                }
            });

            $("#svgColor2").minicolors({
                control: 'wheel', // Enables color wheel
                format: 'hex', // Color format (hex, rgb, etc.)
                position: 'bottom left', // Position of color picker
                theme: 'bootstrap', // Theme style
                swatches: ['#ff0000', '#00ff00', '#0000ff', '#ffff00', '#ff00ff',
                'transparent'], // Predefined colors
                defaultValue: "<?php echo e($secondaryColor); ?>",
                change: function(value, opacity) {
                    if (value) {
                        console.log("Selected color:", value);
                    }
                }
            });


        });



        $("#generateGradient").on('click', function() {
            var color1 = $("#gradient_color1").val();
            var color2 = $("#gradient_color2").val();

            if (!color1 || !color2) {
                return;
            }


            var gradients = [
                `linear-gradient(to right, ${color1}, ${color2})`,
                `linear-gradient(to left, ${color1}, ${color2})`,
                `linear-gradient(to top, ${color1}, ${color2})`,
                `linear-gradient(to bottom, ${color1}, ${color2})`,
                `radial-gradient(circle, ${color1}, ${color2})`,
                `radial-gradient(ellipse at center, ${color1}, ${color2})`,
                `conic-gradient(from 0deg, ${color1}, ${color2})`,
                `linear-gradient(45deg, ${color1}, ${color2})`,
                `linear-gradient(135deg, ${color1}, ${color2})`,
                `linear-gradient(225deg, ${color1}, ${color2})`,
                `linear-gradient(315deg, ${color1}, ${color2})`
            ];

            var container = $("#gradientsSectionColors");
            container.empty();

            gradients.forEach(function(gradient) {
                var div = $(
                    '<div class="gradient-circle changeSectionBackground" data-gradient="' + gradient +
                    '"></div>');
                div.css({
                    'width': '50px',
                    'height': '50px',
                    'border-radius': '50%',
                    'display': 'inline-block',
                    'margin': '5px',
                    'background': gradient
                });
                container.append(div);
            });

        });


        $("#generateThemeColor").on('click', function() {
            var secondaryColor = $("#secondaryColor").val();
            var primaryColor = $("#primaryColor").val();

            var gradients = [
                `linear-gradient(to right, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(to left, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(to top, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(to bottom, ${primaryColor}, ${secondaryColor})`,
                `radial-gradient(circle, ${primaryColor}, ${secondaryColor})`,
                `radial-gradient(ellipse at center, ${primaryColor}, ${secondaryColor})`,
                `conic-gradient(from 0deg, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(45deg, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(135deg, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(225deg, ${primaryColor}, ${secondaryColor})`,
                `linear-gradient(315deg, ${primaryColor}, ${secondaryColor})`
            ];

            var container = $("#generatedThemeColors");
            container.empty(); // Clear previous results

            var halfColorDiv = $(
                '<div class="half-color-circle changeThemeColor" data-type="solid" data-secondary="' +
                secondaryColor + '" data-primary="' + primaryColor + '"></div>');
            halfColorDiv.css({
                'width': '50px',
                'height': '50px',
                'border-radius': '50%',
                'display': 'inline-block',
                'margin': '5px',
                'background': `linear-gradient(to right, ${primaryColor} 50%, ${secondaryColor} 50%)`
            });
            container.append(halfColorDiv);

            gradients.forEach(function(gradient) {
                var div = $(
                    '<div class="gradient-circle changeThemeColor" data-type="gradient" data-gradient="' +
                    gradient + '" data-primary="' + primaryColor + '" data-secondary="' +
                    secondaryColor + '"></div>');
                div.css({
                    'width': '50px',
                    'height': '50px',
                    'border-radius': '50%',
                    'display': 'inline-block',
                    'margin': '5px',
                    'background': gradient
                });
                container.append(div);
            });

        });

        $(document).on('click', '.changeThemeColor', function() {

            var activeTheme = "<?php echo e($activeTheme); ?>";
            var newActiveTheme = $(".activeTheme").attr('data-theme');
            var type = $(this).attr('data-type');
            var primary = $(this).attr('data-primary');
            var secondary = $(this).attr('data-secondary');
            var gradient = $(this).attr('data-gradient');
            if (activeTheme == newActiveTheme) {

                changeThemeColor(primary, secondary, type, gradient);
            } else {
                changeNewThemeAndColor(newActiveTheme, primary, secondary, type);
            }


        });

        function changeNewThemeAndColor(newTheme, primary, secondary, type) {
            var colors = [];

            if (type == 'solid') {
                colors = {
                    primary: primary,
                    secondary: secondary,
                    type: 'solid'
                };
            }

            if (type == 'gradient') {
                colors = {
                    primary: primary,
                    secondary: secondary,
                    type: 'gradient',
                    gradient: gradient
                };

            }
            var subscription_id = "<?php echo e($subscription_id); ?>";

            $.confirm({
                title: "Are you sure?",
                content: "Are you sure you want to change theme. Your old data will be lost",
                icon: "fa fa-exclamation-circle",
                type: "red",
                theme: 'modern',
                buttons: {
                    confirm: {
                        text: 'Change Theme',
                        btnClass: 'btn-red',
                        action: function() {
                            var data = {
                                theme: newTheme,
                                colors: colors,
                                subscriptionId: subscriptionId,
                                _token: "<?php echo e(csrf_token()); ?>"
                            };
                            var url = "<?php echo e(route('ecommerce.themes.changeNewThemeAndcolor')); ?>";
                            $.post(url, data, function(data) {
                                if (data.result) {
                                    location.reload();
                                    return;
                                }
                                btn.html(btn_html);
                                alert("Some error occured");

                            });
                        }
                    },
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-green',
                        action: function() {}
                    }
                }
            });

        }


        function changeThemeColor(primary, secondary, type, gradient) {
            var colors = [];
            var type = type;
            var primary = primary;
            var secondary = secondary;

            if (type == 'solid') {
                colors = {
                    primary: primary,
                    secondary: secondary,
                    type: 'solid'
                };
            }

            if (type == 'gradient') {
                colors = {
                    primary: primary,
                    secondary: secondary,
                    type: 'gradient',
                    gradient: gradient
                };

            }
            var subscription_id = "<?php echo e($subscription_id); ?>";
            var changeWebsiteColors = {
                _token: "<?php echo e(csrf_token()); ?>",
                colors: colors,
                subscription_id: subscription_id
            };
            var url = "<?php echo e(route('ecommerce.changeWebsiteColors')); ?>";

            $.confirm({
                title: "Are you sure?",
                content: "Are you sure you want to change theme colors?",
                icon: "fa fa-exclamation-circle",
                theme: 'modern',
                type: "red",
                buttons: {
                    confirm: {
                        text: 'Change Colors',
                        btnClass: 'btn-red',
                        action: function() {
                            $.post(url, changeWebsiteColors, function(data) {
                                location.reload();
                            });
                        }
                    },
                    cancel: {
                        text: 'Cancel',
                        btnClass: 'btn-green',
                        action: function() {}
                    }
                }
            });
        }

        $(document).on('click', '#close-sidebar-left-section-options', function() {
            $("#sectionOptions").addClass('hide')
            $("#themesContent").removeClass('hide');
        });

        $(document).on('click', '#close-sidebar-left-options', function() {
            $("#optionContent").addClass('hide')
            $("#themesContent").removeClass('hide');
        });
    </script>
    <script>
        $(document).on('click', '#showInnerPages', function() {
            $(".pagesSubMenu").toggleClass('hide');
        });
        $("#viewHomePageDesigns").on('click', function(e) {
            e.stopPropagation();
            hideSections();
            $(".page-wrapper").addClass("toggled-theme");
            $(".page-wrapper").removeClass("toggled-header");
            $(".page-wrapper").removeClass("toggled-banner");
            $("#homePageDesigns").removeClass('hide');
        })
    </script>
    <script>
        $(document).on('click', '.add_product_showcase', function() {
            $("#close-theme").click();
            var theme = $(this).attr('data-version');
            $("#designId").val(theme);
            $("#productShowCaseModal").modal('show');
        });
    </script>
    <script>
        $(document).ready(function() {

            $("#linkedProducts").select2();

            $("#svgBackgroundColor").minicolors({
                control: 'wheel', // Control type
                format: 'hex', // Color format
                inline: false, // Show inline
                theme: 'bootstrap',
                change: function(value, opacity) {
                    if (value) {
                        var iframe = $("#themeIframe").get(0);
                        if (iframe) {
                            iframe.contentWindow.postMessage({
                                action: "change_svg_color",
                                color: value
                            }, "*");
                        }
                    }
                }
            });

            $('#section_background').minicolors({
                control: 'wheel', // Control type
                format: 'hex', // Color format
                inline: false, // Show inline
                theme: 'bootstrap',
                change: function(value, opacity) {
                    if (value) {
                        var iframe = $("#themeIframe").get(0);
                        if (iframe) {
                            iframe.contentWindow.postMessage({
                                action: "change_section_background",
                                color: value
                            }, "*");
                        }
                    }
                }
            });
            $('#gradient_color1').minicolors({
                control: 'wheel', // Control type
                format: 'hex', // Color format
                inline: false, // Show inline
                theme: 'bootstrap',
                change: function(value, opacity) {
                    if (value) {

                    }
                }
            });
            $('#gradient_color2').minicolors({
                control: 'wheel', // Control type
                format: 'hex', // Color format
                inline: false, // Show inline
                theme: 'bootstrap',
                change: function(value, opacity) {
                    if (value) {

                    }
                }
            });
        });
    </script>

    <script>
        $("#brandLogo").change(function(event) {
            let reader = new FileReader();
            reader.onload = function() {
                $("#projectLogo").attr("src", reader.result).show();
            };
            reader.readAsDataURL(event.target.files[0]);
        });

        $("#best_section").select2();

        $("#best_section").on('change', function() {
            var section = $(this).val();
            if (section == "show_all") {

                $(".extra_sections").show();
                return;
            }
            var url = "<?php echo e(route('ecommerce.getBestSections')); ?>";
            $.get(url, {
                _token: "<?php echo e(csrf_token()); ?>",
                section: section
            }, function(data) {
                if (data.result) {

                    $(".extra_sections").hide();

                    var availableSections = [];
                    var sections = data.sections;
                    sections.forEach(section => {
                        var sect = section.section.toLowerCase();
                        availableSections.push(sect);
                    });

                    $(".extra_sections").each(function() {
                        var sec = $(this).attr('data-section');
                        sec = sec.toLowerCase();
                        if (availableSections.includes(sec)) {
                            $(this).show();
                        } else {
                            $(this).hide();
                        }
                    })

                    console.log(availableSections);
                } else {
                    $(".extra_sections").hide();
                }
            })
        })
    </script>
    <script>
        $("#borderr").on('change', function() {
            var value = $(this).val();
            $("#borderWidthShow").html(value + "px");
        });
    </script>
    <script>
        $("#addBorder").on('click', function() {
            var borderType = $("#border_type").val();
            var borderWidth = $("#borderr").val();
            var iframe = document.getElementById("themeIframe");

            if (!iframe) {
                console.log("Iframe not found.");
                return;
            }

            iframe.contentWindow.postMessage({
                action: "add_border",
                border: borderWidth + "px " + borderType + " #fff"
            }, "*");
        });

        $(document).on('click', '.sidebar', function(){
            var iframe = document.getElementById("themeIframe");

            if (!iframe) {
                console.log("Iframe not found.");
                return;
            }

            iframe.contentWindow.postMessage({
                action: "hide_section_bar",
            }, "*");
        });

        $("#close-sidebar-right").on('click', function(){
            $("#sectionContent").addClass('close-section');
        });

        $("#openSectionSetting").on('click', function(){
            $("#sectionContent").removeClass('close-section');
        });

    </script>

</body>

</html>
<?php /**PATH D:\aflisocial\resources\views/ecommerce/editor.blade.php ENDPATH**/ ?>