<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0 auto;
            width: 80%;
        }
        .invoice-header {
            text-align: center;
            margin-bottom: 20px;
        }
        .invoice-header h1 {
            margin: 0;
        }
        .invoice-details, .items {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        .items th, .items td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .items th {
            background-color: #f4f4f4;
        }
        .total {
            text-align: right;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="invoice-header">
        <h1>Invoice</h1>
        <p>Invoice #: <?php echo e($invoice_id); ?></p>
        <p>Date: <?php echo e(date('d F Y H:i')); ?></p>
    </div>

    <div>
        <h3>Bill To:</h3>
        <p><?php echo e($customer_name); ?></p>
        <p><?php echo e($customer_email); ?></p>
    </div>

    
    <?php
        $totalPrice = 0;
        $totalPrice += $price;
    ?>

    <table class="items">
        <thead>
            <tr>
                <th>Item</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
          <tr>
            <td><?php echo e($subscription_name); ?></td>
            <td>1</td>
            <td>$<?php echo e($price); ?></td>
            <td>$<?php echo e($price); ?></td>
          </tr>
          <?php if(isset($domain)): ?>

          <?php
            if($domain_price)
            {
                    $totalPrice += (float)$domain_price;
            }
          ?>
              <tr>
                    <td>Domain <br> <?php echo e($domain); ?></td>
                    <td>1</td>
                    <td>$<?php echo e($domain_price); ?></td>
                    <td>$<?php echo e($domain_price); ?></td>
              </tr>
          <?php endif; ?>
        </tbody>
    </table>


    <p class="total">Grand Total: $<?php echo e($totalPrice); ?></p>
</body>
</html>
<?php /**PATH D:\aflisocial\resources\views/invoices/ai_subscription.blade.php ENDPATH**/ ?>