

<?php $__env->startSection('css'); ?>
<style>
    .table-responsive { height: auto !important; min-height: 0 !important; }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="betweenflex mt-3">
        <h4 class="text-white">Short Links (<?php echo e(($links->count() ?? 0) + (is_countable($external_links ?? []) ? count($external_links) : 0)); ?>)</h4>
        <a href="<?php echo e(url('crm/projects/short-links/create')); ?>" class="btn btn-dark transparent-btn fs-6">Add</a>
    </div>

    <div class="nestcart-table table-responsive mt-3">
        <table class="table">
            <thead>
                <tr>
                    <td class="rounded-top-left fw-semibold">Short Link</td>
                    <td class="fw-semibold" align="center">Original</td>
                    <td class="fw-semibold" align="center">Clicks</td>
                    <td class="fw-semibold" align="center">QR</td>
                    <td class="fw-semibold" align="center">Status</td>
                    <td class="fw-semibold" align="center">Password?</td>
                    <td class="fw-semibold" align="right">Created</td>
                    <td class="fw-semibold" align="right">Actions</td>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $clicks = \ShortLink\Models\UrlVisit::where('short_link_id', $link->id)->count();
                    $isExpired = !empty($link->expires_at) && now()->greaterThan($link->expires_at);
                    $isPaused = !empty($link->is_paused);
                    $status = $isPaused ? 'Paused' : ($isExpired ? 'Expired' : 'Active');
                    $canShowQr = \Illuminate\Support\Facades\Schema::hasColumn('short_links','generate_qr') ? (bool)($link->generate_qr ?? true) : true;
                    if ($canShowQr) {
                        $qrUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=80x80&data=' . urlencode($link->short_link);
                        $qrLargeUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=480x480&data=' . urlencode($link->short_link);
                    }
                ?>
                <tr id="link-<?php echo e($link->id); ?>">
                    <td class="text-start">
                        <a href="<?php echo e($link->short_link); ?>" target="_blank"><?php echo e($link->short_link); ?></a>
                    </td>
                    <td align="center">
                        <a href="<?php echo e($link->long_link); ?>" target="_blank" class="text-white-75"><?php echo e(Str::limit($link->long_link, 42)); ?></a>
                    </td>
                    <td align="center"><?php echo e($clicks); ?></td>
                    <td align="center">
                        <?php if(!empty($canShowQr)): ?>
                            <img src="<?php echo e($qrUrl); ?>" alt="QR" class="qr-thumb" style="cursor: pointer;" data-qr="<?php echo e($qrLargeUrl); ?>">
                        <?php endif; ?>
                    </td>
                    <td align="center">
                        <?php if($status==='Active'): ?>
                            <span class="badge bg-success status-toggle" data-id="<?php echo e($link->id); ?>" data-mode="pause" style="cursor: pointer;">Active</span>
                        <?php elseif($status==='Paused'): ?>
                            <span class="badge bg-warning text-dark status-toggle" data-id="<?php echo e($link->id); ?>" data-mode="resume" style="cursor: pointer;">Paused</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Expired</span>
                        <?php endif; ?>
                    </td>
                    <td align="center"><?php echo e(!empty($link->password) ? 'Yes' : 'No'); ?></td>
                    <td align="right"><?php echo e($link->created_at ? $link->created_at->format('Y-m-d H:i') : ''); ?></td>
                    <td align="right">
                        <button class="btn btn-primary btn-sm copy-btn" data-link="<?php echo e($link->short_link); ?>"><i class="fas fa-copy"></i></button>
                        <a href="<?php echo e(url('crm/projects/short-links/'.$link->id.'/edit')); ?>" class="btn btn-sm btn-secondary">Edit</a>
                        <?php if($isPaused): ?>
                            <button class="btn btn-sm btn-success pause_resume" data-id="<?php echo e($link->id); ?>" data-mode="resume">Resume</button>
                        <?php else: ?>
                            <button class="btn btn-sm btn-warning pause_resume" data-id="<?php echo e($link->id); ?>" data-mode="pause">Pause</button>
                        <?php endif; ?>
                        <button class="btn btn-sm btn-danger delete_link" data-id="<?php echo e($link->id); ?>">Delete</button>
                        <a href="<?php echo e(url('crm/projects/short-links/stats/'.$link->id)); ?>" class="btn btn-sm btn-info">Stats</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="8" class="text-center text-white">No links found</td></tr>
                <?php endif; ?>

                <?php if(!empty($external_links)): ?>
                    <?php $__currentLoopData = $external_links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr id="api_link-<?php echo e($link['id']); ?>">
                        <td class="text-start">
                            <div> <?php echo e($link['title']); ?> </div>
                            <span class="gray-text text-uppercase text-dark fw-bold">PACKAGE</span>
                        </td>
                        <td class="text-center">
                            <p class="mb-1">
                                <span class="circle-block position-relative">
                                    <span class="circle pending"></span>
                                    <span>
                                        <a href="<?php echo e($link['short_link']); ?>" target="_blank"><?php echo e($link['short_link']); ?></a>
                                    </span>
                                </span>
                            </p>
                            <button class="btn btn-primary btn-sm copy-btn mt-1" data-link="<?php echo e($link['short_link']); ?>" style="font-size: 12px;">
                                <i class="fas fa-copy"></i> Copy Link
                            </button>
                            <button class="btn btn-sm btn-danger mt-1 delete_api_link" data-id="<?php echo e($link['id']); ?>" data-link="<?php echo e($link['short_link']); ?>">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                        <td align="center"></td>
                        <td class="text-end">
                            <span class="gray-text"><?php echo e($link['visitor']); ?> Visitors</span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if($links->hasPages()): ?>
    <div class="d-flex justify-content-between align-items-center mt-4">
        <div class="text-muted">
            Showing <?php echo e($links->firstItem()); ?> to <?php echo e($links->lastItem()); ?> of <?php echo e($links->total()); ?> entries
        </div>
        <div>
            <?php echo e($links->links('pagination::bootstrap-4')); ?>

        </div>
        <div class="d-flex align-items-center">
            <span class="me-2 text-white">Items per page:</span>
            <select class="form-select form-select-sm" style="width: auto;" onchange="window.location.href=this.value">
                <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 10])); ?>" <?php echo e(request('per_page', 10) == 10 ? 'selected' : ''); ?>>10</option>
                <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 25])); ?>" <?php echo e(request('per_page') == 25 ? 'selected' : ''); ?>>25</option>
                <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 50])); ?>" <?php echo e(request('per_page') == 50 ? 'selected' : ''); ?>>50</option>
                <option value="<?php echo e(request()->fullUrlWithQuery(['per_page' => 100])); ?>" <?php echo e(request('per_page') == 100 ? 'selected' : ''); ?>>100</option>
            </select>
        </div>
    </div>
    <?php endif; ?>
</div>
<!-- QR Preview Modal -->
<div class="modal fade" id="qrModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header border-0">
        <h5 class="modal-title text-white">QR Code</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" style="filter: invert(1) grayscale(1) brightness(2);"></button>
      </div>
      <div class="modal-body d-flex justify-content-center">
        <img id="qrModalImg" src="" alt="QR" style="max-width: 100%; height: auto;">
      </div>
    </div>
  </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    $(document).on('click', '.qr-thumb', function(){
        var large = $(this).data('qr');
        $('#qrModalImg').attr('src', large);
        var modal = new bootstrap.Modal(document.getElementById('qrModal'));
        modal.show();
    });
    // Clickable status badge toggle
    $(document).on('click', '.status-toggle', function(e){
        e.preventDefault();
        e.stopPropagation();
        var $badge = $(this);
        var id = $badge.data('id');
        var mode = $badge.data('mode'); // pause | resume
        var actionText = mode === 'pause' ? 'pause' : 'resume';
        var url = mode === 'pause'
            ? '<?php echo e(url('crm/projects/short-links')); ?>'+'/'+id+'/pause'
            : '<?php echo e(url('crm/projects/short-links')); ?>'+'/'+id+'/resume';

        var proceed = function(){
            $.post(url, { _token: '<?php echo e(csrf_token()); ?>' })
                .done(function(){
                    var $row = $('#link-'+id);
                    var $btn = $row.find('.pause_resume');
                    if (mode === 'pause') {
                        // Update badge to Paused
                        $badge.removeClass('bg-success bg-danger').addClass('bg-warning text-dark').text('Paused').data('mode','resume');
                        // Toggle button to Resume (green)
                        if ($btn.length) {
                            $btn.removeClass('btn-warning').addClass('btn-success').text('Resume').data('mode','resume');
                        } else {
                            // if button absent, nothing else
                        }
                    } else {
                        // Update badge to Active
                        $badge.removeClass('bg-warning text-dark bg-danger').addClass('bg-success').text('Active').data('mode','pause');
                        // Toggle button to Pause (yellow)
                        if ($btn.length) {
                            $btn.removeClass('btn-success').addClass('btn-warning').text('Pause').data('mode','pause');
                        }
                    }
                    if (typeof Swal !== 'undefined') {
                        Swal.fire('Done', 'Link '+actionText+'d.', 'success');
                    }
                })
                .fail(function(xhr){
                    if (typeof Swal !== 'undefined') {
                        Swal.fire('Error', 'Unable to '+actionText+' this link.', 'error');
                    } else {
                        alert('Unable to '+actionText+' this link.');
                    }
                    console.error('Status toggle failed', xhr.status, xhr.responseText);
                });
        };

        if (typeof Swal !== 'undefined'){
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to '+actionText+' this link.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, '+actionText,
                cancelButtonText: 'Cancel'
            }).then(function(res){ if (res.isConfirmed) proceed(); });
        } else {
            if (confirm('Confirm to '+actionText+' this link?')) proceed();
        }
    });
    $(document).on('click', '.copy-btn', function() {
        var btn = $(this);
        var btn_html = btn.html();
        var link = btn.data('link');
        var tempInput = $('<input>');
        $('body').append(tempInput);
        tempInput.val(link).select();
        document.execCommand('copy');
        tempInput.remove();
        btn.html("Copied");
        setTimeout(function(){ btn.html(btn_html); }, 1500);
    });

    // Pause/Resume with confirmation and live UI toggle
    $(document).on('click', '.pause_resume', function(e){
        e.preventDefault();
        e.stopPropagation();
        var $btn = $(this);
        var id = $btn.data('id');
        var mode = $btn.data('mode'); // pause | resume
        var actionText = mode === 'pause' ? 'pause' : 'resume';
        var url = mode === 'pause'
            ? '<?php echo e(url('crm/projects/short-links')); ?>/'+id+'/pause'
            : '<?php echo e(url('crm/projects/short-links')); ?>/'+id+'/resume';

        var proceed = function(){
            $.post(url, { _token: '<?php echo e(csrf_token()); ?>' })
                .done(function(){
                    var $row = $('#link-'+id);
                    var $badge = $row.find('.badge');
                    if (mode === 'pause') {
                        // Update badge to Paused
                        $badge.removeClass('bg-success bg-danger').addClass('bg-warning text-dark').text('Paused');
                        // Toggle button to Resume (green)
                        $btn.removeClass('btn-warning').addClass('btn-success').text('Resume').data('mode','resume');
                    } else {
                        // Update badge to Active
                        $badge.removeClass('bg-warning text-dark bg-danger').addClass('bg-success').text('Active');
                        // Toggle button to Pause (yellow)
                        $btn.removeClass('btn-success').addClass('btn-warning').text('Pause').data('mode','pause');
                    }
                    if (typeof Swal !== 'undefined') {
                        Swal.fire('Done', 'Link '+actionText+'d.', 'success');
                    }
                })
                .fail(function(xhr){
                    if (typeof Swal !== 'undefined') {
                        Swal.fire('Error', 'Unable to '+actionText+' this link.', 'error');
                    } else {
                        alert('Unable to '+actionText+' this link.');
                    }
                    console.error('Pause/Resume failed', xhr.status, xhr.responseText);
                });
        };

        if (typeof Swal !== 'undefined'){
            Swal.fire({
                title: 'Are you sure?',
                text: 'You are about to '+actionText+' this link.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, '+actionText,
                cancelButtonText: 'Cancel'
            }).then(function(res){ if (res.isConfirmed) proceed(); });
        } else {
            if (confirm('Confirm to '+actionText+' this link?')) proceed();
        }
    });

    $(document).on('click', '.delete_link', function(e){
        e.preventDefault();
        var linkId = $(this).data('id');
        var proceed = function(){
            var data = { id: linkId, _token: '<?php echo e(csrf_token()); ?>' };
            var url = '<?php echo e(url('crm/projects/delete-short-link')); ?>';
            $.post(url, data, function(resp){
                if(resp && resp.result){
                    $('#link-'+linkId).remove();
                }
            });
        };
        if (typeof Swal !== 'undefined'){
            Swal.fire({ title:'Are you sure?', text:"You won't be able to undo this action!", icon:'warning', showCancelButton:true, confirmButtonColor:'#3085d6', cancelButtonColor:'#d33', confirmButtonText:'Yes, delete it!' })
            .then((result)=>{ if(result.isConfirmed){ proceed(); } });
        } else {
            if(confirm('Delete this short link?')){ proceed(); }
        }
    });

    $(document).on('click', '.delete_api_link', function(){
        var id = $(this).data('id');
        var link = $(this).data('link');
        var url = '<?= url('crm/projects/delete_api_short_link') ?>';
        var data = { _token: '<?= csrf_token() ?>', link: link, id: id };
        Swal.fire({ title:'Are you sure?', text:"You won't be able to undo this action!", icon:'warning', showCancelButton:true, confirmButtonColor:'#3085d6', cancelButtonColor:'#d33', confirmButtonText:'Yes, delete it!' })
        .then((result)=>{
            if(result.isConfirmed){
                $.post(url, data, function(resp){ if(resp.result){ $('#api_link-'+id).remove(); } else { Swal.fire({title:'Error', text:resp.msg, icon:'error'}); } });
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('shortlink::app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shortlink/public_html/packages/ShortLink/src/Providers/../resources/views/short_links_page.blade.php ENDPATH**/ ?>