
<?php $__env->startSection('css'); ?>
    <style>
        #theme_card {
            min-height: 400px;
            border-radius: 10px;
            background-color: transparent;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            /* vertical center */
            justify-content: center;
            /* horizontal center */
            text-align: center;
        }

        .card-div {
            --card-width: 100%;
            --card-height: 350px;
            --card-image-height: 350px;
            --transition-duration: 2s;
            width: var(--card-width);
            box-shadow: rgba(50, 50, 93, 0.25) 0px 6px 12px -2px,
                rgba(0, 0, 0, 0.3) 0px 3px 7px -3px;
            padding: 10px;
            border-radius: 10px;
            border:1px solid #fff;
        }

        .widget-card-div {

            --card-height: 220px !important;
        }

        .card-div .hover-card {
            width: 100%;
            height: var(--card-height);
            border-radius: 12px;
            overflow: hidden;
            position: relative;
            cursor: pointer;
        }

        .card-div .image-container {
            width: 100%;
            height: 100%;
            position: relative;
            overflow: hidden;
            filter: blur(1px);
            transition: all var(--transition-duration) ease;
        }

        .card-div .image-container-widgets {
            width: 100%;
            height: 300px;
            position: relative;
            overflow: hidden;
            filter: blur(0px);
            transition: all var(--transition-duration) ease;
        }

        .card-div .hover-card:hover .image-container-widgets {
            filter: blur(0px);
        }

        .card-div .scrolling-image {
            width: 100%;
            object-fit: cover;
            transform: translateY(0);
            transition: transform var(--transition-duration) ease-out;
        }

        .card-div .hover-card:hover .scrolling-image {
            transform: translateY(calc(-100% + var(--card-height)));
        }


        .card-div .card-text {
            color: black;
            text-align: center;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .card-div .card-text h1 {
            font-size: 18px;
            text-transform: uppercase;
            background: black;
            padding: 10px 20px;
            color: white;
            border-radius: 15px;
            transition: all var(--transition-duration) ease;
            z-index: 10;
        }

        .card-div .hover-card:hover .card-text h1 {
            opacity: 0.6;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="layout has-sidebar fixed-sidebar fixed-header">

        <div id="overlay" class="overlay"></div>
        <div class="layout">
            <main class="content">
                <div>
                    <a id="btn-toggle" href="#" class="sidebar-toggler break-point-sm">
                        <i class="ri-menu-line ri-xl"></i>
                    </a>
                </div>



                <div class="nestcart-table">
                    <div class="card rounded-0 transparent-bg">
                        <div class="card-body p-lg-5">
                            <h5 class="mb-0 fw-bold">Create the following for your company :</h5>
                            <hr>
                            <form class="row g-3">
                                <div class="col-4 offset-4">
                                    <div class="card" id="theme_card"
                                        <?php if(!empty($screenshotUrl)): ?>
                                            style="background-image: url('<?php echo e($screenshotUrl); ?>'); background-size: cover; background-position: center; background-repeat: no-repeat; color: #fff;"
                                        <?php endif; ?>
                                    >
                                        <h3 class="fw-bold exo" id="themeLabelShow">Select Theme</h3>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Brand Name</label>
                                    <input type="text" class="form-control" value="<?php
                                    
                                    if (!empty($details)) {
                                        echo $details['brand_name'];
                                    }
                                    
                                    ?>" id="brand_name"
                                        placeholder="Brand Name" />
                                </div>
                                <div class="col-12">
                                    <label class="form-label betweenflex">Slogan <a href="javascript:void(0)"
                                            class="btn btn-transparent rounded-pill"
                                            id="generateSlogan">Generate</a></label>
                                    <textarea class="form-control" id="slogan" placeholder="Slogan"><?php if (!empty($details)) {
                                        echo $details['slogan'];
                                    } ?></textarea>
                                </div>
                                <div class="col-12 betweenflex">
                                    <div class="input-group custom-file-button">
                                        <label class="input-group-text">Choose Logo</label>
                                        <input type="file" id="logo" class="form-control" />
                                    </div>
                                    <a href="#" class="btn btn-transparent rounded-pill ms-3">Generate</a>
                                </div>
                                <div class="col-12">
                                    <div class="input-group custom-file-button">
                                        <label class="input-group-text">Choose Favicon</label>
                                        <input type="file" id="favicon" class="form-control" />
                                    </div>
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Company Name</label>
                                    <input type="text" id="company_name" class="form-control" value="<?php
                                    
                                    if (!empty($details)) {
                                        echo $details['company_name'];
                                    }
                                    
                                    ?>"
                                        placeholder="Company Name" />
                                </div>
                                <div class="col-12">
                                    <label class="form-label">Address</label>
                                    <textarea class="form-control" id="address" placeholder="Address"><?php
                                    
                                    if (!empty($details)) {
                                        echo $details['address'];
                                    }
                                    
                                    ?></textarea>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Business Category</label>
                                    <select class="form-control form-select" id="businessCategory">
                                        <option value="">Choose...</option>
                                        <?php $__currentLoopData = $project_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php
                                            
                                            if (!empty($details)) {
                                                if ($details['category'] == $category->slug) {
                                                    echo 'selected';
                                                }
                                            }
                                            
                                            ?> value="<?php echo e($category->slug); ?>">
                                                <?php echo e($category->category); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Services</label>
                                    <input type="text" value="<?php
                                    
                                    if (!empty($details)) {
                                        echo $details['company_services'];
                                    }
                                    
                                    ?>" class="form-control" id="service"
                                        placeholder="Services Name" />
                                </div>
                                <div class="col-12 text-end">
                                    <a href="#" class="btn btn-transparent" id="saveProject">Save</a>
                                    <a href="javascript:void(0)" id="closeForm" class="btn btn-transparent">Cancel</a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </main>
            <div class="overlay"></div>
        </div>
    </div>


    <div class="modal fade" id="themeSelectModal" tabindex="-1" role="dialog" aria-labelledby="largeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content bg-dark text-white">

                <div class="modal-header border-0">
                    <h5 class="modal-title text-white exo" id="largeModalLabel">Select Theme</h5>

                </div>

                <div class="modal-body">
                    <div class="row">
                        <?php if(!empty($themes)): ?>
                            <?php $__currentLoopData = $themes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4">
                                    <div class="card-div generate_theme" data-theme="<?php echo e($theme['theme']); ?>">
                                        <div class="hover-card">
                                            <div class="image-container"> <img
                                                    src="<?php echo e($theme['screenshot']); ?>"
                                                    alt="Image" class="scrolling-image"> </div>
                                            <div class="card-text">
                                                <h1>
                                                    <?php echo e($theme['theme']); ?>

                                                </h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <input type="hidden" name="" id="long" value="<?php echo e($details['longitude'] ?? ''); ?>">
    <input type="hidden" name="" id="lat" value="<?php echo e($details['latitude'] ?? ''); ?>">
    <input type="hidden" id="theme_id" value="<?php echo e($selected_theme ?? ''); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDlFzdbBe7bMPm9jrCo6C8340ELKtsZjEw&libraries=places">
    </script>
    <script>
        initAutocomplete();

        function initAutocomplete() {
            const input = document.getElementById('address');
            const autocomplete = new google.maps.places.Autocomplete(input);
            autocomplete.setTypes(['geocode']);
            autocomplete.addListener('place_changed', function() {
                const place = autocomplete.getPlace();
                if (place.geometry) {
                    const addressComponents = place.address_components;
                    const countryComponent = addressComponents.find(component =>
                        component.types.includes('country')
                    );
                    if (countryComponent) {
                        const countryCode = countryComponent.short_name.toLowerCase();
                    }
                    const latitude = place.geometry.location.lat();
                    const longitude = place.geometry.location.lng();
                    $("#lat").val(latitude);
                    $("#long").val(longitude);

                }
            });
        }
    </script>
    <script>
        $("#generateSlogan").on('click', function() {
            var brandName = $("#brand_name").val();
            if (!brandName) {
                $("#brand_name").addClass('red_border');
                $("#brand_name").focus();
                generalError("Please fill in all required fields to generate slogan");
                return;
            }

            var category = $("#businessCategory").val();
            if (!category || category == "") {
                $("#businessCategory").focus();
                $("#businessCategory").addClass('red_border');
                generalError("Please fill in all required fields to generate slogan");
                return;
            }

            var url = "<?php echo e(route('ai.generate.content')); ?>";
            var content = 'Generate a slogan, my brand name is ' + brandName + ' and category is ' + category +
                " and return in json";
            var data = {
                content: content,
                _token: '<?= csrf_token() ?>'
            }
            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            $.post(url, data, function(data) {
                btn.html(btn_html);
                if (!data.result) {
                    if (data.msg) {
                        generalError(data.msg)
                        return;
                    }

                    generalError("Some error occured");
                    return;
                }

                var slogan = data.slogan;
                $("#slogan").val(slogan);

            });


        });

        $(".form-control").on('input', function() {
            $(".form-control").removeClass('red_border');
        })

        $(".form-control").on('change', function() {
            $(".form-control").removeClass('red_border');
        })

        function generalError(msg) {
            $.confirm({
                title: "Error",
                content: msg,
                icon: "fa fa-times-circle",
                type: "red",
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {}
                    }
                }
            });
        }
    </script>
    <script>
        $("#closeForm").on('click', function() {
            var url = '<?php echo e(url('subscriptions')); ?>';
            location.href = url;
        })
    </script>
    <script>
        $("#saveProject").on('click', function() {
            
            var theme = $("#theme_id").val();
            if(!theme)
            {
                generalError("Please select theme");
                return;
            }

            var brandName = $("#brand_name").val();
            if (!brandName) {
                $("#brand_name").addClass('red_border');
                generalError("Please fill in all required fields");
                return;
            }
            var slogan = $("#slogan").val();
            if (!slogan) {
                $("#slogan").addClass('red_border');
                generalError("Please fill in all required fields");
                return;
            }
            var logo = $('#logo')[0].files[0];
            var favIcon = $('#favicon')[0].files[0];


            var getDetails = '<?= json_encode($details) ?>';
            var projectAlreadyExsist = true;

            if (getDetails) {
                getDetails = JSON.parse(getDetails);
                if (Object.keys(getDetails).length === 0) {
                    projectAlreadyExsist = false;
                    if (!logo) {
                        generalError("Please upload a logo");
                        $("#logo").addClass('red_border');
                        return;
                    }

                    if (!favIcon) {
                        generalError("Please upload a favicon");
                        $("#favicon").addClass('red_border');
                        return;
                    }
                }
            }

            var companyName = $("#company_name").val();
            if (!companyName) {
                generalError("Please enter company name");
                $("#company_name").addClass('red_border');
                return;
            }

            var companyAddress = $("#address").val();
            if (!companyAddress) {
                generalError("Please enter company address");
                $("#address").addClass('red_border');
                return;
            }

            var service = $("#service").val();
            if (!service) {
                generalError("Please enter service for your brand");
                $("#service").addClass('red_border');
                return;
            }
            var category = $("#businessCategory").val();
            if (!category || category == "") {
                generalError("Please select business category");
                $("#businessCategory").addClass('red_border');
                return;
            }


            var lat = $("#lat").val();
            var lon = $("#long").val();

            var form = new FormData();
            form.append('brand_name', brandName);
            form.append('slogan', slogan);
            form.append('company_name', companyName);
            form.append('company_address', companyAddress);
            form.append('logo', logo);
            form.append('favicon', favIcon);
            form.append('service', service);
            form.append('_token', '<?= csrf_token() ?>');
            form.append('subscription_id', "<?php echo e($subscription_id); ?>");
            form.append('lattitude', lat);
            form.append('longitude', lon);
            form.append('category', category);
            form.append('theme', theme);

            var btn = $(this);
            var btn_html = btn.html();
            btn.html("<i class='fa fa-spinner fa-spin'></i>");
            var url = "<?php echo e(route('ai.project.website.update_details')); ?>";
            $.ajax({
                url: url,
                type: 'POST',
                data: form,
                processData: false,
                contentType: false,
                success: function(data) {
                    btn.html(btn_html);
                    if (!data.result) {
                        generalError(data.msg);
                        return;
                    }


                    $.confirm({
                        title: "Success",
                        content: "Project Detail Updated Successfully",
                        icon: "fa fa-check-circle",
                        type: "green",
                        buttons: {
                            confirm: {
                                text: 'OK',
                                btnClass: 'btn-red',
                                action: function() {

                                    if (!projectAlreadyExsist) {
                                        var url = "<?php echo e(url('ai/website/edit/')); ?>" + "/" +
                                            data.id;
                                        location.href = url;
                                    }


                                }
                            }
                        }
                    });

                },
                error: function(xhr) {
                    btn.html(btn_html);
                    generalError("Some error occured")
                }
            });



        });
        $(document).on('click', '#theme_card', function() {
            $("#themeSelectModal").modal('show');
        });

        $(document).on('click', '.generate_theme', function(){
            var theme = $(this).attr('data-theme');
            var image = $(this).find('img').attr('src');
            $("#themeSelectModal").modal('hide');
            $("#theme_id").val(theme);
            $("#saveProject").attr('data-theme', theme);
            $('#theme_card').css({
                'background-image': 'url(' + image + ')',
                'background-size': 'cover',
                'background-position': 'center',
                'background-repeat': 'no-repeat',
                'color': '#fff' // Optional: make text white for contrast
            });
        });


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('aibuilder.app_with_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\aflisocial\resources\views/aibuilder/details.blade.php ENDPATH**/ ?>