<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<title>Login/Signup Website</title>
	
	<!-- Style css -->
	<link href="<?php echo e(asset('assets/login_assets/css/style.css')); ?>" rel="stylesheet" type="text/css" />
    <style>
        /* Back Button */
.signup{
    position: relative;
}
/* .signup .back-svg{
    position: absolute;
    top: 10px;
    left: 10px;
} */

.signup .back-svg svg{
    height: 30px;
    fill: white;
    transition: .5s all ease;
}
.signup .back-svg svg:hover{
    padding: 10px;
    border-radius: 50%;
    background-color: white;
    opacity: 0.8;
    fill: black;
}

/* ALert */
.alert {
    height: 44px;
}

.success-alert{
    margin-top: 20px;
}


.alert-container{
    position: absolute;
    padding: 20px 30px;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
    overflow: hidden;
    color: white;
    margin: 0px auto;
    z-index: 30;
    max-width: 400px;
    border: 2px solid white;
    /* background: url(https://doc-08-2c-docs.googleusercontent.com/docs/securesc/68c90smiglihng9534mvqmq1946dmis5/fo0picsp1nhiucmc0l25s29respgpr4j/1631524275000/0352236…/0352236…/1Sx0jhdpEpnNIydS4rnN4kHSJtU1EyWka?e=view&authuser=0&nonce=gcrocepgbb17m&user=0352236…&hash=tfhgbs86ka6divo3llbvp93mg4csvb38) no-repeat center / cover; */
    background-color: #0f0129;
    border-radius: 10px;
    box-shadow: 0px 0px 11px rgb(0 0 0 / 33%);
    
}

.alert{
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 30px;
}

.alert-container button{
    width: 100%;
    height: 40px;
    margin: 10px auto;
    justify-content: center;
    display: block;
    color: #fff;
    background: #6b2bde;
    font-size: 1em;
    font-weight: bold;
    margin-top: 20px;
    outline: none;
    border: none;
    border-radius: 5px;
    transition: 0.2s ease-in;
    cursor: pointer;
}

.alert-icon{
    display: flex;
    gap: 10px;
    flex-direction: column;
    align-items: center;
    
}

.alert-icon svg{
    fill: #6b2bde;
    height: 64px;
}

.alert-icon h1{
    font-size: 20px;
}

.login-signup-section {
  display: flex;
  justify-content: center;
  align-items: center;
  min-height: 100vh;
  font-family: "Jost", sans-serif;
  background: linear-gradient(to bottom, #0f0c29, #302b63, #24243e);
}
.signup-container {
    max-width: 350px;
    margin: 0px auto;
    height: 400px;
    background: red;
    overflow: hidden;
    background: url(https://doc-08-2c-docs.googleusercontent.com/docs/securesc/68c90smiglihng9534mvqmq1946dmis5/fo0picsp1nhiucmc0l25s29respgpr4j/1631524275000/0352236…/0352236…/1Sx0jhdpEpnNIydS4rnN4kHSJtU1EyWka?e=view&authuser=0&nonce=gcrocepgbb17m&user=0352236…&hash=tfhgbs86ka6divo3llbvp93mg4csvb38) no-repeat center / cover;
    border-radius: 10px;
    box-shadow: 0px 0px 11px rgb(0 0 0 / 33%);
}
.signup-container #chk {
  display: none;
}
.signup-container .signup {
    position: relative;
    width: 100%;
    height: 100%;
    display: flex
;
    align-items: center;
    justify-content: center;
}
.signup-container label {
  color: #fff;
  font-size: 2.3em;
  justify-content: center;
  display: flex;
  margin: 20px 0px;
  font-weight: bold;
  cursor: pointer;
  transition: 0.5s ease-in-out;
}
.signup-container input {
  font-size: 14px;
  width: 100%;
  height: 46px;
  background: #e0dede;
  justify-content: center;
  display: flex;
  margin: 20px auto;
  padding: 10px 20px;
  border: none;
  outline: none;
  border-radius: 5px;
  box-shadow: inset 0px 2px 4px #2f2a5f;
}
.signup-container button {
  width: 100%;
  height: 40px;
  margin: 10px auto;
  justify-content: center;
  display: block;
  color: #fff;
  background: #6b2bde;
  font-size: 1em;
  font-weight: bold;
  margin-top: 20px;
  outline: none;
  border: none;
  border-radius: 5px;
  transition: 0.2s ease-in;
  cursor: pointer;
}
.signup-container button:hover {
  background: #6d44b8;
}
.signup-container .login {
  height: 460px;
  background: #eee;
  border-radius: 60% / 10%;
  transform: translateY(-180px);
  transition: 0.8s ease-in-out;
  z-index: 2;
  position: sticky;
}
.signup-container .login label {
  color: #573b8a;
  transform: scale(0.6);
}

.signup-container #chk:checked ~ .login {
  transform: translateY(-500px);
}
.signup-container #chk:checked ~ .login label {
  transform: scale(1);
}
.signup-container #chk:checked ~ .signup label {
  transform: scale(0.6);
}
    </style>
</head>
<body>
<main>
<section class="login-signup-section">
        <div class="container">
          <!-- Alert -->
          <!-- <div class="alert-container " role="alert">
            <div class="alert">
                <div class="alert-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M12.8659 3.00017L22.3922 19.5002C22.6684 19.9785 22.5045 20.5901 22.0262 20.8662C21.8742 20.954 21.7017 21.0002 21.5262 21.0002H2.47363C1.92135 21.0002 1.47363 20.5525 1.47363 20.0002C1.47363 19.8246 1.51984 19.6522 1.60761 19.5002L11.1339 3.00017C11.41 2.52187 12.0216 2.358 12.4999 2.63414C12.6519 2.72191 12.7782 2.84815 12.8659 3.00017ZM4.20568 19.0002H19.7941L11.9999 5.50017L4.20568 19.0002ZM10.9999 16.0002H12.9999V18.0002H10.9999V16.0002ZM10.9999 9.00017H12.9999V14.0002H10.9999V9.00017Z"></path></svg>
                    <h1>Alert</h1>
                </div>
                <p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Excepturi error hic ipsa, quisquam, non delectus ipsam eligendi dolores dignissimos laborum exercitationem possimus rem.</p>
            </div>
            <button>Confirm</button>
        </div> -->

          <div class="signup-container">
            <input type="checkbox" id="chk" aria-hidden="true" />

            <div class="signup">
              <form class="mx-3" method="POST" action="<?php echo e(route('register')); ?>">
                <a class="back-svg" href="<?php echo e(route('login')); ?>">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 24 24"
                    fill="currentColor"
                  >
                    <path
                      d="M19.0001 10.0001L19.0003 19L17.0003 19L17.0002 12.0001L6.82833 12L10.7781 15.9498L9.36384 17.364L2.99988 11L9.36384 4.63605L10.7781 6.05026L6.82828 10L19.0001 10.0001Z"
                    ></path>
                  </svg>
                </a>
               
                <label for="chk" aria-hidden="true">Reset Password</label>
                <!--
                        <input type="password" name="pswd" placeholder="Password" />
                        <input type="password" name="pswd" placeholder="Confirm Password" />
                        -->

                <input type="email" name="email" id="email" placeholder="Email" />
                <p class="alert-danger alert" style="display: none" role="alert" id="alertError">Alert message</p>
                 <p class="alert-success alert success-alert" style="display: none" role="alert" id="alertSuccess">
                  Success message
                </p>
                <button type="button" id="resetPassword">Reset</button>
              </form>
            </div>

            <svg xmlns="http://www.w3.org/2000/svg" style="display: none">
              <symbol
                xmlns="http://www.w3.org/2000/svg"
                width="35"
                height="35"
                viewBox="0 0 64 64"
                id="monkey-hands"
              >
                <path
                  fill="#89664C"
                  d="M9.4,32.5L2.1,61.9H14c-1.6-7.7,4-21,4-21L9.4,32.5z"
                />
                <path
                  fill="#FFD6BB"
                  d="M15.8,24.8c0,0,4.9-4.5,9.5-3.9c2.3,0.3-7.1,7.6-7.1,7.6s9.7-8.2,11.7-5.6c1.8,2.3-8.9,9.8-8.9,9.8
				s10-8.1,9.6-4.6c-0.3,3.8-7.9,12.8-12.5,13.8C11.5,43.2,6.3,39,9.8,24.4C11.6,17,13.3,25.2,15.8,24.8"
                />
                <path
                  fill="#89664C"
                  d="M54.8,32.5l7.3,29.4H50.2c1.6-7.7-4-21-4-21L54.8,32.5z"
                />
                <path
                  fill="#FFD6BB"
                  d="M48.4,24.8c0,0-4.9-4.5-9.5-3.9c-2.3,0.3,7.1,7.6,7.1,7.6s-9.7-8.2-11.7-5.6c-1.8,2.3,8.9,9.8,8.9,9.8
				s-10-8.1-9.7-4.6c0.4,3.8,8,12.8,12.6,13.8c6.6,1.3,11.8-2.9,8.3-17.5C52.6,17,50.9,25.2,48.4,24.8"
                />
              </symbol>
              <symbol
                xmlns="http://www.w3.org/2000/svg"
                width="35"
                height="35"
                viewBox="0 0 64 64"
                id="monkey"
              >
                <ellipse cx="53.7" cy="33" rx="8.3" ry="8.2" fill="#89664c" />
                <ellipse cx="53.7" cy="33" rx="5.4" ry="5.4" fill="#ffc5d3" />
                <ellipse cx="10.2" cy="33" rx="8.2" ry="8.2" fill="#89664c" />
                <ellipse cx="10.2" cy="33" rx="5.4" ry="5.4" fill="#ffc5d3" />
                <g fill="#89664c">
                  <path
                    d="m43.4 10.8c1.1-.6 1.9-.9 1.9-.9-3.2-1.1-6-1.8-8.5-2.1 1.3-1 2.1-1.3 2.1-1.3-20.4-2.9-30.1 9-30.1 19.5h46.4c-.7-7.4-4.8-12.4-11.8-15.2"
                  />
                  <path
                    d="m55.3 27.6c0-9.7-10.4-17.6-23.3-17.6s-23.3 7.9-23.3 17.6c0 2.3.6 4.4 1.6 6.4-1 2-1.6 4.2-1.6 6.4 0 9.7 10.4 17.6 23.3 17.6s23.3-7.9 23.3-17.6c0-2.3-.6-4.4-1.6-6.4 1-2 1.6-4.2 1.6-6.4"
                  />
                </g>
                <path
                  d="m52 28.2c0-16.9-20-6.1-20-6.1s-20-10.8-20 6.1c0 4.7 2.9 9 7.5 11.7-1.3 1.7-2.1 3.6-2.1 5.7 0 6.1 6.6 11 14.7 11s14.7-4.9 14.7-11c0-2.1-.8-4-2.1-5.7 4.4-2.7 7.3-7 7.3-11.7"
                  fill="#e0ac7e"
                />
                <g fill="#3b302a">
                  <path
                    d="m35.1 38.7c0 1.1-.4 2.1-1 2.1-.6 0-1-.9-1-2.1 0-1.1.4-2.1 1-2.1.6.1 1 1 1 2.1"
                  />
                  <path
                    d="m30.9 38.7c0 1.1-.4 2.1-1 2.1-.6 0-1-.9-1-2.1 0-1.1.4-2.1 1-2.1.5.1 1 1 1 2.1"
                  />
                  <ellipse cx="40.7" cy="31.7" rx="3.5" ry="4.5" />
                  <ellipse cx="23.3" cy="31.7" rx="3.5" ry="4.5" />
                </g>
              </symbol>
            </svg>
          </div>
        </div>
        <!--/*container -->
      </section>

</main>
	<script src="https://code.jquery.com/jquery-3.6.4.min.js" type="text/javascript"></script>
	<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" type="text/javascript"></script>
	<script>
        $("#resetPassword").on('click', function(){

            var email = $("#email").val();
            if(!email)
            {
                return;   
            }
            var changePasswordRoute = "<?php echo e(route('password.email')); ?>";
            $.post(changePasswordRoute, {email:email, _token:"<?php echo e(csrf_token()); ?>"}, function(data){
                
                $("#alertError").hide()
                $("#alertSuccess").show();
                $("#alertSuccess").html("Email sent successfully");


            }).fail(function(errors){
                $("#alertError").hide()
                $("#alertSuccess").hide();
                if(errors)
                {
                    var getError = errors.responseText;
                    if(getError)
                    {
                        var jsonErrors = JSON.parse(getError);
                        if(jsonErrors)
                        {
                            var error = jsonErrors.errors;
                            if(error)
                            {
                                var getError = error[0];
                                var erorrMsg = "Some error occured";
                                if(getError)
                                {
                                    erorrMsg = getError;
                                    $("#alertError").show()
                                    $("#alertError").html(erorrMsg);      
                                }
                            }   
                        }
                    }   
                }
            })
        });
    </script>
</body>
</html>
<?php /**PATH /home/shortlink/public_html/resources/views/auth/forgot-password.blade.php ENDPATH**/ ?>