<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>AFLI - Turning your ideas into Reality</title>
	<meta name="description" content="AFLI - Turning your ideas into Reality">
	<meta name="keywords" content="agency, app, business, company, corporate, designer, freelance, fullpage, modern, office, personal, portfolio, professional, web, web agency">
	<meta name="author" content="Themexriver">
	<link rel="shortcut icon" href="assets/img/logo/f-icon.png" type="image/x-icon">
	<!-- Mobile Specific Meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/bootstrap.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/fontawesome.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/flaticon_aina.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/animate.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/global.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/swiper.min.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/magnific-popup.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/style.css')); ?>">
	<link rel="stylesheet" href="<?php echo e(asset('assets/homepage/css/extras.css')); ?>">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.css">
    
	<style>
		.whatsapp-float {
			position: fixed;
			bottom: 20px;
			right: 20px;
			z-index: 1000;
			display: flex;
			align-items: center;
			justify-content: center;
			width: 60px;
			height: 60px;
			background-color: transparent;
			border-radius: 50%;
			box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
			transition: transform 0.3s, box-shadow 0.3s;
		}

		.whatsapp-float:hover {
			transform: scale(1.1);
			box-shadow: 0 6px 12px rgba(0, 0, 0, 0.3);
		}

		.whatsapp-icon {
			width: 65px;
			height: 65px;
		}

	</style>

</head>
<body class="AFLI-home">
	<div id="preloader"></div>
	<div class="up">
		<a href="#" class="scrollup text-center"><i class="fas fa-chevron-up"></i></a>
	</div>
	<div class="cursor"></div>
<!-- Start of Header section
	============================================= -->
	<header id="hap-header" class="hap-header-section">
		<div class="container">
			<div class="hap-header-top-area">
				<div class="top-info-cta-social d-flex justify-content-between align-items-center">
					<div class="top-info-cta ul-li">
						<ul>
							<li><a href="<?php echo e(route('login')); ?>"><i class="fas fa-user"></i> Customer Sign In</a></li>
							<li><a href="https://wa.me/971582422625"><i class="fas fa-phone"></i> WhatsApp +971 58 242 2625</a></li>
						</ul>
					</div>
					<div class="top-social-area">
						<a href="https://www.instagram.com/afli.ae/"> <i class="fab fa-instagram"></i></a>
						<a href="https://www.linkedin.com/company/afliae/"> <i class="fab fa-linkedin-in"></i></a>
						<a href="https://www.facebook.com/Afli.ae"> <i class="fab fa-facebook"></i></a>
					</div>
				</div>
			</div>
			<div class="hap-header-menu-navigation d-flex align-items-center justify-content-between">
				<div class="brand-logo">
					<a href="#"><img src="<?php echo e(asset('assets/homepage/img/logo/logo1.png')); ?>" alt=""></a>
				</div>
				<nav class="main-navigation clearfix ul-li">
					<ul id="main-nav" class="nav navbar-nav clearfix">
						<li class="nav-item"><a class="nav-link active" href="#hap-banner">Home</a></li>				
						<li class="nav-item"><a class="nav-link" href="#hap-about">About</a></li>		
						<li class="nav-item"><a class="nav-link" href="#hap-service">Service</a></li>		
						<li class="nav-item"><a class="nav-link" href="#hap-pricing">Pricing</a></li>	
					</ul>
				</nav>
				
			</div>
			<div class="mobile_menu position-relative">
				<div class="mobile_menu_button open_mobile_menu">
					<i class="fal fa-bars"></i>
				</div>
				<div class="mobile_menu_wrap">
					<div class="mobile_menu_overlay open_mobile_menu"></div>
					<div class="mobile_menu_content">
						<div class="mobile_menu_close open_mobile_menu">
							<i class="fal fa-times"></i>
						</div>
						<div class="m-brand-logo">
							<a href="!#"><img src="<?php echo e(asset('assets/homepage/img/logo/logo2.png')); ?>" alt=""></a>
						</div>
						<div class="mobile-search-bar position-relative">
							<form action="#">
								<input type="text" name="search" placeholder="Keywords">
								<button><i class="fal fa-search"></i></button>
							</form>
						</div>
						<nav class="mobile-main-navigation  clearfix ul-li">
							<ul id="m-main-nav" class="nav navbar-nav clearfix">
								<li class="nav-item"><a class="nav-link active" href="#hap-banner">Home</a></li>				
								<li class="nav-item"><a class="nav-link" href="#hap-about">About</a></li>		
								<li class="nav-item"><a class="nav-link" href="#hap-service">Service</a></li>		
								<li class="nav-item"><a class="nav-link" href="#hap-pricing">Pricing</a></li>	
								<li class="nav-item"><a class="nav-link" href="<?php echo e(route('login')); ?>">Login</a></li>
								<li class="nav-item"><a class="nav-link" href="<?php echo e(route('register')); ?>">Register</a></li>
							</ul>
						</nav>
						<div class="bi-mobile-header-social text-center">
							<a href="https://www.instagram.com/afli.ae/"> <i class="fab fa-instagram"></i></a>
							<a href="https://www.linkedin.com/company/afliae/"> <i class="fab fa-linkedin-in"></i></a>
							<a href="https://www.facebook.com/Afli.ae"> <i class="fab fa-facebook"></i></a>
						</div>
					</div>
				</div>
				<!-- /Mobile-Menu -->
			</div>
		</div>
	</header>
	<!-- Sidebar sidebar Item -->
	<div class="xs-sidebar-group info-group">
		<div class="xs-overlay xs-bg-black">
			<div class="row loader-area">
				<div class="col-3 preloader-wrap">
					<div class="loader-bg"></div>
				</div>
				<div class="col-3 preloader-wrap">
					<div class="loader-bg"></div>
				</div>
				<div class="col-3 preloader-wrap">
					<div class="loader-bg"></div>
				</div>
				<div class="col-3 preloader-wrap">
					<div class="loader-bg"></div>
				</div>
			</div>
		</div>
		<div class="xs-sidebar-widget"  data-background="<?php echo e(asset('assets/homepage/img/bg/texture.png')); ?>">
			<div class="sidebar-widget-container">
				<div class="widget-heading">
					<a href="#" class="close-side-widget text-uppercase">
						<i class="fal fa-times"></i> Close
					</a>
				</div>
				<div class="sidebar-textwidget">

					<!-- Sidebar Info Content -->
					<div class="sidebar-info-contents headline pera-content">
						<div class="content-inner">
							<div class="sidebar-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/logo/logo2.png')); ?>" alt=""></a>
							</div>
							<div class="sidebar-menu ul-li-block">
								<ul>
									<li><a href="about.html"><i class="fal fa-home"></i> About Us </a></li>
									<li><a href="#hap-service"><i class="fal fa-cogs"></i> Service </a></li>
								</ul>
							</div>
							<div class="sidebar-more-menu text-uppercase d-flex ul-li">
								<span>More:</span>
								<ul>
									<li><a href="#">My Account </a></li>
									<li><a href="#">Job Apply </a></li>
									<li><a href="#">Privacy Policy </a></li>
								</ul> 
							</div>
							<div class="sidebar-social ul-li-block">
								<span>Social:</span>
								<ul>
									<li><a href="https://www.facebook.com/Afli.ae"><i class="fab fa-facebook-f"></i> Facebook</a></li>
									<li><a href="https://www.instagram.com/afli.ae/"><i class="fab fa-instagram"></i> Instagram</a></li>
								</ul>
							</div>
							<div class="sidebar-copyright text-center">
								© Copyright 2023. All Rights Reserved. 
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<!-- sidebar cart start --
	<div class="cart_sidebar">
		<div class="cart_sidebar_top">
			<h2 class="heading_title">Cart</h2>
			<button  class="cart_close_btn tx-close"></button>
		</div>
		<div class="cart_items_list">
			<div class="cart_item">
				<div class="item_image">
					<img src="assets/img/shop/s_img1.jpg" alt="image_not_found">
				</div>
				<div class="item_content headline">
					<h4 class="item_title">
						Rorem ipsum dolor sit amet.
					</h4>
					<span class="item_price">$19.00</span>
					<button  class="remove_btn"><i class="fal fa-times"></i></button>
				</div>
			</div>
			<div class="cart_item">
				<div class="item_image">
					<img src="assets/img/shop/s_img2.jpg" alt="image_not_found">
				</div>
				<div class="item_content headline">
					<h4 class="item_title">
						Rorem ipsum dolor sit amet.
					</h4>
					<span class="item_price">$22.00</span>
					<button  class="remove_btn"><i class="fal fa-times"></i></button>
				</div>
			</div>
			<div class="cart_item">
				<div class="item_image">
					<img src="assets/img/shop/s_img3.jpg" alt="image_not_found">
				</div>
				<div class="item_content headline">
					<h4 class="item_title">
						Rorem ipsum dolor sit amet.
					</h4>
					<span class="item_price">$43.00</span>
					<button  class="remove_btn"><i class="fal fa-times"></i></button>
				</div>
			</div>
			<div class="cart_item">
				<div class="item_image">
					<img src="assets/img/shop/s_img4.jpg" alt="image_not_found">
				</div>
				<div class="item_content headline">
					<h4 class="item_title">
						Rorem ipsum dolor sit amet.
					</h4>
					<span class="item_price">$14.00</span>
					<button  class="remove_btn"><i class="fal fa-times"></i></button>
				</div>
			</div>
		</div>
		<div class="cart_sidebar_bottom">
			<div class="total_price">
				<span>Sub Total:</span>
				<span>$87.00</span>
			</div>
			<div class="cart_sidebar_button">
				<a  href="#">View Cart</a>
				<a  href="#">Checkout</a>
			</div>
		</div>
	</div>
	<!-- search filed --
	<div class="search-body">
		<div class="search-form">
			<form action="#" class="search-form-area">
				<input class="search-input" type="search" placeholder="Search Here">
				<button type="submit" class="search-btn1">
					<i class="fas fa-search"></i>
				</button>	
			</form>
			<div class="outer-close text-center search-btn">
				<i class="far fa-times"></i>
			</div>
		</div>
	</div>
<!-- End of Header section
	============================================= -->
	<div data-bs-spy="scroll" data-bs-target=".main-navigation" data-bs-offset="-90"  data-bs-smooth-scroll="true">
<!-- Start of Banner section
	============================================= -->
	<section id="hap-banner" class="hap-banner-section position-relative" data-background="<?php echo e(asset('assets/homepage/img/home_5/banner/banner-bg.jpg')); ?>">
		<div class="container">
			<div class="hap-banner-content position-relative">
				<div class="hap-banner-text">
					<div class="hap-section-title dark-bg-title bins-text hap-headline pera-content">
						<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
							Create Stunning Visuals with AI-Powered CGI Tools 
						</div>
						<h2 class="text-capitalize headline-title">One Click CGI videos</h2>
						<p>Create stunning CGI VFX videos effortlessly with AI-powered, one-click solutions, perfect for businesses, designers, and creators seeking professional-grade visual content. </p>
						<div class="hap-btn text-uppercase wow fadeInRight"  data-wow-delay="500ms" data-wow-duration="1000ms">
							<a href="<?php echo e(route('cgi.templates')); ?>">TRY NOW <i class="far fa-arrow-right"></i></a>
						</div>
					</div>
				</div>
				<div class="hap-banner-image position-absolute d-flex">
					<span class="hap-banner-shape4 position-absolute wow zoomIn"  data-wow-delay="500ms" data-wow-duration="1500ms" data-parallax='{"y" : 80}'><img src="<?php echo e(asset('assets/homepage/img/home_5/banner/bs4.png')); ?>" alt=""></span>
					<div class="hap-banner-img1 position-relative">
						<div class="hap-banner-img hap-img-animation">
							<img src="<?php echo e(asset('assets/homepage/img/home_5/banner/bn-img2.png')); ?>" alt="">
						</div>
						<span class="hap-banner-shape1 position-absolute wow fadeInLeft"  data-wow-delay="700ms" data-wow-duration="1200ms" ><img src="assets/img/home_5/banner/bs1.png" alt="" data-parallax='{"x" : 50}'></span>
						<span class="hap-banner-shape2 position-absolute wow fadeInUp"  data-wow-delay="800ms" data-wow-duration="1200ms"><img src="assets/img/home_5/banner/bs2.png" alt="" data-parallax='{"x" : -50}'></span>
						<span class="hap-banner-shape3 position-absolute wow fadeInDown"  data-wow-delay="900ms" data-wow-duration="1200ms"><img src="assets/img/home_5/banner/bs3.png" alt="" data-parallax='{"y" : -50}'></span>
					</div>
					<div class="hap-banner-img2 hap-img-animation">
						<img src="<?php echo e(asset('assets/homepage/img/home_5/banner/bn-img1.png')); ?>" alt="">
					</div>
				</div>
			</div>
		</div>
	</section>
<!-- End of Banner section
	============================================= -->

<!-- Start of sponsor section
	============================================= -->
	<section id="hap-sponsor" class="hap-sponsor-section">
		<div class="container">
			<div class="hap-sponsor-content position-relative">
				<div class="row">
					<div class="col-lg-3">
						<div class="hap-section-title hap-headline pera-content">
							<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="300ms" data-wow-duration="1000ms">
								Our Services
							</div>
							<h2 class="tx-split-text split-in-right">Best Of  
							Our Services</h2>
						</div>
					</div>
					<div class="col-lg-9">
						<div class="hap-sponsor-logo-area d-flex flex-wrap">
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp1.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp2.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp5.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp4.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp9.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp6.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp7.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp7.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp3.png')); ?>" alt=""></a>
							</div>
							<div class="sponsor-logo">
								<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/sponsor/sp10.png')); ?>" alt=""></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>	
<!-- End of sponsor section
	============================================= -->

<!-- Start of About section
	============================================= -->
	<section id="hap-about" class="hap-about-section">
		<div class="container">
			<div class="hap-about-content position-relative">
				<div class="hap-about-img-area position-absolute wow slideInLeft"  data-wow-delay="50ms" data-wow-duration="2000ms">
					<span class="about-shape1 position-absolute"><img src="<?php echo e(asset('assets/homepage/img/home_5/shape/sh1.png')); ?>" alt="" data-parallax='{"x" : -50}'></span>
					<span class="about-shape2 position-absolute"><img src="<?php echo e(asset('assets/homepage/img/home_5/shape/sh2.png')); ?>" alt="" data-parallax='{"x" : 50}'></span>
					<div class="about-img">
						<img src="<?php echo e(asset('assets/homepage/img/home_5/about/ab1.png')); ?>" alt="">
					</div>
					<div class="about-exp hap-headline position-absolute">
						<h3><strong class="counter">1000</strong>+</h3>
						<span>Happy Clients</span>
					</div>
				</div>
				<div class="hap-about-text-wrapper d-flex justify-content-end">
					<div class="hap-about-text-area">
						<div class="hap-section-title bins-text hap-headline pera-content">
							<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
								OVER 1000+ CLIENTS
							</div>
							<h2 class="text-uppercase headline-title">creative roblem 
							solving innovations</h2>
							<p>At Afli, we specialize in crafting smart, AI-powered tools to simplify and enhance your digital journey.</p> 
						</div>
						<div class="hap-about-feature-area d-flex justify-content-between flex-wrap position-relative">
							<div class="hap-about-feature-item d-flex align-items-center wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
								<div class="feature-icon">
									<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic1.png')); ?>" alt="">
								</div>
								<div class="feature-text hap-headline">
									<h3>AI-Driven Innovation</h3>
								</div>
							</div>
							<div class="hap-about-feature-item d-flex align-items-center wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
								<div class="feature-icon">
									<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic2.png')); ?>" alt="">
								</div>
								<div class="feature-text hap-headline">
									<h3>AI Website & E-Commerce Solutions</h3>
								</div>
							</div>
							<div class="hap-about-feature-item d-flex align-items-center wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
								<div class="feature-icon">
									<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic3.png')); ?>" alt="">
								</div>
								<div class="feature-text hap-headline">
									<h3>Smart Productivity Tools</h3>
								</div>
							</div>
							<div class="hap-about-feature-item d-flex align-items-center wow fadeInUp"  data-wow-delay="500ms" data-wow-duration="1000ms">
								<div class="feature-icon">
									<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic4.png')); ?>" alt="">
								</div>
								<div class="feature-text hap-headline">
									<h3>Branding & Creativity</h3>
								</div>
							</div>
						</div>
						<div class="hap-btn text-uppercase wow flipInX"  data-wow-delay="500ms" data-wow-duration="1000ms">
							<a href="about.html">about Us <i class="far fa-arrow-right"></i></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>		
<!-- End of About section
	============================================= -->

<!-- Start of Service section
	============================================= -->
	<section id="hap-service" class="hap-service-section position-relative" data-background="<?php echo e(asset('assets/homepage/img/home_5/bg/service-bg.jpg')); ?>">
		<div class="container">
			<div class="hap-section-title hap-headline dark-bg-title text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					AI Driven Solutions
				</div>
				<h2 class="text-uppercase headline-title">We Empower
				Clients to be loved</h2>
			</div>
			<div class="hap-service-content">
				<div class="hap-service-item  hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> AI Website Builder</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="#">Creative</a>
							<a href="#">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html">AI  Social Media Tools</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> Business Cards</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> AI Logo Maker</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> AI Mailbox<a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> AI E-commerce Solutions</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html">AI SEO Services</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> Portfolio Website</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> Domain Selling</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> AI CGI Video</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="<?php echo e(route('cgi.templates')); ?>">Creative</a>
							<a href="<?php echo e(route('cgi.templates')); ?>">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="<?php echo e(route('cgi.templates')); ?>"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
				<div class="hap-service-item hap-img-animation position-relative d-flex justify-content-between">
					<div class="hap-service-title-icon d-flex align-items-center">
						<div class="service-icon">
							<i class="flaticon-profit"></i>
						</div>
						<div class="service-title hap-headline">
							<h3><a  href="portfolio-single.html"> CRM</a></h3>
							<span class="text-uppercase">Guarenteed quality control</span>
						</div>
					</div>
					<div class="hap-service-category-arrow d-flex align-items-center">
						<div class="service-category text-uppercase">
							<a href="portfolio.html">Creative</a>
							<a href="portfolio.html">accessiblilty</a>
						</div>
						<div class="service-arrow">
							<a href="portfolio-single.html"><i class="fas fa-long-arrow-right"></i></a>
						</div>
					</div>
					<div class="service-hover d-none d-md-block"
					data-background="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>"></div>
				</div>
			</div>
			<div class="hap-service-scroll-text-area hap-headline">
				<div class="hap-section-title hap-headline dark-bg-title text-center pera-content">
					<div class="sub-title text-uppercase">
						More than 1000+ companies trusted us worldwide
					</div>
				</div>
				<h2 class="text-uppercase">
					innovated
					<div class="text_scroller_1 scroller_item_1 ul-li">
						<ul>
							<li>AI Website Builder</li>
							<li>AI E-commerce Solutions</li>
							<li>AI Social Media  Tools</li>
							<li>AI Mailbox</li>
							<li>Business Cards</li>
							<li>AI Logo Maker</li>
							<li>AI SEO Services</li>
							<li>Domain Selling</li>
							<li>AI CGI Video</li>
						</ul>
					</div>
					AI Base
				</h2>
				<h2 class="text-uppercase">
					Development <span class="strock_txt"> Experts</span>
					<img src="<?php echo e(asset('assets/homepage/img/home_5/about/sr1.png')); ?>" alt="">
				</h2>
				<h2 class="text-uppercase">
					<span class="text_scroller_2 scroller_item_1 ul-li" data-background="<?php echo e(asset('assets/homepage/img/home_5/bg/scroll-bg.png')); ?>">
						<ul>
							<li>AI Website Builder</li>
							<li>AI E-commerce Solutions</li>
							<li>AI Social Media  Tools</li>
							<li>AI Mailbox</li>
							<li>Business Cards</li>
							<li>AI Logo Maker</li>
							<li>AI SEO Services</li>
							<li>Domain Selling</li>
							<li>AI CGI Video</li>
						</ul>
					</span>
					Developing AI
				</h2>
				<h2 class="text-uppercase">
					<span class="strock_txt">since 2018</span>
					<div class="text_scroller_3 scroller_item_1 ul-li">
						<ul>
							<li>AI Website Builder</li>
							<li>AI E-commerce Solutions</li>
							<li>AI Social Media  Tools</li>
							<li>AI Mailbox</li>
							<li>Business Cards</li>
							<li>AI Logo Maker</li>
							<li>AI SEO Services</li>
							<li>Domain Selling</li>
							<li>AI CGI Video</li>
						</ul>
					</div>
				</h2>
			</div>
		</div>
	</section>			
<!-- End of Service section
	============================================= -->

<!-- Start of Pricing section
	============================================= --
	<section id="hap-pricing" class="hap-pricing-section position-relative">
		<div class="container">
			<div class="hap-section-title hap-headline  text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					web design & development
				</div>
				<h2 class="text-uppercase headline-title">Affordable pricing.
				Easy scaling.</h2>
			</div>
			<div class="hap-pricing-content">
				<div class="hap-pricing-tab-btn ul-li text-center">
					<ul class="nav nav-tabs" id="hap_price_tab" role="tablist">
						<li class="nav-item" role="presentation">
							<div class="nav-link active" id="price_tab_1" data-bs-toggle="tab" data-bs-target="#price_1_1" type="button" role="tab"  aria-selected="false">
								<div class="hap-price-btn-text position-relative">
									Monthly Plans
								</div>
							</div>
						</li>
						<li class="nav-item" role="presentation">
							<div class="nav-link" id="price_tab_2" data-bs-toggle="tab" data-bs-target="#price_1_2" type="button" role="tab"  aria-selected="false">
								<div class="hap-price-btn-text position-relative">
									Yearly Plans
								</div>
							</div>
						</li>
						<li class="nav-item" role="presentation">
							<div class="nav-link" id="price_tab_3" data-bs-toggle="tab" data-bs-target="#price_1_3" type="button" role="tab"  aria-selected="false">
								<div class="hap-price-btn-text position-relative">
									Unlimited Plans
								</div>
							</div>
						</li>
					</ul>
				</div>
				<div class="hap-pricing-tab-content">
					<div class="tab-content" id="hap_price_tab">
						<div class="tab-pane animated fadeInUp show active" id="price_1_1" role="tabpanel" aria-labelledby="price_tab_1">
							<div class="row">
								<div class="col-lg-7">
									<div class="hap-pricing-tab-img-price position-relative">
										<div class="price-img position-relative">
											<img src="assets/img/home_5/about/price1.png" alt="">
										</div>
										<div class="plan-price-title d-flex position-absolute align-items-center">
											<div class="plan-price  d-flex justify-content-center align-items-center flex-wrap text-center hap-headline">
												<div class="price-text">
													<h4>$14.88</h4>
													<span>Monthly</span>
												</div>
											</div>
											<div class="price-plan-title hap-headline">
												<h3>Strategy & Planning</h3>
												<span>10% taxes will include after make price.</span>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-5">
									<div class="hap-pricing-list-area ul-li-block" data-background="assets/img/home_5/bg/price-bg.png">
										<ul>
											<li>Time for lead Research, Work</li>
											<li>Guarenteed Quality Control</li>
											<li>Business Opportunities</li>
											<li>Amazing communication.</li>
										</ul>
										<div class="hap-btn text-uppercase">
											<a href="contact.html">Contact Us <i class="far fa-arrow-right"></i></a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="tab-pane animated fadeInUp" id="price_1_2" role="tabpanel" aria-labelledby="price_tab_2">
							<div class="row">
								<div class="col-lg-7">
									<div class="hap-pricing-tab-img-price position-relative">
										<div class="price-img position-relative">
											<img src="assets/img/home_5/about/price1.png" alt="">
										</div>
										<div class="plan-price-title d-flex position-absolute align-items-center">
											<div class="plan-price  d-flex justify-content-center align-items-center flex-wrap text-center hap-headline">
												<div class="price-text">
													<h4>$14.88</h4>
													<span>Monthly</span>
												</div>
											</div>
											<div class="price-plan-title hap-headline">
												<h3>Strategy & Planning</h3>
												<span>10% taxes will include after make price.</span>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-5">
									<div class="hap-pricing-list-area ul-li-block" data-background="assets/img/home_5/bg/price-bg.png">
										<ul>
											<li>Time for lead Research, Work</li>
											<li>Guarenteed Quality Control</li>
											<li>Business Opportunities</li>
											<li>Amazing communication.</li>
										</ul>
										<div class="hap-btn text-uppercase">
											<a href="contact.html">Contact Us <i class="far fa-arrow-right"></i></a>
										</div>
									</div>
								</div>
							</div>
						</div>
						<div class="tab-pane animated fadeInUp" id="price_1_3" role="tabpanel" aria-labelledby="price_tab_3">
							<div class="row">
								<div class="col-lg-7">
									<div class="hap-pricing-tab-img-price position-relative">
										<div class="price-img position-relative">
											<img src="assets/img/home_5/about/price1.png" alt="">
										</div>
										<div class="plan-price-title d-flex position-absolute align-items-center">
											<div class="plan-price  d-flex justify-content-center align-items-center flex-wrap text-center hap-headline">
												<div class="price-text">
													<h4>$14.88</h4>
													<span>Monthly</span>
												</div>
											</div>
											<div class="price-plan-title hap-headline">
												<h3>Strategy & Planning</h3>
												<span>10% taxes will include after make price.</span>
											</div>
										</div>
									</div>
								</div>
								<div class="col-lg-5">
									<div class="hap-pricing-list-area ul-li-block" data-background="assets/img/home_5/bg/price-bg.png">
										<ul>
											<li>Time for lead Research, Work</li>
											<li>Guarenteed Quality Control</li>
											<li>Business Opportunities</li>
											<li>Amazing communication.</li>
										</ul>
										<div class="hap-btn text-uppercase">
											<a href="contact.html">Contact Us <i class="far fa-arrow-right"></i></a>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
<!-- End of Pricing section
	============================================= -->

<!-- Start of Skill Faq section
	============================================= -->
	<section id="hap-skill-faq" class="hap-skill-faq-section position-relative" data-background="<?php echo e(asset('assets/homepage/img/home_5/bg/skill-bg.jpg')); ?>">
		<div class="container">
			<div class="hap-section-title hap-headline  dark-bg-title text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					Do with Our Products
				</div>
				<h2 class="text-uppercase headline-title">Better design for
				your digital products.</h2>
			</div>
			<div class="hap-skill-content">
				<div class="row">
					<div class="col-lg-6">
						<div class="hap-skill-progress-area">
							<div class="hap-skill-progress-item d-flex align-items-center justify-content-between wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
								<div class="skill-icon-text  d-flex align-items-center">
									<div class="skill-icon d-flex justify-content-center align-items-center">
										<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic5.png')); ?>" alt="">
									</div>
									<div class="skill-text hap-headline pera-content">
										<h3>Revolutionizing Digital Innovation</h3>
										<p>At Afli, we merge creativity and AI to craft tools that empower businesses to thrive in the ever-evolving digital landscape.</p>
										<div class="skill-set-percent headline">
											<div class="progress">
												<div class="progress-bar" data-percent="92"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="skill-arrow">
									<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/icon/arrow.png')); ?>" alt=""></a>
								</div>
							</div>
							<div class="hap-skill-progress-item d-flex align-items-center justify-content-between wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
								<div class="skill-icon-text  d-flex align-items-center">
									<div class="skill-icon d-flex justify-content-center align-items-center">
										<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic6.png')); ?>" alt="">
									</div>
									<div class="skill-text hap-headline pera-content">
										<h3>Build Beyond Boundaries</h3>
										<p>From intuitive website builders to seamless e-commerce solutions, we simplify the complex, letting you focus on what matters—growth.</p>
										<div class="skill-set-percent headline">
											<div class="progress">
												<div class="progress-bar" data-percent="60"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="skill-arrow">
									<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/icon/arrow.png')); ?>" alt=""></a>
								</div>
							</div>
							<div class="hap-skill-progress-item d-flex align-items-center justify-content-between wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
								<div class="skill-icon-text  d-flex align-items-center">
									<div class="skill-icon d-flex justify-content-center align-items-center">
										<img src="<?php echo e(asset('assets/homepage/img/home_5/icon/ic7.png')); ?>" alt="">
									</div>
									<div class="skill-text hap-headline pera-content">
										<h3>Design that Defines You</h3>
										<p>Our AI-driven tools for logo creation, CGI videos, and digital business cards transform your vision into a compelling brand story.
</p>
										<div class="skill-set-percent headline">
											<div class="progress">
												<div class="progress-bar" data-percent="80"></div>
											</div>
										</div>
									</div>
								</div>
								<div class="skill-arrow">
									<a href="#"><img src="<?php echo e(asset('assets/homepage/img/home_5/icon/arrow.png')); ?>" alt=""></a>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-6">
						<div class="hap-skill-img hap-img-animation">
							<img src="<?php echo e(asset('assets/homepage/img/home_5/about/sk1.png')); ?>" alt="">
						</div>
					</div>
				</div>
			</div>
			<div class="hap-faq-content">
				<div class="row">
					<div class="col-lg-6">
						<div class="hap-faq-img-wrapper position-relative d-flex justify-content-end">
							<div class="hap-faq-img1 hap-img-animation">
								<img src="<?php echo e(asset('assets/homepage/img/home_5/about/faq1.png')); ?>" alt="">
							</div>
							<div class="hap-faq-img2 position-absolute hap-img-animation">
								<img src="<?php echo e(asset('assets/homepage/img/home_5/about/faq2.png')); ?>" alt="">
							</div>
						</div>
					</div>
					<!-- 
					<div class="col-lg-6">
						<div class="hap-faq-accordion-area">
							<div class="hap-section-title dark-bg-title hap-headline pera-content">
								<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
									OVER 1000+ CLIENTS
								</div>
								<h2 class="text-capitalize headline-title">We believe that our 
								Works can  to a better world.</h2> 
							</div>
							<div class="hap-accordion" id="accordionExample_31">
								<div class="accordion-item wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
									<h2 class="accordion-header" id="heading10">
										<button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse10" aria-expanded="true" aria-controls="collapse10">
											<span>The Power of Influencer Marketing</span>
										</button>
									</h2>
									<div id="collapse10" class="accordion-collapse collapse show" aria-labelledby="heading10" data-bs-parent="#accordionExample_31">
										<div class="accordion-body ">
											<div class="hap-faq-text">
												On the other hand, We denounce with righteous indignation And Dislike men who are beguiled eos
											</div>
										</div>
									</div>
								</div>
								<div class="accordion-item wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
									<h2 class="accordion-header" id="heading12">
										<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse12" aria-expanded="false" aria-controls="collapse12">
											<span>The Power of Influencer Marketing</span>
										</button>
									</h2>
									<div id="collapse12" class="accordion-collapse collapse" aria-labelledby="heading12" data-bs-parent="#accordionExample_31">
										<div class="accordion-body ">
											<div class="hap-faq-text">
												On the other hand, We denounce with righteous indignation And Dislike men who are beguiled eos
											</div>
										</div>
									</div>
								</div>
								<div class="accordion-item wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
									<h2 class="accordion-header" id="heading13">
										<button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse13" aria-expanded="false" aria-controls="collapse13">
											<span>The Power of Influencer Marketing</span>
										</button>
									</h2>
									<div id="collapse13" class="accordion-collapse collapse" aria-labelledby="heading13" data-bs-parent="#accordionExample_31">
										<div class="accordion-body ">
											<div class="hap-faq-text">
												On the other hand, We denounce with righteous indignation And Dislike men who are beguiled eos
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>		
<!-- End of Skill Faq  section
	============================================= -->


<!-- Start of Portfolio section
	============================================= --
	<section id="hap-portfolio" class="hap-portfolio-section">
		<div class="container">
			<div class="hap-section-title hap-headline  text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					Creative studio
				</div>
				<h2 class="text-uppercase headline-title">Enabling 
					organizations
				</h2>
			</div>
			<div class="hap-portfolio-content">
				<div class="row justify-content-center">
					<div class="col-lg-4 wow fadeInUp"  data-wow-delay="100ms" data-wow-duration="1000ms">
						<div class="hap-portfolio-item">
							<div class="project-img">
								<img src="assets/img/home_5/project/pro1.jpg" alt="">
							</div>
							<div class="project-text hap-headline"> 
								<h3><a class="d-flex justify-content-between" href="portfolio-single.html">Power of Influencer <i class="far fa-long-arrow-right"></i></a></h3>
							</div>
						</div>
					</div>
					<div class="col-lg-4 wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
						<div class="hap-portfolio-item">
							<div class="project-img">
								<img src="assets/img/home_5/project/pro2.jpg" alt="">
							</div>
							<div class="project-text hap-headline"> 
								<h3><a class="d-flex justify-content-between" href="portfolio-single.html">Power of Influencer <i class="far fa-long-arrow-right"></i></a></h3>
							</div>
						</div>
					</div>
					<div class="col-lg-4 wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
						<div class="hap-portfolio-item">
							<div class="project-img">
								<img src="assets/img/home_5/project/pro3.jpg" alt="">
							</div>
							<div class="project-text hap-headline"> 
								<h3><a class="d-flex justify-content-between" href="portfolio-single.html">Power of Influencer <i class="far fa-long-arrow-right"></i></a></h3>
							</div>
						</div>
					</div>
					<div class="col-lg-6 wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
						<div class="hap-portfolio-item">
							<div class="project-img">
								<img src="assets/img/home_5/project/pro4.jpg" alt="">
							</div>
							<div class="project-text hap-headline"> 
								<h3><a class="d-flex justify-content-between" href="portfolio-single.html">Power of Influencer <i class="far fa-long-arrow-right"></i></a></h3>
							</div>
						</div>
					</div>
					<div class="col-lg-6 wow fadeInUp"  data-wow-delay="500ms" data-wow-duration="1000ms">
						<div class="hap-portfolio-item">
							<div class="project-img">
								<img src="assets/img/home_5/project/pro5.jpg" alt="">
							</div>
							<div class="project-text hap-headline"> 
								<h3><a class="d-flex justify-content-between" href="portfolio-single.html">Power of Influencer <i class="far fa-long-arrow-right"></i></a></h3>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
<!-- End of Portfolio section
	============================================= -->

<!-- Start of Team section
	============================================= --
	<section id="hap-team" class="hap-team-section position-relative" data-background="assets/img/home_5/bg/team-bg.jpg">
		<div class="container">
			<div class="hap-section-title hap-headline  text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					web design & development
				</div>
				<h2 class="text-uppercase headline-title">Expert Member
				</h2>
			</div>
			<div class="hap-team-slider-content position-relative"> 
				<div class="hap-team-slider swiper-container">
					<div class="swiper-wrapper">
						<div class="swiper-slide">
							<div class="hap-team-item position-relative">
								<div class="team-img position-relative">
									<img src="assets/img/home_5/team/tm1.png" alt="">
								</div>
								<div class="team-text position-absolute text-center hap-headline text-uppercase">
									<h3><a href="team-single.html">Matt Smith</a></h3>
									<span>Co-Founder</span>
								</div>
							</div>
						</div>
						<div class="swiper-slide">
							<div class="hap-team-item position-relative">
								<div class="team-img position-relative">
									<img src="assets/img/home_5/team/tm2.png" alt="">
								</div>
								<div class="team-text position-absolute text-center hap-headline text-uppercase">
									<h3><a href="team-single.html">Matt Smith</a></h3>
									<span>Co-Founder</span>
								</div>
							</div>
						</div>
						<div class="swiper-slide">
							<div class="hap-team-item position-relative">
								<div class="team-img position-relative">
									<img src="assets/img/home_5/team/tm3.png" alt="">
								</div>
								<div class="team-text position-absolute text-center hap-headline text-uppercase">
									<h3><a href="team-single.html">Matt Smith</a></h3>
									<span>Co-Founder</span>
								</div>
							</div>
						</div>
						<div class="swiper-slide">
							<div class="hap-team-item position-relative">
								<div class="team-img position-relative">
									<img src="assets/img/home_5/team/tm1.png" alt="">
								</div>
								<div class="team-text position-absolute text-center hap-headline text-uppercase">
									<h3><a href="team-single.html">Matt Smith</a></h3>
									<span>Co-Founder</span>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="hap-carousel-arrow-next-prev  d-flex">
					<div class="hap-slider-arrow d-flex justify-content-center align-items-center hap-team-button-prev"><i class="far fa-long-arrow-left"></i></div>
					<div class="hap-slider-arrow d-flex justify-content-center align-items-center hap-team-button-next"><i class="far fa-long-arrow-right"></i></div>
				</div>
			</div>
		</div>
	</section>	
<!-- End of Team section
	============================================= -->

<!-- Start of Counter section
	============================================= --
	<section id="hap-counter" class="hap-counter-section  position-relative">
		<div class="container">
			<div class="hap-counter-content">
				<div class="row justify-content-center">
					<div class="col-lg-3 col-md-6">
						<div class="hap-counter-item position-relative hap-headline pera-content">
							<h3><span class="counter">28</span>K</h3>
							<p>Year Of Experience</p>
						</div>
					</div>
					<div class="col-lg-3 col-md-6">
						<div class="hap-counter-item position-relative hap-headline pera-content">
							<h3><span class="counter">4</span>K</h3>
							<p>Projects Completed</p>
						</div>
					</div>
					<div class="col-lg-3 col-md-6">
						<div class="hap-counter-item position-relative hap-headline pera-content">
							<h3><span class="counter">12</span>K</h3>
							<p>Happy Customers</p>
						</div>
					</div>
					<div class="col-lg-3 col-md-6">
						<div class="hap-counter-item position-relative hap-headline pera-content">
							<h3><span class="counter">17</span>K</h3>
							<p>Happy Customers</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>			
<!-- End of Counter section
	============================================= -->

<!-- Start of Testimonial section
	============================================= --
	<section id="hap-testimonial" class="hap-testimonial-section position-relative" data-background="assets/img/home_5/bg/test-bg.png">
		<div class="container">
			<div class="hap-testimonial-content position-relative">
				<div class="hap-testimonial-slider swiper-container">
					<div class="swiper-wrapper">
						<div class="swiper-slide">
							<div class="hap-testimonial-item d-flex align-items-center justify-content-center">
								<div class="testimoial-img position-relative">
									<img src="assets/img/home_5/about/tst1.png" alt="">
								</div>
								<div class="testimoial-text-author position-relative" data-background="">
									<div class="testimonial-desc">
										On the other hand, We denounce with righteous indignation And Dislike men who are beguiled and demoralized the Charms of Pleasure At vero eos et accusamus et iusto odio Dignis
									</div>
									<div class="testimonial-author hap-headline">
										<h3>Mike Hardson</h3>
										<span>Director</span>
									</div>
								</div>
							</div>
						</div>
						<div class="swiper-slide">
							<div class="hap-testimonial-item d-flex align-items-center justify-content-center">
								<div class="testimoial-img position-relative">
									<img src="assets/img/home_5/about/tst1.png" alt="">
								</div>
								<div class="testimoial-text-author position-relative" data-background="">
									<div class="testimonial-desc">
										On the other hand, We denounce with righteous indignation And Dislike men who are beguiled and demoralized the Charms of Pleasure At vero eos et accusamus et iusto odio Dignis
									</div>
									<div class="testimonial-author hap-headline">
										<h3>Mike Hardson</h3>
										<span>Director</span>
									</div>
								</div>
							</div>
						</div>
						<div class="swiper-slide">
							<div class="hap-testimonial-item d-flex align-items-center justify-content-center">
								<div class="testimoial-img position-relative">
									<img src="assets/img/home_5/about/tst1.png" alt="">
								</div>
								<div class="testimoial-text-author position-relative" data-background="">
									<div class="testimonial-desc">
										On the other hand, We denounce with righteous indignation And Dislike men who are beguiled and demoralized the Charms of Pleasure At vero eos et accusamus et iusto odio Dignis
									</div>
									<div class="testimonial-author hap-headline">
										<h3>Mike Hardson</h3>
										<span>Director</span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="hap-carousel-arrow-next-prev  d-flex">
					<div class="hap-slider-arrow d-flex justify-content-center align-items-center hap-testimonial-button-prev"><i class="far fa-long-arrow-left"></i></div>
					<div class="hap-slider-arrow d-flex justify-content-center align-items-center hap-testimonial-button-next"><i class="far fa-long-arrow-right"></i></div>
				</div>
			</div>
		</div>
	</section>		
<!-- End of Testimonial section
	============================================= -->

<!-- Start of Blog section
	============================================= --
	<section id="hap-blog" class="hap-blog-section position-relative">
		<div class="container">
			<div class="hap-section-title hap-headline  text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					web design & development
				</div>
				<h2 class="text-uppercase headline-title">Affordable pricing.
					Easy scaling.
				</h2>
			</div>
			<div class="hap-blog-content">
				<div class="row justify-content-center">
					<div class="col-lg-4 col-md-6 wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
						<div class="hap-blog-item">
							<div class="blog-img-meta position-relative">
								<div class="blog-img">
									<img src="assets/img/home_5/blog/blg1.png" alt="">
								</div>
								<div class="blog-meta text-uppercase position-absolute">
									30 july 2023
								</div>
							</div>
							<div class="blog-text hap-headline">
								<h3><a href="blog-single.html">Free advertising for your 
								Online business</a></h3>
							</div>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
						<div class="hap-blog-item">
							<div class="blog-img-meta position-relative">
								<div class="blog-img">
									<img src="assets/img/home_5/blog/blg2.png" alt="">
								</div>
								<div class="blog-meta text-uppercase position-absolute">
									30 july 2023
								</div>
							</div>
							<div class="blog-text hap-headline">
								<h3><a href="blog-single.html">Free advertising for your 
								Online business</a></h3>
							</div>
						</div>
					</div>
					<div class="col-lg-4 col-md-6 wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
						<div class="hap-blog-item">
							<div class="blog-img-meta position-relative">
								<div class="blog-img">
									<img src="assets/img/home_5/blog/blg3.png" alt="">
								</div>
								<div class="blog-meta text-uppercase position-absolute">
									30 july 2023
								</div>
							</div>
							<div class="blog-text hap-headline">
								<h3><a href="blog-single.html">Free advertising for your 
								Online business</a></h3>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>		
<!-- End of Blog section
	============================================= -->

<!-- Start of Contact section
	============================================= -->
	<section id="hap-contact" class="hap-contact-section" data-background="<?php echo e(asset('assets/homepage/img/home_5/bg/contact-bg.jpg')); ?>">
		<div class="container">
			<div class="hap-contact-content">
				<div class="row">
					<div class="col-lg-6">
						<div class="hap-contact-form">
							<form action="#" method="get">
								<div class="row">
									<div class="col-md-6">
										<input type="text" name="name" placeholder="Name" id="contactName">
									</div>
									<div class="col-md-6">
										<input type="text" name="email" placeholder="Email" id="contactEmail">
									</div>	
									<div class="col-md-12">
										<div class="hap-contact-select">
											<select id="contactIssue">
												<option value="cgi">CGI</option>
												<option value="ai_website">AI Website</option>
												<option value="ai_social_media_tools">AI Social Media Tools</option>
											</select>
										</div>
									</div>
									<div class="col-md-12">
										<textarea name="massege" id="contactMessage" placeholder="Type Your Query"></textarea>
									</div>
									<div class="col-md-12">
										<button type="button" id="contactUsBtn">Contact Us</button>
									</div>
								</div>
							</form>
						</div>
					</div>
					<div class="col-lg-6">
						<div class="hap-contact-text-area">
							<div class="hap-section-title dark-bg-title bins-text hap-headline  pera-content">
								<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
									Request a free quote
								</div>
								<h2 class="text-uppercase headline-title">make  
									brand As  brilliant One!
								</h2>
								<p>On the other hand, We denounce with righteous indignation And Dislike men who are beguiled eos</p>
							</div>
							<div class="hap-contact-social text-uppercase d-flex wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
								<a href="https://www.facebook.com/Afli.ae"><i class="fab fa-facebook-f"></i> Facebook</a>
								<a href="https://www.instagram.com/afli.ae/"><i class="fab fa-instagram"></i> Instagram</a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>		
<!-- End of Contact section
	============================================= -->

<!-- Start of Topic section
	============================================= -->
	<!-- <section id="hap-topic" class="hap-topic-section">
		<div class="container">
			<div class="hap-section-title hap-headline  text-center pera-content">
				<div class="sub-title text-uppercase wow fadeInRight"  data-wow-delay="200ms" data-wow-duration="1000ms">
					works can contribute
				</div>
				<h2 class="text-uppercase headline-title">Topics Will Enhance 
					Your Skills
				</h2>
			</div>
			<div class="hap-topic-content d-flex justify-content-center">
				<div class="hap-topic-item text-center wow fadeInUp"  data-wow-delay="200ms" data-wow-duration="1000ms">
					<div class="inner-img">
						<img src="assets/img/home_5/icon/tc1.png" alt="">
					</div>
					<div class="inner-text text-uppercase">
						<a href="#">web design</a>
					</div>
				</div>
				<div class="hap-topic-item text-center wow fadeInUp"  data-wow-delay="250ms" data-wow-duration="1000ms">
					<div class="inner-img">
						<img src="assets/img/home_5/icon/tc2.png" alt="">
					</div>
					<div class="inner-text text-uppercase">
						<a href="#">html 5</a>
					</div>
				</div>
				<div class="hap-topic-item text-center wow fadeInUp"  data-wow-delay="300ms" data-wow-duration="1000ms">
					<div class="inner-img">
						<img src="assets/img/home_5/icon/tc3.png" alt="">
					</div>
					<div class="inner-text text-uppercase">
						<a href="#">Wordpress</a>
					</div>
				</div>
				<div class="hap-topic-item text-center wow fadeInUp"  data-wow-delay="350ms" data-wow-duration="1000ms">
					<div class="inner-img">
						<img src="assets/img/home_5/icon/tc4.png" alt="">
					</div>
					<div class="inner-text text-uppercase">
						<a href="#">react</a>
					</div>
				</div>
				<div class="hap-topic-item text-center wow fadeInUp"  data-wow-delay="400ms" data-wow-duration="1000ms">
					<div class="inner-img">
						<img src="assets/img/home_5/icon/tc5.png" alt="">
					</div>
					<div class="inner-text text-uppercase">
						<a href="#">CSS 3</a>
					</div>
				</div>
				<div class="hap-topic-item text-center wow fadeInUp"  data-wow-delay="450ms" data-wow-duration="1000ms">
					<div class="inner-img">
						<img src="assets/img/home_5/icon/tc6.png" alt="">
					</div>
					<div class="inner-text text-uppercase">
						<a href="#">JavaScrip</a>
					</div>
				</div>
			</div>
		</div>
	</section> -->
<!-- End of Topic section
	============================================= -->

<!-- Start of Gallery section
	============================================= -->
	<!-- <section id="hap-gallery" class="hap-gallery-section">
		<div class="hap-gallery-slide">
			<div class="swiper-wrapper">
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins1.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins1.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins2.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins2.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins3.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins3.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins4.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins4.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins5.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins5.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins6.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins6.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins7.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins7.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
				<div class="swiper-slide">
					<div class="hap-gallery-item">
						<img src="assets/img/home_5/instagram/ins8.jpg" alt="">
						<div class="overlay-box d-flex justify-content-center align-items-center">
							<a href="assets/img/home_5/instagram/ins8.jpg" class="lightbox-image plus fab fa-instagram"></a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section> -->
<!-- End of Gallery section
	============================================= -->
</div>
<!-- Start of Footer section
	============================================= -->
	<section id="hap-footer" class="hap-footer-section" data-background="<?php echo e(asset('assets/homepage/img/home_5/bg/footer-bg.jpg')); ?>">
		<div class="hap-footer-content">
			<div class="container">
				<div class="row">
					<div class="col-lg-4">
						<div class="hap-footer-widget hap-headline pera-content">
							<div class="logo-widget">
								<div class="brand-logo">
									<a href="#"><img src="<?php echo e(asset('assets/homepage/img/logo/logo2.png')); ?>" alt=""></a>
								</div>
								<p>Made using clean, non-toxic ingredients, our products are signed for everyone. Made using clean, non-toxic</p>
								<div class="logo-cta ul-li-block">
									<ul>
										<li><a href="#"><i class="fas fa-map-marker-alt"></i> Address:  Dubai Silicon Oasis, DDP, Building A1, Dubai, United Arab Emirates</a></li>
										<li><a href="#"><i class="fas fa-envelope"></i> Email: info@afli.ae</a></li>
										<li><a href="#"><i class="fas fa-phone"></i>Phone: +971 58 242 2625</a></li>
									</ul>
								</div>
								<div class="hap-contact-social text-uppercase d-flex">
									<a href="https://www.facebook.com/Afli.ae"><i class="fab fa-facebook-f"></i> Facebook</a>
									<a href="https://www.instagram.com/afli.ae/"><i class="fab fa-instagram"></i> Instagram</a>
								</div>
							</div>
						</div>
					</div>
					<div class="col-lg-2">
						<div class="hap-footer-widget hap-headline pera-content">
							<div class="menu-widget ul-li-block">
								<h3 class="widget-title text-uppercase">quick links</h3>
								<ul>
									<li><a href="#">FAQ</a></li>
									<li><a href="#">Trems Condition</a></li>
									<li><a href="#">Payment info</a></li>
									<li><a href="#">Privacy Notice</a></li>
									<li><a href="#">Billing</a></li>
								</ul>
							</div>
						</div>
					</div>
					<div class="col-lg-2">
						<div class="hap-footer-widget hap-headline pera-content">
							<div class="menu-widget ul-li-block">
								<h3 class="widget-title text-uppercase">categories</h3>
								<ul>
									<li><a href="#">Services</a></li>
									<li><a href="#">Payment info</a></li>
									<li><a href="#">Billing</a></li>
								</ul>
							</div>
						</div>
					</div>
					<div class="col-lg-4">
						<div class="hap-footer-widget hap-headline pera-content">
							<div class="newslatter-widget">
								<h3 class="widget-title text-uppercase">subcribe</h3>
								<p>You can be always  date with our company news</p>
								<form action="#" method="get">
									<input type="email" name="email" placeholder="Subcribe email">
									<button><i class="fal fa-long-arrow-right"></i></button>
								</form>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>



		<div class="hap-footer-copyright text-center">
			© 2025 Afflictor-FZCO All Rights Reserved.
		</div>
	</section>
<!-- End of Footer section
	============================================= -->							

	<!-- WhatsApp Support Icon -->
	<a href="https://wa.me/+971582422625" target="_blank" class="whatsapp-float">
		<img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp" class="whatsapp-icon">
	</a>


	<!-- For Js Library -->
	<script src="<?php echo e(asset('assets/homepage/js/jquery-3.6.0.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/bootstrap.bundle.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/swiper-bundle.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/appear.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/counter.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/gsap.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/knob.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/jquery.magnific-popup.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/jquery.counterup.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/waypoints.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/parallax.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/ScrollTrigger.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/ScrollToPlugin.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/ScrollSmoother.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/SplitText.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/jquery.filterizr.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/imagesloaded.pkgd.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/hover-revel.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/parallax-scroll.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/jquery.marquee.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/wow.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/tilt.jquery.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/matter.min.js')); ?>"></script>
	<script src="<?php echo e(asset('assets/homepage/js/script.js')); ?>"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.4/jquery-confirm.min.js"></script>

	<script>
		$("#contactUsBtn").on('click',function(){
			var btn = $(this);
			var btn_html = btn.html();
			var name = $("#contactName").val();
			var email =  $("#contactEmail").val();
			var issue = $("#contactIssue").val();
			var msg = $("#contactMessage").val();

			if(!name)
			{
				generalError("Please enter your name");
				return;	
			}
			if(!email)
			{
				generalError("Please enter your email")
				return;
			}
			if(!msg)
			{
				generalError("Please enter your message")
				return;
			}
			var type = $("#contactIssue").val();
			var data = {name:name, email:email, msg:msg, type:type, _token:"<?php echo e(csrf_token()); ?>"};
			var url = "<?php echo e(route('contactus')); ?>";
			btn.html("<i class='fa fa-spinner fa-spin'></i>");
			$.post(url, data, function(data){
				if(!data.result)
				{
					generalError("Some error occured");
					return;	
				}
				btn.html(btn_html);
				
				$("#contactName").val("");
				$("#contactEmail").val("");
				$("#contactMessage").val("");
				successMsg("Message sent successfully")
			}).fail(function(){
				generalError("Some error occured");
			})
		})

		function successMsg(msg)
		{
			$.confirm({
                title:"Success",
                content:msg,
                icon:"fa fa-check-circle",
                type:"green",
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-green',
                        action: function() {
                        }
                    }
                }
            });
		}

		function generalError(msg)
        {
            $.confirm({
                title:"Error",
                content:msg,
                icon:"fa fa-times-circle",
                type:"red",
                buttons: {
                    confirm: {
                        text: 'OK',
                        btnClass: 'btn-red',
                        action: function() {
                        }
                    }
                }
            });
        }
	</script>

</body>
</html>			<?php /**PATH D:\aflisocial\resources\views/homepage/index.blade.php ENDPATH**/ ?>