import { defineConfig } from 'vite'
import laravel from 'laravel-vite-plugin'
import vue from '@vitejs/plugin-vue'
import path from 'path'

export default defineConfig({
  plugins: [
    laravel({
      // 👇 Tell Laravel Vite exactly where your app.js lives
      input: [
        'packages/SocialAi/src/resources/js/app.js',
        // comment out next line if you don’t have a CSS file
        'packages/SocialAi/src/resources/css/app.css',
      ],
      refresh: true,
    }),
    vue(),
  ],

  resolve: {
    alias: {
      '@': path.resolve(__dirname, 'packages/SocialAi/src/resources/js'),
      '@root': path.resolve(__dirname, 'packages/SocialAi/src/resources/js'),
      '@socialai-public': path.resolve(__dirname, 'packages/SocialAi/src/public'), // 👈 added alias
      '@public': path.resolve(__dirname, 'public'),
    },
  },

  build: {
    rollupOptions: {
      // 👇 Ignore Azure import if present anywhere
      external: [],
    },
  },

  server: {
    host: '127.0.0.1',
    port: 5173,
  },
})
