<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('url_visits')) {
            Schema::create('url_visits', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('short_link_id');
                $table->string('ip', 45)->nullable();
                $table->string('country', 64)->nullable();
                $table->string('device', 32)->nullable();
                $table->string('referrer', 255)->nullable();
                $table->text('user_agent')->nullable();
                $table->timestamp('created_at')->nullable()->useCurrent();
                $table->timestamp('updated_at')->nullable()->useCurrent()->useCurrentOnUpdate();

                $table->index('short_link_id');
                $table->foreign('short_link_id')
                      ->references('id')->on('short_links')
                      ->onDelete('cascade');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('url_visits');
    }
};
