<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('short_links')) {
            Schema::create('short_links', function (Blueprint $table) {
                $table->id();
                $table->string('domain');
                $table->text('long_link');
                $table->string('short_link')->unique();
                $table->string('title')->nullable();
                $table->string('backhalf')->nullable();
                $table->unsignedBigInteger('user_id');
                $table->string('password')->nullable();
                $table->string('original_password')->nullable();
                $table->boolean('generate_qr')->default(false);
                $table->boolean('is_paused')->default(true);
                $table->timestamp('expires_at')->nullable();
                $table->timestamps();

                $table->index('user_id');
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            });
        } else {
            Schema::table('short_links', function (Blueprint $table) {
                if (!Schema::hasColumn('short_links', 'password')) {
                    $table->string('password')->nullable()->after('user_id');
                }
                if (!Schema::hasColumn('short_links', 'original_password')) {
                    $table->string('original_password')->nullable()->after('password');
                }
                if (!Schema::hasColumn('short_links', 'generate_qr')) {
                    $table->boolean('generate_qr')->default(false)->after('original_password');
                }
                if (!Schema::hasColumn('short_links', 'is_paused')) {
                    $table->boolean('is_paused')->default(true)->after('generate_qr');
                }
                if (!Schema::hasColumn('short_links', 'expires_at')) {
                    $table->timestamp('expires_at')->nullable()->after('is_paused');
                }
            });
        }
    }

    public function down(): void
    {
        // We do not drop the short_links table here to avoid data loss.
        // If you really want to drop it, uncomment the next line.
        // Schema::dropIfExists('short_links');
    }
};
