@extends('shortlink::app')

@section('css')
<style>
 .card-white{background:#fff;border-radius:14px;box-shadow:0 6px 18px rgba(0,0,0,.1);border:1px solid rgba(0,0,0,.06)}
 .form-switch .form-check-input{cursor:pointer}
</style>
@endsection

@section('content')
<div class="container py-4">
  <div class="betweenflex mt-3">
    <h4 class="text-white">Settings</h4>
    <a href="{{ url('crm/projects/short-links') }}" class="btn btn-dark transparent-btn fs-6">Back</a>
  </div>

  <div class="card-white p-4 mt-3">
    <form action="{{ route('shortlinks.settings.save') }}" method="post">
      @csrf
      <div class="form-check form-switch mb-3">
        <input class="form-check-input" type="checkbox" id="allow_guest_shortening" name="allow_guest_shortening" value="1" {{ !empty($settings->allow_guest_shortening) ? 'checked' : '' }}>
        <label class="form-check-label" for="allow_guest_shortening">Allow Guest Shortening</label>
        <div class="text-muted small">If ON, users not logged in can create short links.</div>
      </div>

      <div class="form-check form-switch mb-3">
        <input class="form-check-input" type="checkbox" id="allow_password_protection" name="allow_password_protection" value="1" {{ !empty($settings->allow_password_protection) ? 'checked' : '' }}>
        <label class="form-check-label" for="allow_password_protection">Allow Password Protection</label>
        <div class="text-muted small">Enable/disable password field in shorten form.</div>
      </div>

      <div class="mb-3">
        <label class="form-label">Blocklisted Domains</label>
        <textarea name="blocklisted_domains" rows="4" class="form-control" placeholder="example.com, bad.com">{{ $settings->blocklisted_domains }}</textarea>
        <div class="text-muted small">Comma-separated list of domains that can’t be shortened.</div>
      </div>

      <div class="text-end">
        <button class="btn btn-primary">Save Settings</button>
      </div>
    </form>
  </div>
</div>
@endsection
