<?php 

use Illuminate\Support\Facades\Route;
use ShortLink\Http\Controllers\ShortLinkController;


Route::get('s/{link}', [ShortLinkController::class, 'shortLinkRedirect']);
Route::match(['get','post'],'go/{slug}', [ShortLinkController::class, 'goRedirect']);

// Routes accessible to both guests and authenticated users (access controlled by controller)
Route::middleware(['web'])->group(function () {
    Route::get('crm/projects/short-links/create', [ShortLinkController::class, 'create']);
    Route::post('crm/projects/short-links', [ShortLinkController::class, 'store'])->name('shortlinks.store');
});

// Protected routes for authenticated users only
Route::middleware(['auth', 'web', 'role:1,2'])->group(function () {
    Route::prefix('crm')->group(function () {
        Route::prefix('projects')->group(function () {
            Route::get('shorter_link', [ShortLinkController::class, 'index']);
            Route::post('add-shorter-link', [ShortLinkController::class, 'addShorterLink']);
            Route::get('short-links', [ShortLinkController::class, 'shortLinks']);
            Route::get('short-links/dashboard', [ShortLinkController::class, 'dashboard'])->name('shortlinks.dashboard');
            // Settings page
            Route::get('short-links/settings', [ShortLinkController::class, 'settings'])->name('shortlinks.settings');
            Route::post('short-links/settings', [ShortLinkController::class, 'saveSettings'])->name('shortlinks.settings.save');
            // Specific routes must come BEFORE the catch-all {id}
            // Note: Create and store routes are already defined above for public access
            Route::get('short-links/result/{id}', [ShortLinkController::class, 'result'])->name('shortlinks.result');
            Route::get('short-links/stats/{id}', [ShortLinkController::class, 'stats'])->name('shortlinks.stats');
            // Resource-style endpoints
            Route::get('short-links/{id}', [ShortLinkController::class, 'show'])->name('shortlinks.show');
            Route::get('short-links/{id}/edit', [ShortLinkController::class, 'edit'])->name('shortlinks.edit');
            Route::put('short-links/{id}', [ShortLinkController::class, 'update'])->name('shortlinks.update');
            Route::delete('short-links/{id}', [ShortLinkController::class, 'destroy'])->name('shortlinks.destroy');
            // Pause/Resume
            Route::post('short-links/{id}/pause', [ShortLinkController::class, 'pause'])->name('shortlinks.pause');
            Route::post('short-links/{id}/resume', [ShortLinkController::class, 'resume'])->name('shortlinks.resume');
            Route::post('delete-short-link', [ShortLinkController::class, 'deleteShortLink']);
            Route::post('delete_api_short_link', [ShortLinkController::class, 'deleteShortLinkViaApi']);
        });
    });
});