<?php

namespace JeroenNoten\LaravelAdminLte\View\Components\Form;

class SelectBs extends InputGroupComponent
{
    use Traits\OldValueSupportTrait;

    /**
     * The bootstrap-select plugin configuration parameters. Array with
     * 'key => value' pairs, where the key should be an existing configuration
     * property of the bootstrap-select plugin.
     *
     * @var array
     */
    public $config;

    /**
     * Create a new component instance.
     * Note this component requires the 'bootstrap-select' plugin.
     *
     * @return void
     */
    public function __construct(
        $name, $id = null, $label = null, $igroupSize = null, $labelClass = null,
        $fgroupClass = null, $igroupClass = null, $disableFeedback = null,
        $errorKey = null, $config = [], $enableOldSupport = null
    ) {
        parent::__construct(
            $name, $id, $label, $igroupSize, $labelClass, $fgroupClass,
            $igroupClass, $disableFeedback, $errorKey
        );

        $this->config = is_array($config) ? $config : [];
        $this->enableOldSupport = isset($enableOldSupport);
    }

    /**
     * Make the class attribute for the input group item. Note we overwrite
     * the method of the parent class.
     *
     * @return string
     */
    public function makeItemClass()
    {
        $classes = ['form-control'];

        if ($this->isInvalid()) {
            $classes[] = 'is-invalid';
        }

        // The next workaround setups the plugin when using sm/lg sizes.
        // Note: this may change with newer plugin versions.

        if (isset($this->size) && in_array($this->size, ['sm', 'lg'])) {
            $classes[] = "form-control-{$this->size}";
            $classes[] = 'p-0';
        }

        return implode(' ', $classes);
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\View\View|string
     */
    public function render()
    {
        return view('adminlte::components.form.select-bs');
    }
}
